/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.stat;

import java.util.Enumeration;
import whatap.agent.Logger;
import whatap.agent.conf.ConfMTrace;
import whatap.agent.conf.ConfStat;
import whatap.agent.data.DataPackSender;
import whatap.agent.data.DataTextAgent;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.StatGeneralPack;
import whatap.lang.pack.TimeCount;
import whatap.util.IntList;
import whatap.util.LinkedMap;
import whatap.util.LongList;
import whatap.util.StringUtil;

public class StatTranxMtCaller {
    private static StatTranxMtCaller instance;
    private final int TABLE_MAX_SIZE = 7000;
    private final LinkedMap<KEY, TimeCount> table = new LinkedMap<KEY, TimeCount>(7001, 1.0f){

        @Override
        protected TimeCount create(KEY key) {
            if (this.isFull()) {
                return null;
            }
            return new TimeCount();
        }
    }.setMax(7000);

    public static synchronized StatTranxMtCaller getInstance() {
        if (instance == null) {
            instance = new StatTranxMtCaller();
        }
        return instance;
    }

    public StatTranxMtCaller() {
        this.table.setMax(ConfMTrace.stat_mtrace_max_count);
        ConfObserver.add("StastTranxMtCaller", new Runnable(){

            public void run() {
                StatTranxMtCaller.this.table.setMax(ConfMTrace.stat_mtrace_max_count);
            }
        });
    }

    public TimeCount getService(KEY key) {
        return this.table.intern(key);
    }

    protected void send(long now) {
        if (this.table.size() == 0) {
            return;
        }
        try {
            StatGeneralPack out;
            if (StringUtil.isNotEmpty(ConfMTrace.mtrace_spec)) {
                DataTextAgent.MTRACE_SPEC.add(ConfMTrace.mtrace_spec_hash, ConfMTrace.mtrace_spec);
            }
            LongList caller_pcode = new LongList(this.table.size());
            IntList caller_okind = new IntList(this.table.size());
            IntList caller_spec = new IntList(this.table.size());
            IntList caller_url = new IntList(this.table.size());
            IntList this_spec = new IntList(this.table.size());
            IntList url = new IntList(this.table.size());
            IntList count = new IntList(this.table.size());
            IntList error = new IntList(this.table.size());
            LongList time = new LongList(this.table.size());
            Enumeration<LinkedMap.LinkedEntry<KEY, TimeCount>> en = this.table.entries();
            while (en.hasMoreElements()) {
                LinkedMap.LinkedEntry<KEY, TimeCount> ent = en.nextElement();
                KEY k = ent.getKey();
                TimeCount v = ent.getValue();
                caller_pcode.add(k.caller_pcode);
                caller_okind.add(k.caller_okind);
                caller_spec.add(k.caller_spec);
                caller_url.add(k.caller_url);
                this_spec.add(ConfMTrace.mtrace_spec_hash);
                url.add(k.url);
                count.add(v.count);
                error.add(v.error);
                time.add(v.time);
            }
            this.table.clear();
            if (ConfStat.stat_1m_enabled) {
                out = new StatGeneralPack(2321);
                out.dataStartTime = now - 60000L;
            } else {
                out = new StatGeneralPack();
            }
            out.put("caller_pcode", caller_pcode);
            out.put("caller_okind", caller_okind);
            out.put("caller_spec", caller_spec);
            out.put("caller_url", caller_url);
            out.put("spec", this_spec);
            out.put("url", url);
            out.put("count", count);
            out.put("error", error);
            out.put("time", time);
            out.id = "mt";
            out.time = now;
            DataPackSender.send(out);
        }
        catch (Exception e) {
            Logger.println("A203", 10, e.toString());
        }
    }

    protected void clear() {
        this.table.clear();
    }

    public int size() {
        return this.table.size();
    }

    public static class KEY {
        public long caller_pcode;
        public int caller_okind;
        public int caller_spec;
        public int caller_url;
        public int url;
        private int _hash_;

        public int hashCode() {
            if (this._hash_ != 0) {
                return this._hash_;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.caller_pcode ^ this.caller_pcode >>> 32);
            result = 31 * result + this.caller_okind;
            result = 31 * result + this.caller_spec;
            result = 31 * result + this.caller_url;
            this._hash_ = result = 31 * result + this.url;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            KEY other = (KEY)obj;
            if (this.caller_pcode != other.caller_pcode) {
                return false;
            }
            if (this.caller_okind != other.caller_okind) {
                return false;
            }
            if (this.caller_spec != other.caller_spec) {
                return false;
            }
            if (this.caller_url != other.caller_url) {
                return false;
            }
            return this.url == other.url;
        }
    }
}

