/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.stat;

import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfStat;
import whatap.agent.data.DataPackSender;
import whatap.agent.data.DataTextAgent;
import whatap.agent.data.ZipPackThread;
import whatap.agent.stat.ErrorArg;
import whatap.agent.trace.sql.TraceSQL;
import whatap.agent.util.LeakErrorData;
import whatap.agent.util.StackDumpUtil;
import whatap.agent.warning.ExceptionWarning;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.ErrorSnapPack1;
import whatap.lang.pack.StatErrorPack;
import whatap.util.BitUtil;
import whatap.util.HashUtil;
import whatap.util.KeyGen;
import whatap.util.LongKeyLinkedMap;
import whatap.util.StringUtil;

public class StatError {
    private static StatError instance;
    private final int TABLE_MAX_SIZE = 1000;
    private final LongKeyLinkedMap<StatErrorPack.ErrorRec> table = new LongKeyLinkedMap(1001, 1.0f).setMax(1000);
    Configure conf = Configure.getInstance();

    public static synchronized StatError getInstance() {
        if (instance == null) {
            instance = new StatError();
        }
        return instance;
    }

    public StatError() {
        this.table.setMax(ConfStat.stat_error_max_count);
        ConfObserver.add("StatError", new Runnable(){

            public void run() {
                StatError.this.table.setMax(ConfStat.stat_error_max_count);
            }
        });
    }

    private long nextErrorSnapId() {
        return KeyGen.next();
    }

    public long addHashOnly(Throwable thr, String msg) {
        try {
            String class1 = thr.getClass().getName();
            int classHash = HashUtil.hash(class1);
            DataTextAgent.ERROR.add(classHash, class1);
            msg = StringUtil.trimEmpty(msg);
            msg = StringUtil.truncate(msg, 200);
            int msgHash = HashUtil.hash(msg);
            DataTextAgent.ERROR.add(msgHash, msg);
            return BitUtil.composite(classHash, msgHash);
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    public long addJdbcLeak(ErrorArg arg, StackTraceElement[] stack) {
        try {
            long key;
            StatErrorPack.ErrorRec rec;
            arg.build();
            if (this.conf.exception_enabled) {
                ExceptionWarning.getInstance().addError(arg);
            }
            if ((rec = this.table.get(key = BitUtil.composite(arg.classNameHash, arg.serviceHash))) == null) {
                rec = new StatErrorPack.ErrorRec();
                this.table.put(key, rec);
                rec.classHash = arg.classNameHash;
                rec.service = arg.serviceHash;
                rec.msg = arg.messageHash;
            }
            if (rec.errorSnapId == 0L && this.conf.error_snap_enabled) {
                try {
                    ErrorSnapPack1 p = new ErrorSnapPack1();
                    rec.errorSnapId = p.errorSnapId = this.nextErrorSnapId();
                    rec.msg = arg.messageHash;
                    if (stack != null && stack.length > 0) {
                        p.setStack(StackDumpUtil.stack(stack, this.conf.trace_error_callstack_depth));
                    }
                    p.append_type = arg.appendType;
                    p.append_hash = arg.appendHash;
                    DataPackSender.send(p);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++rec.count;
            arg.txErrorCode = BitUtil.composite(arg.classNameHash, arg.messageHash);
            return arg.txErrorCode;
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    public long addError(ErrorArg arg) {
        try {
            long key;
            StatErrorPack.ErrorRec rec;
            boolean isWhatap = arg.build();
            if (this.conf.exception_enabled) {
                ExceptionWarning.getInstance().addError(arg);
            }
            if ((rec = this.table.get(key = BitUtil.composite(arg.classNameHash, arg.serviceHash))) == null) {
                rec = new StatErrorPack.ErrorRec();
                this.table.put(key, rec);
                rec.classHash = arg.classNameHash;
                rec.service = arg.serviceHash;
                rec.msg = arg.messageHash;
            }
            if (rec.errorSnapId == 0L && this.conf.error_snap_enabled) {
                try {
                    ErrorSnapPack1 p = new ErrorSnapPack1();
                    rec.errorSnapId = p.errorSnapId = this.nextErrorSnapId();
                    rec.msg = arg.messageHash;
                    if (!isWhatap) {
                        p.setStack(StackDumpUtil.getStack(arg.exception, this.conf.trace_error_callstack_depth));
                    }
                    p.append_type = arg.appendType;
                    p.append_hash = arg.appendHash;
                    DataPackSender.send(p);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++rec.count;
            arg.txErrorCode = BitUtil.composite(arg.classNameHash, arg.messageHash);
            return arg.txErrorCode;
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    public long addErrorSimple(ErrorArg arg) {
        try {
            arg.buildSimple();
            long key = BitUtil.composite(arg.classNameHash, arg.serviceHash);
            StatErrorPack.ErrorRec rec = this.table.get(key);
            if (rec == null) {
                rec = new StatErrorPack.ErrorRec();
                this.table.put(key, rec);
                rec.classHash = arg.classNameHash;
                rec.service = arg.serviceHash;
                rec.msg = arg.messageHash;
            }
            ++rec.count;
            arg.txErrorCode = BitUtil.composite(arg.classNameHash, arg.messageHash);
            return arg.txErrorCode;
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    public void addError(LeakErrorData leak) {
        try {
            long key;
            StatErrorPack.ErrorRec rec;
            String class1 = leak.error.getClass().getName();
            int sqlError = TraceSQL.isql.getErrorCode(leak.error);
            if (sqlError > 0) {
                class1 = class1 + "(" + sqlError + ")";
            }
            int classHash = HashUtil.hash(class1);
            String msg = leak.txid != 0L ? leak.error.getMessage() + ",txid=" + leak.txid + ",time=" + new Date(leak.time) : leak.error.getMessage();
            int msgHash = HashUtil.hash(msg);
            DataTextAgent.ERROR.add(classHash, class1);
            DataTextAgent.ERROR.add(msgHash, msg);
            if (this.conf.exception_enabled) {
                ErrorArg t = new ErrorArg();
                t.exception = leak.error;
                t.className = class1;
                t.classNameHash = classHash;
                t.serviceHash = leak.service;
                t.message = msg;
                t.messageHash = msgHash;
                ExceptionWarning.getInstance().addError(t);
            }
            if ((rec = this.table.get(key = BitUtil.composite(classHash, leak.service))) == null) {
                rec = new StatErrorPack.ErrorRec();
                this.table.put(key, rec);
                rec.classHash = classHash;
                rec.service = leak.service;
                rec.msg = msgHash;
            }
            if (rec.errorSnapId == 0L && this.conf.error_snap_enabled) {
                try {
                    ErrorSnapPack1 p = new ErrorSnapPack1();
                    rec.errorSnapId = p.errorSnapId = this.nextErrorSnapId();
                    rec.msg = msgHash;
                    if (leak.profile != null) {
                        p.setProfile(leak.profile);
                    }
                    if (leak.canStackTrace) {
                        StackTraceElement[] stack = leak.error.getStackTrace();
                        if (stack.length > 2) {
                            StackTraceElement[] newStack = new StackTraceElement[stack.length - 2];
                            System.arraycopy(stack, 2, newStack, 0, newStack.length);
                            stack = newStack;
                        }
                        p.setStack(StackDumpUtil.stack(stack, Configure.getInstance().trace_error_callstack_depth));
                    }
                    DataPackSender.send(p);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++rec.count;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addError(String class1, String msg, Throwable err) {
        try {
            int classHash = HashUtil.hash(class1);
            int msgHash = HashUtil.hash(msg);
            DataTextAgent.ERROR.add(classHash, class1);
            DataTextAgent.ERROR.add(msgHash, msg);
            long key = BitUtil.composite(classHash, 0);
            StatErrorPack.ErrorRec rec = this.table.get(key);
            if (rec == null) {
                rec = new StatErrorPack.ErrorRec();
                this.table.put(key, rec);
                rec.classHash = classHash;
                rec.service = 0;
                rec.msg = msgHash;
            }
            ++rec.count;
            if (rec.errorSnapId == 0L && err != null && this.conf.error_snap_enabled) {
                try {
                    ErrorSnapPack1 p = new ErrorSnapPack1();
                    rec.errorSnapId = p.errorSnapId = this.nextErrorSnapId();
                    rec.msg = msgHash;
                    StackTraceElement[] stack = err.getStackTrace();
                    if (stack.length > 2) {
                        StackTraceElement[] newStack = new StackTraceElement[stack.length - 2];
                        System.arraycopy(stack, 2, newStack, 0, newStack.length);
                        stack = newStack;
                    }
                    p.setStack(StackDumpUtil.stack(stack, Configure.getInstance().trace_error_callstack_depth));
                    DataPackSender.send(p);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void send(long now) {
        if (this.table.size() == 0) {
            return;
        }
        try {
            StatErrorPack p;
            ArrayList<StatErrorPack.ErrorRec> out = new ArrayList<StatErrorPack.ErrorRec>(this.table.size() + 10);
            Enumeration<StatErrorPack.ErrorRec> en = this.table.values();
            while (en.hasMoreElements()) {
                out.add(en.nextElement());
            }
            this.table.clear();
            if (ConfStat.stat_1m_enabled) {
                p = new StatErrorPack(3073);
                p.dataStartTime = now - 60000L;
            } else {
                p = new StatErrorPack();
            }
            p.setRecords(out);
            p.time = now;
            if (ConfStat.stat_zip_enabled) {
                ZipPackThread.getInstance().add(p);
            } else {
                DataPackSender.send(p);
            }
        }
        catch (Exception e) {
            Logger.println("A201", 10, e.toString());
        }
    }

    protected void clear() {
        this.table.clear();
    }

    public int size() {
        return this.table.size();
    }
}

