/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.setup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import whatap.ASMVersion;
import whatap.Version;
import whatap.agent.asm.IASM;
import whatap.agent.boot.AgentBoot;
import whatap.agent.logo.Logo;
import whatap.agent.setup.ShellArg1;
import whatap.util.FileUtil;
import whatap.util.FormatUtil;
import whatap.util.JarUtil;
import whatap.util.SystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveWeaving {
    public static boolean isDebugMode = false;
    public static boolean isErrorMode = false;
    public static boolean cmdHelp = false;
    public static boolean cmdList = false;
    public static boolean cmdRemove = false;
    public static boolean show_dir = false;
    public static boolean show_file = false;
    private static LinkedHashSet<String> removeShell = new LinkedHashSet();
    private static LinkedHashSet<String> removed = new LinkedHashSet();
    private static URL classUrlPath;
    private static String jarFilePathFullName;
    private static String jarFileName;
    private static String jarFilePath;

    public static void main(String[] args) {
        boolean forceHelp;
        RemoveWeaving.printLogo();
        ShellArg1 sh = new ShellArg1(args);
        cmdHelp = sh.getHelp("help");
        cmdList = sh.getList("list");
        cmdRemove = sh.getRemove("remove");
        isDebugMode = sh.getDebug("debug");
        removeShell = sh.getRemoveSet("remove");
        boolean bl = forceHelp = !cmdHelp && !cmdList && !cmdRemove;
        if (forceHelp) {
            cmdHelp = true;
        }
        if (cmdHelp) {
            RemoveWeaving.printHelp();
            RemoveWeaving.endProcess();
        }
        RemoveWeaving.getJarFilePath();
        if (isDebugMode) {
            System.out.println("jar path full name: " + jarFilePathFullName);
            System.out.println("jar path: " + jarFilePath);
            System.out.println("jar filename: " + jarFileName);
            System.out.println();
        }
        if (cmdList) {
            RemoveWeaving.printWeavingList();
            RemoveWeaving.endProcess();
        }
        if (isDebugMode) {
            System.out.println();
            if (args == null) {
                System.out.println("Java args: " + args);
                System.out.println();
            } else {
                int s = args.length - 1;
                System.out.print("Java args: [");
                for (int i = 0; i < args.length; ++i) {
                    System.out.print(args[i]);
                    if (i >= s) continue;
                    System.out.print(",");
                }
                System.out.println("]");
                System.out.println("Remove set: " + removeShell);
                System.out.println();
            }
        }
        if (removeShell == null) {
            System.out.println("Insert weaving jar filename");
            RemoveWeaving.printOfferSwitchList();
            if (!isDebugMode) {
                RemoveWeaving.printOfferSwitchDebug();
            }
            RemoveWeaving.endProcess();
        }
        File fromFile = new File(jarFilePathFullName);
        String newFileDirectory = jarFilePath + "/out";
        File toFile = new File(newFileDirectory);
        boolean directoryCreated = toFile.mkdir();
        if (directoryCreated) {
            System.out.println();
            System.out.println("Successfully created directory: " + newFileDirectory);
            System.out.println();
        } else {
            if (toFile != null) {
                if (toFile.exists()) {
                    System.out.println("Directory exists: " + newFileDirectory);
                } else {
                    System.out.println("Failed to created directory: " + newFileDirectory);
                }
            }
            System.out.println();
        }
        String newJarFileFullPath = newFileDirectory + "/" + jarFileName;
        toFile = new File(newJarFileFullPath);
        if (toFile.exists()) {
            System.out.println("Agent file " + toFile.getName() + " already exits in " + toFile.getPath());
            if (!isDebugMode) {
                RemoveWeaving.printOfferSwitchDebug();
            }
            RemoveWeaving.endProcess();
        }
        if (!toFile.getName().endsWith(".jar")) {
            System.out.println("Failed to create file " + toFile.getName());
            if (!isDebugMode) {
                RemoveWeaving.printOfferSwitchDebug();
            }
            RemoveWeaving.endProcess();
        }
        HashSet<String> removeSet = new HashSet<String>();
        HashSet<String> removeAst = new HashSet<String>();
        Iterator it = removeShell.iterator();
        for (int i = 0; i < removeShell.size(); ++i) {
            String next = (String)it.next();
            if (next == null) continue;
            if (next.endsWith("*")) {
                removeAst.add("weaving/" + next.substring(0, next.length() - 1));
                continue;
            }
            if (!next.endsWith(".jar")) {
                next = next + ".jar";
            }
            removeSet.add("weaving/" + next);
        }
        if (removeSet.size() == 0 && removeAst.size() == 0) {
            System.out.println();
            System.out.println("No remove set");
            System.out.println();
            if (!isDebugMode) {
                RemoveWeaving.printOfferSwitchDebug();
            }
            RemoveWeaving.endProcess();
        }
        if (isDebugMode) {
            Iterator<String> itr;
            LinkedList<String> list = new LinkedList<String>();
            if (removeAst != null && removeAst.size() > 0 && (itr = removeAst.iterator()).hasNext()) {
                list.add(itr.next());
            }
            if (removeSet != null && removeSet.size() > 0 && (itr = removeSet.iterator()).hasNext()) {
                list.add(itr.next());
            }
            System.out.print("Remove set: ");
            int s = list.size();
            for (int i = 0; i < list.size(); ++i) {
                System.out.print((String)list.get(i));
                if (i >= s - 1) continue;
                System.out.print(",");
            }
            System.out.println();
            System.out.println();
        }
        RemoveWeaving.process(fromFile, toFile, removeSet, removeAst);
        System.out.println("  Org Agent: " + fromFile.getName() + " " + FormatUtil.print(fromFile.length(), "#,##0") + " bytes");
        System.out.println("  New Agent: " + toFile.getName() + " " + FormatUtil.print(toFile.length(), "#,##0") + " bytes");
        System.out.println("             created successfully in " + newFileDirectory);
        if (isDebugMode) {
            System.out.println();
            System.out.println("Removed: " + removed);
        }
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            RemoveWeaving.printError(e);
        }
        System.out.println();
        RemoveWeaving.endProcess();
    }

    private static void printError(Exception e) {
        System.out.println(e.getMessage());
        if (!isDebugMode) {
            RemoveWeaving.printOfferSwitchDebug();
        }
        if (!isErrorMode) {
            RemoveWeaving.printOfferSwitchError();
        }
        if (isErrorMode) {
            e.printStackTrace();
        }
    }

    private static void printOfferSwitchError() {
        System.out.println("\nTo see full stack trace of the error, re-run with the -e or -error switch\n");
    }

    private static void printOfferSwitchDebug() {
        System.out.println("\nTo see debug logging, re-run with the -d or -debug switch\n");
    }

    private static void printOfferSwitchList() {
        System.out.println("\nTo see weaving list, re-run with the -l or -list switch\n");
    }

    private static void printHelp() {
        System.out.printf("%n", new Object[0]);
        System.out.printf("%6s java -cp %s %s %s %s%n%n", "Usage:", "[whatap java agent]", "whatap.agent.setup.RemoveWeaving", "[arguments]", "[weaving jar filename]");
        System.out.printf("%6s java -cp %s %s %s %s%n%n", "", "whatap.agent-2.2.37.jar", "whatap.agent.setup.RemoveWeaving", "-remove", "spring-boot-2.5.jar spring-boot-2.7.jar");
        System.out.printf("%s%n", "Arguments:");
        System.out.printf("%-1s %-23s %7s%n", "", "-r  or  -remove", "Remove weaving jar file from java agent and create a new java agent");
        System.out.printf("%-1s %-23s %7s%n", "", "-l  or  -list", "Print list of weaving jar files");
        System.out.printf("%-1s %-23s %7s%n", "", "-d  or  -debug", "Enable debug logging");
        System.out.printf("%-1s %-23s %7s%n", "", "-e  or  -error", "Show full stack trace of the error");
        System.out.printf("%-1s %-23s %7s%n", "", "-h  or  -help", "Print Help (this message) and exit");
        System.out.printf("%n", new Object[0]);
    }

    private static void endProcess() {
        System.exit(1);
    }

    private static void printWeavingList() {
        try {
            JarFile jf = new JarFile(jarFilePathFullName);
            Enumeration<JarEntry> en = jf.entries();
            TreeSet<String> displayName = new TreeSet<String>();
            int cutIndex = "weaving/".length();
            while (en.hasMoreElements()) {
                JarEntry e = en.nextElement();
                String name = e.getName();
                if (!name.startsWith("weaving/") || name.indexOf("ebs") > 0 || name.indexOf("hana") > 0 || name.indexOf("hmns") > 0 || name.indexOf("kst") > 0 || name.indexOf("lotte") > 0 || name.indexOf("sk.dcb") > 0 || name.indexOf("uclik") > 0 || name.indexOf("uplus") > 0) continue;
                displayName.add(e.getName().substring(cutIndex));
            }
            if (displayName.size() > 0) {
                String[] displayArr = displayName.toArray(new String[displayName.size()]);
                for (int i = 0; i < displayArr.length; ++i) {
                    System.out.println(displayArr[i]);
                }
            }
        }
        catch (IOException e) {
            RemoveWeaving.printError(e);
        }
        System.out.println();
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void printLogo() {
        InputStream in = null;
        try {
            String whatap_logo = System.getProperty("whatap.logo", "whatap.logo");
            in = Logo.class.getResourceAsStream(whatap_logo);
            if (in == null) {
                FileUtil.close(in);
                return;
            }
            System.out.print("\u001b[33m");
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            String line = reader.readLine();
            while (line != null) {
                System.out.println(line);
                line = reader.readLine();
            }
            System.out.print("\u001b[0m");
            System.out.print("\u001b[32m");
            System.out.println("WhaTap v" + Version.getFullVersion());
            System.out.println("Java " + SystemUtil.JAVA_VERSION + " asmlib" + ASMVersion.version + " " + IASM.getAsm());
            System.out.print("\u001b[0m");
            System.out.println(JarUtil.getJarFileName(AgentBoot.class));
            FileUtil.close(in);
        }
        catch (Exception e) {
            RemoveWeaving.printError(e);
        }
        finally {
            FileUtil.close(in);
        }
        System.out.println();
    }

    private static void getJarFilePath() {
        URL url = RemoveWeaving.getURL(RemoveWeaving.class.getName(), "whatap/agent/setup/RemoveWeaving.class");
        String jarFilePathFullNameTmp = RemoveWeaving.getFilePathFromURL(url);
        if (jarFilePathFullNameTmp == null) {
            return;
        }
        int sub = jarFilePathFullNameTmp.indexOf("!");
        if (sub < 0) {
            return;
        }
        jarFilePathFullNameTmp = jarFilePathFullNameTmp.substring(0, sub);
        try {
            jarFilePathFullNameTmp = URLDecoder.decode(jarFilePathFullNameTmp, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            RemoveWeaving.printError(e);
        }
        jarFilePathFullName = jarFilePathFullNameTmp.replace('\\', '/');
        int cut = jarFilePathFullNameTmp.lastIndexOf("/");
        if (cut < 0) {
            return;
        }
        jarFileName = jarFilePathFullNameTmp.substring(cut + 1);
        jarFilePath = jarFilePathFullNameTmp.substring(0, cut);
    }

    private static String getFilePathFromURL(URL url) {
        String uriStr = null;
        try {
            uriStr = url.toURI().toString();
        }
        catch (URISyntaxException e) {
            RemoveWeaving.printError(e);
        }
        assert (uriStr != null);
        String result = uriStr.startsWith("jar:") ? uriStr.substring("jar:file:".length()) : (uriStr.startsWith("file:") ? uriStr.substring("file:".length()) : uriStr);
        return result;
    }

    private static URL getURL(String className, String fileName) {
        try {
            Class<?> clazz = Class.forName(className);
            ClassLoader classLoader = clazz.getClassLoader();
            classUrlPath = classLoader.getResource(fileName);
        }
        catch (ClassNotFoundException e) {
            RemoveWeaving.printError(e);
        }
        if (isDebugMode) {
            System.out.println("class name: " + className);
            System.out.println("class url: " + classUrlPath);
            System.out.println();
        }
        assert (classUrlPath != null);
        return classUrlPath;
    }

    private static void process(File fromFile, File toFile, HashSet<String> removeSet, HashSet<String> removeAst) {
        try {
            JarFile jf = new JarFile(fromFile);
            JarOutputStream os = new JarOutputStream(new FileOutputStream(toFile));
            Enumeration<JarEntry> en = jf.entries();
            boolean hasAst = false;
            if (removeAst != null && removeAst.size() > 0) {
                hasAst = true;
            }
            while (en.hasMoreElements()) {
                JarEntry e = en.nextElement();
                boolean skip = false;
                if (hasAst) {
                    for (String astarisk : removeAst) {
                        if (!e.getName().startsWith(astarisk)) continue;
                        skip = true;
                        removed.add(e.getName());
                    }
                    if (skip) continue;
                }
                if (removeSet.contains(e.getName())) {
                    removed.add(e.getName());
                    continue;
                }
                os.putNextEntry(e);
                InputStream is = jf.getInputStream(e);
                byte[] b = FileUtil.readAll(is);
                os.write(b);
                is.close();
                os.closeEntry();
            }
            os.close();
        }
        catch (IOException e) {
            RemoveWeaving.printError(e);
        }
    }
}

