/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.setup;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import whatap.agent.logo.Logo;
import whatap.util.AnsiPrint;
import whatap.util.FileUtil;
import whatap.util.JarUtil;
import whatap.util.ShellArg;
import whatap.util.StringUtil;
import whatap.util.SystemUtil;

public class Compact {
    public static boolean debug = false;

    public static void main(String[] args) throws Exception {
        Logo.printForUtil();
        ShellArg sh = new ShellArg(args);
        String from = sh.get("-from");
        if (from == null) {
            from = JarUtil.getJarFileName(Compact.class);
        }
        int n = 1;
        String to = from + "." + n++;
        while (new File(to).exists()) {
            to = from + "." + n++;
        }
        String weaving = sh.get("-weaving", "whatap");
        String[] weavingWords = StringUtil.tokenizer(weaving, ", ");
        String lib1 = sh.get("-lib1", Compact.getLib1Name());
        String[] libw = StringUtil.tokenizer(lib1, ", ");
        if (StringUtil.isEmpty(to) || !new File(from).exists()) {
            Compact.usage();
        }
        File fromFile = new File(from);
        File toFile = new File(to);
        Compact.process(fromFile, toFile, weavingWords, libw);
        System.out.println();
        System.out.println("saved file: " + to);
        System.out.println();
    }

    private static void process(File from, File to, String[] weavingWords, String[] libWords) throws IOException {
        JarFile jf = new JarFile(from);
        int classNum = 0;
        int others = 0;
        int dirs = 0;
        JarOutputStream os = new JarOutputStream(new FileOutputStream(to));
        Enumeration<JarEntry> en = jf.entries();
        while (en.hasMoreElements()) {
            JarEntry e = en.nextElement();
            String name = e.getName();
            if (name.contains("/maven/")) continue;
            if (Compact.skip(name, "weaving", weavingWords)) {
                System.out.println(AnsiPrint.red("\tdrop " + name));
                continue;
            }
            if (Compact.skip(name, "lib1", libWords) && !name.endsWith(".jar")) {
                System.out.println(AnsiPrint.red("\tdrop " + name));
                continue;
            }
            if (e.getName().endsWith("/")) {
                ++dirs;
            } else if (e.getName().endsWith(".class")) {
                ++classNum;
            } else {
                ++others;
                System.out.println("\t" + e.getName());
            }
            os.putNextEntry(e);
            InputStream is = jf.getInputStream(e);
            byte[] b = FileUtil.readAll(is);
            os.write(b);
            is.close();
            os.closeEntry();
        }
        os.close();
        System.out.println();
        System.out.println(AnsiPrint.green("\tcopy dirs #" + dirs));
        System.out.println(AnsiPrint.green("\tcopy classes #" + classNum));
        System.out.println(AnsiPrint.green("\tcopy others #" + others));
    }

    private static boolean skip(String name, String prefix, String[] words) {
        if (name.endsWith("/")) {
            return false;
        }
        if (name.startsWith(prefix)) {
            if (words == null || words.length == 0) {
                return true;
            }
            for (String w : words) {
                if (!name.contains(w)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static void usage() {
        System.out.println("Usage: java -cp " + JarUtil.getJarFileName(Compact.class) + "  \\ \n\t " + Compact.class.getName() + "  [-from orginAgentJar]  -to newAgentJar");
        System.out.println();
        System.exit(1);
    }

    public static String c(String name) {
        return name.replace('/', '.');
    }

    private static String getLib1Name() {
        if (SystemUtil.IS_AIX) {
            return "aix";
        }
        if (SystemUtil.IS_HP_UX) {
            return "hpux";
        }
        if (SystemUtil.IS_LINUX) {
            return "linux";
        }
        if (SystemUtil.IS_MAC) {
            return "osx";
        }
        if (SystemUtil.IS_SUNOS) {
            return "solaris";
        }
        return System.getProperty("os.name");
    }
}

