/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.setup;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import whatap.agent.setup.ClassCV2;
import whatap.org.objectweb.asm.ClassReader;
import whatap.util.AnsiPrint;
import whatap.util.FileUtil;
import whatap.util.JarUtil;
import whatap.util.ShellArg;

public class ClassMethodFinder {
    static String methodName = "flush";

    public static void main(String[] args) throws IOException {
        ShellArg sh = new ShellArg(args);
        methodName = sh.get("-method", "");
        String path = sh.get("-path");
        if (methodName.equals("")) {
            ClassMethodFinder.usage();
            return;
        }
        File root = new File(path);
        ClassMethodFinder.process(root);
    }

    private static void usage() {
        System.out.println("java -cp " + JarUtil.getJarFileName(ClassMethodFinder.class) + " " + ClassMethodFinder.class.getName() + "  -path /tmp -method find");
        System.exit(1);
    }

    private static void process(File root) throws IOException {
        File[] sub;
        for (File f : sub = root.listFiles()) {
            if (f.isDirectory()) {
                if (f.getName().startsWith(".")) continue;
                ClassMethodFinder.process(f);
                continue;
            }
            if (!f.isFile() || !f.getName().endsWith(".jar")) continue;
            ClassMethodFinder.process(f, methodName);
        }
    }

    private static void process(File jarfile, String methodName) throws IOException {
        JarFile inFile = new JarFile(jarfile);
        Enumeration<JarEntry> en = inFile.entries();
        while (en.hasMoreElements()) {
            JarEntry ent = en.nextElement();
            String entName = ent.getName();
            if (!entName.endsWith(".class")) continue;
            InputStream in = inFile.getInputStream(ent);
            byte[] classBytes = FileUtil.readAll(in);
            in.close();
            ClassCV2 cv = new ClassCV2();
            cv.jar = jarfile.getAbsolutePath();
            cv.f_method = methodName;
            try {
                ClassReader cr = new ClassReader(classBytes);
                cr.accept(cv, 8);
            }
            catch (Throwable t) {
                if (t.getMessage().indexOf("JSR/RET") >= 0) continue;
                System.out.println(entName + " -> " + AnsiPrint.red(t.getMessage()));
            }
        }
        inFile.close();
    }
}

