/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.setup;

import whatap.agent.AgentTransformer;
import whatap.agent.asm.IASM;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.setup.ClassCV;
import whatap.agent.setup.ClassFinder;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.util.AnsiPrint;

class ClassInitCV
extends ClassVisitor
implements Opcodes {
    public boolean flag = false;
    private String cname;

    public static String c(String name) {
        return name.replace('/', '.');
    }

    public ClassInitCV() {
        super(IASM.API, AgentTransformer.getClassWriter(ClassCV.classDesc));
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.cname = ClassInitCV.c(name);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.flag) {
            return mv;
        }
        if (ClassFinder.debug) {
            System.out.println("\tdebug " + this.cname + "." + name + desc);
        }
        if (name.equals("<init>")) {
            System.out.println("\t" + AnsiPrint.yellow(this.cname + AsmUtil.getArgString(desc)));
        }
        return mv;
    }
}

