/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.setup;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import whatap.agent.logo.Logo;
import whatap.util.FileUtil;
import whatap.util.JarUtil;
import whatap.util.ShellArg;
import whatap.util.StringUtil;

public class AppendWeaving {
    public static boolean debug = false;

    public static void main(String[] args) throws Exception {
        Logo.printForUtil();
        ShellArg sh = new ShellArg(args);
        String agent = sh.get("-to");
        if (agent == null) {
            agent = JarUtil.getJarFileName(AppendWeaving.class);
        }
        int n = 1;
        String target = agent + "." + n++;
        while (new File(target).exists()) {
            target = agent + "." + n++;
        }
        String weaving = sh.get("-weaving");
        if (!new File(agent).exists() || StringUtil.isEmpty(weaving)) {
            AppendWeaving.usage();
        }
        String[] weavingFiles = StringUtil.tokenizer(weaving, ", ");
        File agentFile = new File(agent);
        File targetFile = new File(target);
        AppendWeaving.process(agentFile, targetFile, weavingFiles);
        System.out.println();
        System.out.println("saved file: " + target);
        System.out.println();
    }

    private static void process(File agent, File target, String[] weavingNames) throws IOException {
        JarFile jf = new JarFile(agent);
        JarOutputStream os = new JarOutputStream(new FileOutputStream(target));
        Enumeration<JarEntry> en = jf.entries();
        while (en.hasMoreElements()) {
            JarEntry e = en.nextElement();
            os.putNextEntry(e);
            InputStream is = jf.getInputStream(e);
            byte[] b = FileUtil.readAll(is);
            is.close();
            os.write(b);
            os.closeEntry();
        }
        for (String fileName : weavingNames) {
            File weavingFile = new File(fileName);
            JarEntry e = new JarEntry("/weaving/" + weavingFile.getName());
            os.putNextEntry(e);
            byte[] b = FileUtil.readAll(weavingFile);
            os.write(b);
            os.closeEntry();
        }
        os.close();
        System.out.println();
    }

    private static void usage() {
        System.out.println("Usage: java -cp " + JarUtil.getJarFileName(AppendWeaving.class) + "  \\ \n\t " + AppendWeaving.class.getName() + "  [-to whatap.jar] -weaving weavingfile");
        System.out.println();
        System.exit(1);
    }

    public static String c(String name) {
        return name.replace('/', '.');
    }
}

