/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.proxy;

import java.io.File;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import whatap.agent.JavaAgent;
import whatap.agent.Logger;
import whatap.agent.proxy.HttpTraceFactory;
import whatap.util.ArrayUtil;
import whatap.util.BytesClassLoader;
import whatap.util.FileUtil;
import whatap.util.HashUtil;
import whatap.util.IntKeyLinkedMap;
import whatap.util.JarUtil;
import whatap.util.StringSet;
import whatap.util.SystemUtil;
import whatap.util.ThreadUtil;

public class LoaderManager {
    private static ClassLoader toolsLoader;
    private static ClassLoader sigarLoader;
    private static ClassLoader oshiLoader;
    private static IntKeyLinkedMap<ClassLoader> loaders;

    public static synchronized ClassLoader getToolsLoader() {
        if (toolsLoader == null) {
            try {
                if (SystemUtil.IS_JAVA_OVER9()) {
                    WeakReference<ClassLoader> w = HttpTraceFactory.httpLoader;
                    if (w != null) {
                        return LoaderManager.createLoader((ClassLoader)w.get(), "whatap.tracer.tools");
                    }
                    return LoaderManager.createLoader(null, "whatap.tracer.tools");
                }
                File tools = JarUtil.getToolsFile();
                toolsLoader = new URLClassLoader(new URL[]{tools.toURI().toURL()});
            }
            catch (Throwable e) {
                Logger.println("JavaAttach", 10, e);
            }
        }
        return LoaderManager.createLoader(toolsLoader, "whatap.tracer.tools");
    }

    public static synchronized ClassLoader getSigarLoader(String libname) {
        if (sigarLoader == null) {
            try {
                String jar = JarUtil.getThisJarName(LoaderManager.class);
                String libDir = null;
                libDir = SystemUtil.IS_WINDOWS ? jar.substring(0, jar.lastIndexOf(92)) : jar.substring(0, jar.lastIndexOf(47));
                File libDirFile = new File(libDir);
                if (libDirFile.exists()) {
                    File done = new File(libDirFile, libname + "/" + libname + ".done");
                    for (int i = 0; i < 5 && !done.exists(); ++i) {
                        ThreadUtil.sleep(5L);
                    }
                    ArrayList<URL> urls = new ArrayList<URL>();
                    StringSet extSet = new StringSet();
                    extSet.put("jar");
                    if (SystemUtil.IS_HP_UX) {
                        extSet.put("sl");
                    } else if (SystemUtil.IS_MAC_OSX) {
                        extSet.put("dylib");
                    } else if (SystemUtil.IS_WINDOWS) {
                        extSet.put("dll");
                    } else {
                        extSet.put("so");
                    }
                    List<File> files = JarUtil.getAllFiles(libDir + "/" + libname, null, extSet);
                    for (int i = 0; i < files.size(); ++i) {
                        urls.add(files.get(i).toURI().toURL());
                    }
                    sigarLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), LoaderManager.class.getClassLoader());
                }
            }
            catch (Throwable e) {
                Logger.println("A153", 10, e);
            }
        }
        return LoaderManager.createLoader(sigarLoader, "whatap.tracer.sigar");
    }

    public static synchronized ClassLoader getOshiLoader(String libname) {
        if (oshiLoader == null) {
            try {
                String jar = JarUtil.getThisJarName(LoaderManager.class);
                String libDir = null;
                libDir = SystemUtil.IS_WINDOWS ? jar.substring(0, jar.lastIndexOf(92)) : jar.substring(0, jar.lastIndexOf(47));
                File libDirFile = new File(libDir);
                if (libDirFile.exists()) {
                    File done = new File(libDirFile, libname + "/" + libname + ".done");
                    for (int i = 0; i < 5 && !done.exists(); ++i) {
                        ThreadUtil.sleep(5L);
                    }
                    ArrayList<URL> urls = new ArrayList<URL>();
                    StringSet extSet = new StringSet();
                    extSet.put("jar");
                    List<File> files = JarUtil.getAllFiles(libDir + "/" + libname, null, extSet);
                    for (int i = 0; i < files.size(); ++i) {
                        urls.add(files.get(i).toURI().toURL());
                    }
                    oshiLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), LoaderManager.class.getClassLoader());
                }
            }
            catch (Throwable e) {
                Logger.println("OSHI", e.getMessage());
            }
        }
        return LoaderManager.createLoader(oshiLoader, "whatap.tracer.oshi");
    }

    public static ClassLoader getHttpLoader(ClassLoader parent) {
        return LoaderManager.createLoader(parent, "whatap.tracer.http");
    }

    public static ClassLoader getSqlTraceLoader(ClassLoader parent) {
        return LoaderManager.createLoader(parent, "whatap.tracer.sql");
    }

    public static ClassLoader getHttpClient(ClassLoader parent) {
        return LoaderManager.createLoader(parent, "whatap.tracer.httpc");
    }

    public static ClassLoader getPlay2Loader(ClassLoader parent) {
        return LoaderManager.createLoader(parent, "whatap.tracer.play2");
    }

    public static ClassLoader getQuantileLoader(ClassLoader parent) {
        return LoaderManager.createLoader(parent, "whatap.tracer.quantile");
    }

    public static ClassLoader getHttpJakartaLoader(ClassLoader parent) {
        return LoaderManager.createLoader(parent, "whatap.tracer.jakarta");
    }

    private static synchronized ClassLoader createLoader(ClassLoader parent, String key) {
        int hashKey = parent == null ? 0 : System.identityHashCode(parent);
        ClassLoader loader = loaders.get(hashKey ^= HashUtil.hash(key));
        if (loader == null) {
            try {
                byte[] bytes = LoaderManager.deploy(key);
                if (bytes != null) {
                    loader = new BytesClassLoader(bytes, parent);
                    loaders.put(hashKey, loader);
                }
            }
            catch (Throwable e) {
                Logger.println("InnerJar", key + " fail " + e);
            }
        }
        return loader;
    }

    private static byte[] deploy(String jarname) {
        try {
            InputStream is = JavaAgent.class.getResourceAsStream("/" + jarname + ".jar");
            if (is == null && jarname.equals("play2") && (is = LoaderManager.class.getResourceAsStream("/" + jarname + ".jar")) == null) {
                is = LoaderManager.class.getResourceAsStream(jarname + ".jar");
            }
            byte[] newBytes = FileUtil.readAll(is);
            is.close();
            Logger.println("InnerJar", jarname + ".jar loaded " + ArrayUtil.len(newBytes) + " bytes");
            return newBytes;
        }
        catch (Exception e) {
            Logger.println("InnerJar", jarname + ".jar fail " + e);
            return null;
        }
    }

    static {
        loaders = new IntKeyLinkedMap().setMax(20);
    }
}

