/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.proxy;

import java.lang.ref.WeakReference;
import whatap.agent.Logger;
import whatap.agent.conf.ConfHook;
import whatap.agent.proxy.HttpCtx;
import whatap.agent.proxy.IHttpTrace;
import whatap.agent.proxy.LoaderManager;
import whatap.util.SystemUtil;

public class HttpTraceFactory {
    private static final String HTTP_TRACE = "whatap.xtra.http.HttpTrace";
    private static final String HTTP_TRACE_VALVE = "whatap.xtra.http.HttpValveTrace";
    public static final IHttpTrace dummy = new IHttpTrace(){

        public HttpCtx wrap(Object req, Object res) {
            return null;
        }
    };
    public static WeakReference<ClassLoader> httpLoader = null;

    public static IHttpTrace create(ClassLoader parent) {
        try {
            if (!ConfHook._enable_emb_httpc) {
                return dummy;
            }
            ClassLoader loader = LoaderManager.getHttpLoader(parent);
            if (loader == null) {
                return dummy;
            }
            if (SystemUtil.IS_JAVA_OVER9() && parent != null) {
                httpLoader = new WeakReference<ClassLoader>(parent);
            }
            Class<?> c = Class.forName(HTTP_TRACE, true, loader);
            return (IHttpTrace)c.newInstance();
        }
        catch (Throwable e) {
            Logger.println("A151", 10, "fail to create", e);
            return dummy;
        }
    }

    public static IHttpTrace createValve(ClassLoader parent) {
        try {
            if (!ConfHook._enable_emb_httpc) {
                return dummy;
            }
            ClassLoader loader = LoaderManager.getHttpLoader(parent);
            if (loader == null) {
                return dummy;
            }
            if (SystemUtil.IS_JAVA_OVER9() && parent != null) {
                httpLoader = new WeakReference<ClassLoader>(parent);
            }
            Class<?> c = Class.forName(HTTP_TRACE_VALVE, true, loader);
            return (IHttpTrace)c.newInstance();
        }
        catch (Throwable e) {
            Logger.println("A151", 10, "fail to create", e);
            return dummy;
        }
    }
}

