/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.plugin.x.examples;

import java.io.FileWriter;
import java.io.IOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Enumeration;
import whatap.agent.Logger;
import whatap.agent.api.Ref;
import whatap.agent.data.DataPackSender;
import whatap.agent.plugin.WrContext;
import whatap.agent.plugin.WrRequest;
import whatap.agent.plugin.WrResponse;
import whatap.agent.plugin.WrSession;
import whatap.agent.plugin.x.HttpServiceEnd;
import whatap.lang.pack.EventPack;
import whatap.util.HashUtil;
import whatap.util.IntKeyLinkedMap;
import whatap.util.IntSet;
import whatap.util.StringUtil;

public class HttpServiceEndExamples
extends HttpServiceEnd {
    public void process(WrContext $ctx, WrRequest $req, WrResponse $res) {
        WrSession wrSession;
        String apiTranIdKey;
        String xApiTranId;
        FileWriter writer;
        DateTimeFormatter fT2;
        String logMessage;
        String logDate;
        DateTimeFormatter fT;
        ZonedDateTime zDt;
        String eClass;
        String value;
        try {
            System.out.println("----------------------------------");
            System.out.println("[HttpServiceEnd.x]");
            IntKeyLinkedMap<IntSet> url_exception_set = (IntKeyLinkedMap<IntSet>)Ref.o;
            String url_exception_set_str = "startProcess:whatap.notice.HTTPC_ERROR,/api/posts/test/timeout:java.util.concurrent.TimeoutException";
            int length = url_exception_set_str.length();
            if (length == 0) {
                return;
            }
            if (url_exception_set == null || Ref.i != length) {
                Ref.o = url_exception_set = new IntKeyLinkedMap<IntSet>();
                Ref.i = length;
                String[] urlStatList = StringUtil.tokenizer(url_exception_set_str, ",");
                for (int i = 0; i < urlStatList.length; ++i) {
                    String line = urlStatList[i];
                    String[] ss = StringUtil.divKeyValue(line, ":");
                    if (ss.length != 2) continue;
                    String urlOrHost = ss[0];
                    int errorHash = 0;
                    String x = StringUtil.trimToEmpty(ss[1]);
                    if (x.length() > 0) {
                        errorHash = x.hashCode();
                    }
                    if (errorHash == 0 || urlOrHost.length() <= 0) continue;
                    IntSet a = (IntSet)url_exception_set.get(errorHash);
                    if (a == null) {
                        a = new IntSet();
                    }
                    int url_hash = HashUtil.hash(urlOrHost);
                    a.put(HashUtil.hash(urlOrHost));
                    url_exception_set.put(errorHash, a);
                }
            }
            System.out.println("url_exception_set: " + url_exception_set);
            if ($ctx.inner() != null) {
                IntSet tSet;
                System.out.println("$ctx.inner() != null ? " + ($ctx.inner() != null));
                if ($ctx.inner().error != null) {
                    System.out.println("$ctx.inner().error != null ? " + ($ctx.inner().error != null));
                    if ($ctx.inner().error.classNameHash > 0 && (tSet = (IntSet)url_exception_set.get($ctx.inner().error.exception.getClass().getName().hashCode())) != null && tSet.contains($ctx.inner().service_hash)) {
                        System.out.println("service: " + $ctx.inner().service_name + " >> ErrorArg = null");
                        $ctx.inner().error = null;
                        $ctx.profile("ErrorArg = null");
                    }
                } else {
                    if ($ctx.inner().exception != null) {
                        System.out.println("$ctx.inner().exception: " + $ctx.inner().exception.getClass().getName());
                        tSet = (IntSet)url_exception_set.get($ctx.inner().exception.getClass().getName().hashCode());
                        if (tSet != null && tSet.contains($ctx.inner().service_hash)) {
                            System.out.println("service: " + $ctx.inner().service_name + " >> $ctx.inner().exception = null");
                            $ctx.inner().error = null;
                            $ctx.inner().exception = null;
                            $ctx.profile("ErrorArg = null");
                        }
                    }
                    if ($ctx.inner().status != 0) {
                        int ctxStatus = $ctx.inner().status / 100;
                        System.out.println("ctxStatus: " + ctxStatus);
                        if (ctxStatus == 4 || ctxStatus == 5) {
                            $ctx.inner().error = null;
                        }
                    }
                }
            }
            System.out.println("----------------------------------\n\n");
        }
        catch (Throwable t) {
            Logger.println("HttpServiceEnd.x ", t);
        }
        try {
            int x1;
            String key = "X-USERID";
            String cookie = $req.getHeader("Cookie");
            if (cookie != null && (x1 = cookie.indexOf(key + "=")) >= 0) {
                String value2 = null;
                int x2 = cookie.indexOf(59, x1);
                value2 = x2 > 0 ? cookie.substring(x1 + key.length() + 1, x2) : cookie.substring(x1 + key.length() + 1);
                if (value2 != null) {
                    $ctx.login(value2);
                }
            }
        }
        catch (Throwable key) {
            // empty catch block
        }
        if ($ctx.inner().error != null) {
            String u = $ctx.service();
            if (u == null) {
                return;
            }
            if (!u.equals("/myurl.do")) {
                return;
            }
            String c = $ctx.inner().error.className;
            if (c == null || !c.endsWith("HTTPC_ERROR")) {
                return;
            }
            String m = $ctx.inner().error.message;
            if (m == null || m.indexOf("status 409") < 0) {
                return;
            }
            $ctx.inner().error = null;
        }
        if ((value = $req.getHeader("x-wtap-mst")) != null) {
            String[] arrValue = value.split(",");
            $ctx.login(arrValue[0]);
        }
        if ($ctx.isError()) {
            eClass = $ctx.inner().error.className;
            String eMsg = $ctx.inner().error.message;
            String eURL = $ctx.service();
            if (eClass != null && !eClass.isEmpty()) {
                ZoneId zI = ZoneId.of("Asia/Seoul");
                zDt = ZonedDateTime.now(zI);
                fT = DateTimeFormatter.ofPattern("yyyyMMdd");
                logDate = zDt.format(fT);
                String logFileName = "/root/agent/logs/AgentError-" + logDate + ".log";
                logMessage = "";
                fT2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                String formatTime = zDt.format(fT2);
                logMessage = formatTime + " " + eURL + " " + eClass + " " + eMsg;
                try {
                    writer = new FileWriter(logFileName, true);
                    writer.write(logMessage + "\n");
                    writer.close();
                }
                catch (IOException e) {
                    this.log("e: " + e);
                }
            }
        }
        if ($ctx.inner() != null && $ctx.inner().exception != null) {
            eClass = $ctx.inner().exception.getClass().getName();
            String eMsg = $ctx.inner().exception.getMessage();
            String eURL = $ctx.service();
            ZoneId zI = ZoneId.of("Asia/Seoul");
            zDt = ZonedDateTime.now(zI);
            fT = DateTimeFormatter.ofPattern("yyyyMMdd");
            logDate = zDt.format(fT);
            String logFileName = "/root/agent/logs/AgentError-" + logDate + ".log";
            logMessage = "";
            fT2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String formatTime = zDt.format(fT2);
            logMessage = formatTime + " " + eURL + " " + eClass + " " + eMsg;
            try {
                writer = new FileWriter(logFileName, true);
                writer.write(logMessage + "\n");
                writer.close();
            }
            catch (IOException e) {
                this.log("e: " + e);
            }
        }
        if ($ctx.inner() != null && $ctx.inner().status >= 400) {
            eClass = "WHATAP_ERROR.status_error";
            String eMsg = "Status " + $ctx.inner().status;
            String eURL = $ctx.service();
            ZoneId zI = ZoneId.of("Asia/Seoul");
            zDt = ZonedDateTime.now(zI);
            fT = DateTimeFormatter.ofPattern("yyyyMMdd");
            logDate = zDt.format(fT);
            String logFileName = "/root/agent/logs/AgentError-" + logDate + ".log";
            logMessage = "";
            fT2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String formatTime = zDt.format(fT2);
            logMessage = formatTime + " " + eURL + " " + eClass + " " + eMsg;
            try {
                writer = new FileWriter(logFileName, true);
                writer.write(logMessage + "\n");
                writer.close();
            }
            catch (IOException e) {
                this.log("e: " + e);
            }
        }
        String serviceNameOrg = $ctx.service();
        String qString = "";
        if ($req.getQueryString() != null && $req.getQueryString().length() != 0) {
            qString = "?" + $req.getQueryString();
            $ctx.service(serviceNameOrg + qString);
        }
        String key = "lang";
        String delimWord = ";";
        String cookieValue = $req.getHeader("cookie");
        if (cookieValue != null) {
            ArrayList<String> list = new ArrayList<String>();
            while (cookieValue.length() > 0) {
                int pos = cookieValue.indexOf(delimWord);
                if (pos < 0) {
                    list.add(cookieValue);
                    cookieValue = "";
                    continue;
                }
                if (pos > 0) {
                    list.add(cookieValue.substring(0, pos));
                    cookieValue = cookieValue.substring(pos + delimWord.length());
                    continue;
                }
                cookieValue = cookieValue.substring(delimWord.length());
            }
            String[] cookieArray = list.toArray(new String[list.size()]);
            for (int j = 0; j < cookieArray.length; ++j) {
                String s2;
                String[] kvArray;
                String kv = cookieArray[j];
                int x = kv.indexOf("=");
                if (x < 0 && (kvArray = new String[]{kv.trim()})[0] != null && kvArray[0].equals(key)) {
                    $ctx.login(kvArray[0] + "=" + kvArray[1]);
                    break;
                }
                String s1 = kv.substring(0, x).trim();
                String[] kvArray2 = new String[]{s1, s2 = kv.substring(x + 1).trim()};
                if (kvArray2[0] == null || !kvArray2[0].equals(key)) continue;
                $ctx.login(kvArray2[0] + "=" + kvArray2[1]);
                break;
            }
        }
        if ($ctx.inner().exception != null) {
            String cName = $ctx.inner().exception.getClass().getName();
            String eMsg = $ctx.inner().exception.getMessage();
            if (cName != null && cName.contains("OutOfMemoryError")) {
                EventPack e = new EventPack();
                e.title = "OutOfMemoryError Event";
                e.level = (byte)20;
                e.status = 1;
                e.attr.put("class", cName);
                e.message = "[ClassName]" + cName + " [ErrorMassage]" + eMsg;
                DataPackSender.send(e);
            }
        }
        String back = $req.getParameter("conn_usr_ip");
        if ($ctx.ok() && back != null) {
            $ctx.remoteIp(back);
        }
        String orgName = $ctx.service();
        StringBuilder sb = new StringBuilder();
        String i = $req.getParameter("requestType");
        String j = $req.getParameter("application");
        String k = $req.getParameter("enqname");
        if (i == null || i.isEmpty()) {
            $ctx.service(orgName);
        } else {
            sb.append(i);
            if (j == null || j.isEmpty()) {
                sb.append("_[]");
            } else {
                sb.append("_[").append(j).append("]");
            }
            if (k == null || k.isEmpty()) {
                sb.append("_[]");
            } else {
                sb.append("_[").append(k).append("]");
            }
            $ctx.service(sb.toString());
        }
        String whatapId = $req.getHeader("userID");
        if (whatapId != null) {
            $ctx.login(whatapId);
        }
        if ((xApiTranId = $req.getHeader(apiTranIdKey = "x-api-tran-id")) != null && xApiTranId.length() > 0) {
            $ctx.setExtraField(apiTranIdKey, xApiTranId);
        }
        if ((wrSession = $req.getSession()) != null) {
            this.log(wrSession.getAttributeNames());
            Enumeration en = wrSession.getAttributeNames();
            while (en.hasMoreElements()) {
                Object e = en.nextElement();
                if (!(e instanceof String)) continue;
                String s = e.toString();
                this.log("attribute:" + s + "=" + wrSession.getAttribute(s));
            }
        }
    }
}

