/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.plugin;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.plugin.WrContext;
import whatap.javassist.CannotCompileException;
import whatap.javassist.ClassPool;
import whatap.javassist.CtClass;
import whatap.javassist.CtMethod;
import whatap.javassist.CtNewMethod;
import whatap.javassist.NotFoundException;
import whatap.lang.ref.BOOLEAN;
import whatap.util.FileUtil;
import whatap.util.JarUtil;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginLoader {
    private File script;
    private long lastModified;
    private String pluginName;
    private Class[] paramClass;
    private String[] paramName;
    private final File pluginRoot = new File(System.getProperty("whatap.home", "."), "plugin");
    private static boolean print = true;
    private Object plugin;

    public PluginLoader(Class superClass) {
        this.pluginName = StringUtil.cutLastString(superClass.getName(), '.');
        this.script = new File(this.pluginRoot, this.pluginName + ".x");
        this.paramClass = this.getParamTypes(superClass);
        if (print) {
            Logger.println("plugin", "root=" + this.pluginRoot);
            print = false;
        }
    }

    private List<String> getClassPath(File root) {
        ArrayList<String> cp = new ArrayList<String>();
        if (!Configure.getInstance().plugin_access_jarfiles) {
            return cp;
        }
        File[] f = root.listFiles();
        for (int i = 0; f != null && i < f.length; ++i) {
            if (!f[i].isFile() || !f[i].getName().toLowerCase().endsWith(".jar")) continue;
            cp.add(f[i].getAbsolutePath());
        }
        return cp;
    }

    public Object create(ClassLoader parent, BOOLEAN md) {
        if (!this.script.canRead()) {
            if (this.plugin != null) {
                md.value |= true;
            }
            this.plugin = null;
            return null;
        }
        if (this.lastModified == this.script.lastModified()) {
            return this.plugin;
        }
        List<String> plugJarFiles = this.getClassPath(this.pluginRoot);
        md.value |= true;
        this.lastModified = this.script.lastModified();
        try {
            String methodBody = FileUtil.load(this.script, "UTF-8");
            String superName = "whatap.agent.plugin.x." + this.pluginName;
            String className = "whatap.agent.plugin.m." + this.pluginName;
            ClassPool cp = ClassPool.getDefault();
            String jar = JarUtil.getJarFileName(PluginLoader.class);
            if (jar != null) {
                cp.appendClassPath(jar);
                for (int i = 0; i < plugJarFiles.size(); ++i) {
                    cp.appendClassPath(plugJarFiles.get(i));
                }
            }
            CtClass cc = cp.get(superName);
            CtClass impl = null;
            CtMethod process = null;
            try {
                impl = cp.get(className);
                impl.defrost();
                process = impl.getMethod("process", this.signature());
            }
            catch (NotFoundException e) {
                impl = cp.makeClass(className, cc);
                StringBuffer sb = new StringBuffer();
                sb.append("public void process (");
                for (int i = 0; i < this.paramClass.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(this.paramClass[i].getName()).append(" p" + i);
                }
                sb.append("){}");
                process = CtNewMethod.make(sb.toString(), impl);
                impl.addMethod(process);
            }
            StringBuffer sb = new StringBuffer();
            sb.append("{");
            for (int i = 0; i < this.paramClass.length; ++i) {
                sb.append(this.paramClass[i].getName());
                sb.append(" ").append(this.paramName[i]).append("=$").append(i + 1).append(";");
            }
            sb.append(methodBody);
            sb.append("\n}");
            process.setBody(sb.toString());
            Class c = plugJarFiles.size() > 0 ? impl.toClass(new URLClassLoader(this.toURLs(plugJarFiles), parent), null) : impl.toClass(new URLClassLoader(new URL[0], parent), null);
            this.plugin = c.newInstance();
            Logger.println("plugin", this.pluginName + " loaded");
            return this.plugin;
        }
        catch (CannotCompileException ee) {
            Logger.println("plugin", ee.getMessage());
        }
        catch (Exception e) {
            Logger.println("plugin-error", 10, (Throwable)e);
        }
        this.plugin = null;
        return null;
    }

    private URL[] toURLs(List<String> cp) {
        URL[] u = new URL[cp.size()];
        for (int i = 0; i < cp.size(); ++i) {
            try {
                u[i] = new File(cp.get(i)).toURI().toURL();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return u;
    }

    private String signature() {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < this.paramClass.length; ++i) {
            sb.append(this.nativeName(WrContext.class));
        }
        sb.append(")V");
        return sb.toString();
    }

    private String nativeName(Class class1) {
        return "L" + class1.getName().replace('.', '/') + ";";
    }

    private Class[] getParamTypes(Class c) {
        Method[] m = c.getDeclaredMethods();
        for (int i = 0; i < m.length; ++i) {
            if (!m[i].getName().equals("process")) continue;
            return m[i].getParameterTypes();
        }
        return new Class[0];
    }

    public PluginLoader setParamName(String[] paramName) {
        if (this.paramClass.length == paramName.length) {
            this.paramName = paramName;
        }
        return this;
    }
}

