/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.open;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.conf.ConfOpenMx;
import whatap.agent.data.DataPackSender;
import whatap.agent.open.OpenInfo;
import whatap.agent.open.OpenMxAgentProperty;
import whatap.agent.util.ReflectUtil;
import whatap.lang.pack.CounterPack1;
import whatap.lang.pack.open.OpenMx;
import whatap.lang.pack.open.OpenMxHelp;
import whatap.lang.pack.open.OpenMxHelpPack;
import whatap.lang.pack.open.OpenMxPack;
import whatap.lang.service.TxRecord;
import whatap.util.DateUtil;
import whatap.util.IntLongLinkedMap;
import whatap.util.SysJMX;
import whatap.util.SystemUtil;
import whatap.util.ThreadUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenMxEng
extends Thread {
    private static OpenMxEng instance;
    public static final List<OpenMxHelp> helpitems;
    public static long app_tx_time_sum;
    public static long app_tx_count_total;
    public static long app_tx_error_total;
    public static long app_tx_active_count;
    public static long process_cputime_total;
    public static long process_memory_bytes;
    private static long app_tx_status_count_200;
    private static long app_tx_status_count_201;
    private static long app_tx_status_count_202;
    private static long app_tx_status_count_204;
    private static long app_tx_status_count_301;
    private static long app_tx_status_count_302;
    private static long app_tx_status_count_304;
    private static long app_tx_status_count_400;
    private static long app_tx_status_count_401;
    private static long app_tx_status_count_403;
    private static long app_tx_status_count_404;
    private static long app_tx_status_count_500;
    private static long app_tx_status_count_502;
    private static long app_tx_status_count_503;
    private static long app_tx_status_count_504;
    public static IntLongLinkedMap app_tx_status_count_other;
    public OperatingSystemMXBean opBean;
    static SecurityMaster secuMaster;
    long last_help;

    public static synchronized OpenMxEng getInstasnce() {
        if (instance == null) {
            instance = new OpenMxEng();
            instance.setDaemon(true);
            instance.setName("WhaTap-OpenMxEng");
            instance.start();
        }
        return instance;
    }

    public static void update(CounterPack1 cp) {
        app_tx_time_sum += cp.service_time_sum;
        app_tx_count_total += (long)cp.service_count;
        app_tx_error_total += (long)cp.service_error;
    }

    public static void countTxByStatus(TxRecord tx) {
        switch (tx.status) {
            case 0: {
                break;
            }
            case 200: {
                ++app_tx_status_count_200;
                break;
            }
            case 201: {
                ++app_tx_status_count_201;
                break;
            }
            case 202: {
                ++app_tx_status_count_202;
                break;
            }
            case 204: {
                ++app_tx_status_count_204;
                break;
            }
            case 301: {
                ++app_tx_status_count_301;
                break;
            }
            case 302: {
                ++app_tx_status_count_302;
                break;
            }
            case 304: {
                ++app_tx_status_count_304;
                break;
            }
            case 400: {
                ++app_tx_status_count_400;
                break;
            }
            case 401: {
                ++app_tx_status_count_401;
                break;
            }
            case 403: {
                ++app_tx_status_count_403;
                break;
            }
            case 404: {
                ++app_tx_status_count_404;
                break;
            }
            case 500: {
                ++app_tx_status_count_500;
                break;
            }
            case 502: {
                ++app_tx_status_count_502;
                break;
            }
            case 503: {
                ++app_tx_status_count_503;
                break;
            }
            case 504: {
                ++app_tx_status_count_504;
                break;
            }
            default: {
                app_tx_status_count_other.add(tx.status, 1L);
            }
        }
    }

    @Override
    public void run() {
        while (true) {
            if (!ConfOpenMx.openmx_enabled) {
                ThreadUtil.sleep(5000L);
                continue;
            }
            try {
                OpenMxAgentProperty.send();
                this.process();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ThreadUtil.sleep(ConfOpenMx.openmx_interval);
        }
    }

    private void process() {
        if (!OpenInfo.isInitialized()) {
            return;
        }
        this.sendhelp();
        long time = DateUtil.now() / 1000L * 1000L;
        ArrayList<OpenMx> items = new ArrayList<OpenMx>();
        this.add(items, time, "app_tx_time_sum", app_tx_time_sum);
        this.add(items, time, "app_tx_count_total", app_tx_count_total);
        this.add(items, time, "app_tx_error_total", app_tx_error_total);
        this.add(items, time, "app_tx_active_count", app_tx_active_count);
        this.add(items, time, "process_cputime_total", SysJMX.getProcessCPUnano() / 1000L);
        if (ConfOpenMx.openmx_tx_status_enabled) {
            this.addForStatus(items, time, "app_tx_status_count", 200, app_tx_status_count_200);
            this.addForStatus(items, time, "app_tx_status_count", 201, app_tx_status_count_201);
            this.addForStatus(items, time, "app_tx_status_count", 202, app_tx_status_count_202);
            this.addForStatus(items, time, "app_tx_status_count", 204, app_tx_status_count_204);
            this.addForStatus(items, time, "app_tx_status_count", 301, app_tx_status_count_301);
            this.addForStatus(items, time, "app_tx_status_count", 302, app_tx_status_count_302);
            this.addForStatus(items, time, "app_tx_status_count", 304, app_tx_status_count_304);
            this.addForStatus(items, time, "app_tx_status_count", 400, app_tx_status_count_400);
            this.addForStatus(items, time, "app_tx_status_count", 401, app_tx_status_count_401);
            this.addForStatus(items, time, "app_tx_status_count", 403, app_tx_status_count_403);
            this.addForStatus(items, time, "app_tx_status_count", 404, app_tx_status_count_404);
            this.addForStatus(items, time, "app_tx_status_count", 500, app_tx_status_count_500);
            this.addForStatus(items, time, "app_tx_status_count", 502, app_tx_status_count_502);
            this.addForStatus(items, time, "app_tx_status_count", 503, app_tx_status_count_503);
            this.addForStatus(items, time, "app_tx_status_count", 504, app_tx_status_count_504);
            Enumeration<IntLongLinkedMap.IntLongLinkedEntry> en = app_tx_status_count_other.entries();
            while (en.hasMoreElements()) {
                IntLongLinkedMap.IntLongLinkedEntry ent = en.nextElement();
                this.addForStatus(items, time, "app_tx_status_count", ent.getKey(), ent.getValue());
            }
        }
        if (process_memory_bytes > 0L) {
            this.add(items, time, "process_memory_bytes", process_memory_bytes);
        } else if (SystemUtil.IS_JAVA_OVER10() && !SystemUtil.IS_JAVA_IBM) {
            if (SystemUtil.IS_JAVA_OVER10() && !SystemUtil.IS_JAVA_IBM) {
                if (this.opBean == null) {
                    this.opBean = ManagementFactory.getOperatingSystemMXBean();
                }
                long mem = ReflectUtil.getLong(this.opBean, "getProcessMemorySize");
                this.add(items, time, "process_memory_bytes", mem);
            }
        } else {
            this.add(items, time, "process_memory_bytes", -1.0);
        }
        process_memory_bytes = -1L;
        if (ConfOpenMx.debug_openmx_enabled) {
            for (int i = 0; i < items.size(); ++i) {
                Logger.yellow(((OpenMx)items.get(i)).toString());
            }
        }
        OpenMxPack p = new OpenMxPack();
        p.pcode = OpenInfo.getPcode();
        p.oid = OpenInfo.getOid();
        p.time = time;
        p.setRecords(items);
        DataPackSender.sendRerouteTarget(p);
    }

    private void addForStatus(List<OpenMx> items, long time, String name, int status, double value) {
        if (value == 0.0) {
            return;
        }
        OpenMx mx = new OpenMx(name, time, value);
        this.setCommon(mx);
        mx.addLabel("status", String.valueOf(status));
        items.add(mx);
    }

    private void add(List<OpenMx> items, long time, String name, double value) {
        OpenMx mx = new OpenMx(name, time, value);
        this.setCommon(mx);
        items.add(mx);
    }

    private void setCommon(OpenMx mx) {
        mx.addLabel("oname", OpenMxEng.secuMaster.ONAME);
        mx.addLabel("hostname", SysJMX.getHostName());
    }

    private void sendhelp() {
        long now = DateUtil.nanoToMillis();
        if (now - this.last_help < 300000L) {
            return;
        }
        this.last_help = now;
        OpenMxHelpPack p = new OpenMxHelpPack();
        p.pcode = OpenInfo.getPcode();
        p.oid = OpenInfo.getOid();
        p.time = DateUtil.now();
        p.setRecords(helpitems);
        DataPackSender.sendRerouteTarget(p);
    }

    static {
        helpitems = new ArrayList<OpenMxHelp>(10);
        OpenMxHelp h = new OpenMxHelp("app_tx_count_total");
        h.put("help", "Total number of application tx requests.");
        h.put("type", "counter");
        helpitems.add(h);
        h = new OpenMxHelp("app_tx_error_total");
        h.put("help", "Total number of application tx error.");
        h.put("type", "counter");
        helpitems.add(h);
        h = new OpenMxHelp("app_tx_time_sum");
        h.put("help", "Application request latency in millis.");
        h.put("type", "counter");
        helpitems.add(h);
        h = new OpenMxHelp("app_tx_active_count");
        h.put("help", "Number of active concurrent requests.");
        h.put("type", "gauge");
        helpitems.add(h);
        h = new OpenMxHelp("process_cputime_total");
        h.put("help", "Total CPU time used by the process in millis.");
        h.put("type", "counter");
        helpitems.add(h);
        h = new OpenMxHelp("process_memory_bytes");
        h.put("help", "Physical memory usage of the process in bytes(by oshi).");
        h.put("type", "gauge");
        helpitems.add(h);
        h = new OpenMxHelp("app_tx_status_count");
        h.put("help", "Number of Transaction per Status Code");
        h.put("type", "counter");
        helpitems.add(h);
        app_tx_status_count_200 = 0L;
        app_tx_status_count_201 = 0L;
        app_tx_status_count_202 = 0L;
        app_tx_status_count_204 = 0L;
        app_tx_status_count_301 = 0L;
        app_tx_status_count_302 = 0L;
        app_tx_status_count_304 = 0L;
        app_tx_status_count_400 = 0L;
        app_tx_status_count_401 = 0L;
        app_tx_status_count_403 = 0L;
        app_tx_status_count_404 = 0L;
        app_tx_status_count_500 = 0L;
        app_tx_status_count_502 = 0L;
        app_tx_status_count_503 = 0L;
        app_tx_status_count_504 = 0L;
        app_tx_status_count_other = new IntLongLinkedMap();
        secuMaster = SecurityMaster.getInstance();
    }
}

