/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.open;

import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.WsSysConf;
import whatap.agent.net.GetSysIdWithNewTCP;
import whatap.lang.WsKey;

public class OpenInfo {
    public static final short PLATFORM_OPENMX = 131;
    public static short SYSID;
    public static String PROPERTY_KEY_PREFIX;
    private static long pcode;

    public static int getOid() {
        return SecurityMaster.getInstance().OID;
    }

    public static long getPcode() {
        return pcode;
    }

    public static boolean isInitialized() {
        if (SYSID > 0) {
            return true;
        }
        SecurityMaster secu = SecurityMaster.getInstance();
        if (!SecurityMaster.isWorkspace) {
            return false;
        }
        if (secu.OID == 0) {
            return false;
        }
        short sysid = WsSysConf.read((short)131);
        if (sysid > 0) {
            SYSID = sysid;
            OpenInfo.updatePcode(secu);
            return true;
        }
        try {
            sysid = GetSysIdWithNewTCP.requestForSysId(secu.WSID, (short)131, secu.OID);
            if (sysid > 0) {
                WsSysConf.reset((short)131, sysid);
                OpenInfo.updatePcode(secu);
                return true;
            }
        }
        catch (Throwable e) {
            Logger.println(e.getMessage());
        }
        return false;
    }

    private static void updatePcode(SecurityMaster secu) {
        pcode = new WsKey(secu.WSID, 131, SYSID).toLongPcode();
        Logger.green("OpenMx PCODE=" + WsKey.toString(pcode));
    }

    static {
        PROPERTY_KEY_PREFIX = "property131@";
    }
}

