/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.net;

import whatap.agent.Configure;
import whatap.agent.net.Receiver;
import whatap.agent.net.Sender;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.CounterPack1;
import whatap.util.RequestDoubleQueue;
import whatap.util.ThreadUtil;

public class TcpRequestMgr {
    private static TcpRequestMgr instance;
    protected Configure conf = Configure.getInstance();
    protected RequestDoubleQueue<Data> queue;
    public long sendDropped1;
    public long sendDropped2;
    public long seq;
    public long returnSeq;
    public long sendBytes;
    public long sendPack;
    final Thread sender;
    final Thread sender2;
    final Thread receiver;

    public static synchronized TcpRequestMgr getInstance() {
        if (instance == null) {
            instance = new TcpRequestMgr();
        }
        return instance;
    }

    public void add(int flag, boolean flush, CounterPack1 p) {
        ++CounterPack1.TRACE_WAITING_PACK_COUNT;
        boolean ok = this.queue.put1(new Data((byte)flag, flush, p));
        if (!ok) {
            --CounterPack1.TRACE_WAITING_PACK_COUNT;
            ++this.sendDropped1;
        }
    }

    public void add(int flag, boolean flush, AbstractPack p) {
        boolean ok = this.queue.put1(new Data((byte)flag, flush, p));
        if (!ok) {
            ++this.sendDropped2;
        }
    }

    public void addProfile(int flag, boolean flush, AbstractPack p) {
        boolean ok = this.queue.put2(new Data((byte)flag, flush, p));
        if (!ok) {
            if (Configure.NO_DROP_PACK) {
                while (!this.queue.put2(new Data((byte)flag, flush, p))) {
                    ThreadUtil.sleep(10L);
                }
            } else {
                ++this.sendDropped2;
            }
        }
    }

    public void logSelf(CounterPack1 cp) {
        cp.pack_dropped = cp.pack_dropped + this.sendDropped1 + this.sendDropped2;
        this.sendBytes = 0L;
        this.sendPack = 0L;
    }

    public TcpRequestMgr() {
        this.queue = new RequestDoubleQueue(this.conf.net_send_queue1_size, this.conf.net_send_queue2_size);
        this.seq = 1L;
        this.sender = new Sender();
        this.sender2 = new Sender();
        this.receiver = new Receiver();
        this.receiver.start();
        this.sender.start();
        this.sender2.start();
        this.receiver.setName("WhaTap-Net-Receiver");
        this.sender.setName("WhaTap-Net-Sender1");
        this.sender2.setName("WhaTap-Net-Sender2");
        this.queue.setCapacity(this.conf.net_send_queue1_size, this.conf.net_send_queue2_size);
        ConfObserver.add("TcpRequestMgr", new Runnable(){

            public void run() {
                TcpRequestMgr.this.queue.setCapacity(TcpRequestMgr.this.conf.net_send_queue1_size, TcpRequestMgr.this.conf.net_send_queue2_size);
            }
        });
    }

    public int getSizeQue1() {
        return this.queue.size1();
    }

    static class Data {
        byte flag;
        AbstractPack pack;
        public boolean flush;

        public Data(byte flag, boolean flush, AbstractPack pack) {
            this.flag = flag;
            this.pack = pack;
            this.flush = flush;
        }
    }
}

