/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.trace.sql.TraceSQL;
import whatap.util.DateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WrResultSet
implements ResultSet {
    private ResultSet inner;
    private int rs_count;
    private boolean closed = false;
    private int sqlhash;
    private int dbc;
    private long start;

    public WrResultSet(ResultSet inner, int sqlhash, int dbc) {
        this.inner = inner;
        this.sqlhash = sqlhash;
        this.dbc = dbc;
        this.start = DateUtil.nanoToMillis();
    }

    @Override
    public final Object getObject(String a0, Map<String, Class<?>> a1) throws SQLException {
        return this.inner.getObject(a0, a1);
    }

    @Override
    public final Object getObject(int a0, Map<String, Class<?>> a1) throws SQLException {
        return this.inner.getObject(a0, a1);
    }

    @Override
    public final Object getObject(int a0) throws SQLException {
        return this.inner.getObject(a0);
    }

    @Override
    public final Object getObject(String a0) throws SQLException {
        return this.inner.getObject(a0);
    }

    @Override
    public final boolean getBoolean(String a0) throws SQLException {
        return this.inner.getBoolean(a0);
    }

    @Override
    public final boolean getBoolean(int a0) throws SQLException {
        return this.inner.getBoolean(a0);
    }

    @Override
    public final byte getByte(String a0) throws SQLException {
        return this.inner.getByte(a0);
    }

    @Override
    public final byte getByte(int a0) throws SQLException {
        return this.inner.getByte(a0);
    }

    @Override
    public final short getShort(int a0) throws SQLException {
        return this.inner.getShort(a0);
    }

    @Override
    public final short getShort(String a0) throws SQLException {
        return this.inner.getShort(a0);
    }

    @Override
    public final int getInt(String a0) throws SQLException {
        return this.inner.getInt(a0);
    }

    @Override
    public final int getInt(int a0) throws SQLException {
        return this.inner.getInt(a0);
    }

    @Override
    public final long getLong(String a0) throws SQLException {
        return this.inner.getLong(a0);
    }

    @Override
    public final long getLong(int a0) throws SQLException {
        return this.inner.getLong(a0);
    }

    @Override
    public final float getFloat(int a0) throws SQLException {
        return this.inner.getFloat(a0);
    }

    @Override
    public final float getFloat(String a0) throws SQLException {
        return this.inner.getFloat(a0);
    }

    @Override
    public final double getDouble(String a0) throws SQLException {
        return this.inner.getDouble(a0);
    }

    @Override
    public final double getDouble(int a0) throws SQLException {
        return this.inner.getDouble(a0);
    }

    @Override
    public final byte[] getBytes(int a0) throws SQLException {
        return this.inner.getBytes(a0);
    }

    @Override
    public final byte[] getBytes(String a0) throws SQLException {
        return this.inner.getBytes(a0);
    }

    @Override
    public final Array getArray(String a0) throws SQLException {
        return this.inner.getArray(a0);
    }

    @Override
    public final Array getArray(int a0) throws SQLException {
        return this.inner.getArray(a0);
    }

    @Override
    public final boolean next() throws SQLException {
        boolean b = this.inner.next();
        if (b) {
            ++this.rs_count;
        } else if (!this.closed) {
            this.closed = true;
            TraceContext c = TraceContextManager.getLocalContext();
            if (c != null) {
                TraceSQL.fetch(c, this.sqlhash, this.start, this.rs_count, this.dbc);
            }
        }
        return b;
    }

    @Override
    public final URL getURL(String a0) throws SQLException {
        return this.inner.getURL(a0);
    }

    @Override
    public final URL getURL(int a0) throws SQLException {
        return this.inner.getURL(a0);
    }

    @Override
    public final void close() throws SQLException {
        this.inner.close();
        if (!this.closed) {
            this.closed = true;
            TraceContext c = TraceContextManager.getLocalContext();
            if (c != null) {
                TraceSQL.fetch(c, this.sqlhash, this.start, this.rs_count, this.dbc);
            }
        }
    }

    @Override
    public final int getType() throws SQLException {
        return this.inner.getType();
    }

    @Override
    public final boolean previous() throws SQLException {
        return this.inner.previous();
    }

    @Override
    public final Ref getRef(String a0) throws SQLException {
        return this.inner.getRef(a0);
    }

    @Override
    public final Ref getRef(int a0) throws SQLException {
        return this.inner.getRef(a0);
    }

    @Override
    public final String getString(String a0) throws SQLException {
        return this.inner.getString(a0);
    }

    @Override
    public final String getString(int a0) throws SQLException {
        return this.inner.getString(a0);
    }

    @Override
    public final Time getTime(String a0, Calendar a1) throws SQLException {
        return this.inner.getTime(a0, a1);
    }

    @Override
    public final Time getTime(int a0, Calendar a1) throws SQLException {
        return this.inner.getTime(a0, a1);
    }

    @Override
    public final Time getTime(String a0) throws SQLException {
        return this.inner.getTime(a0);
    }

    @Override
    public final Time getTime(int a0) throws SQLException {
        return this.inner.getTime(a0);
    }

    @Override
    public final Date getDate(int a0, Calendar a1) throws SQLException {
        return this.inner.getDate(a0, a1);
    }

    @Override
    public final Date getDate(String a0) throws SQLException {
        return this.inner.getDate(a0);
    }

    @Override
    public final Date getDate(String a0, Calendar a1) throws SQLException {
        return this.inner.getDate(a0, a1);
    }

    @Override
    public final Date getDate(int a0) throws SQLException {
        return this.inner.getDate(a0);
    }

    @Override
    public final boolean first() throws SQLException {
        return this.inner.first();
    }

    @Override
    public final boolean last() throws SQLException {
        return this.inner.last();
    }

    @Override
    public final boolean wasNull() throws SQLException {
        return this.inner.wasNull();
    }

    @Override
    public final BigDecimal getBigDecimal(int a0, int a1) throws SQLException {
        return this.inner.getBigDecimal(a0, a1);
    }

    @Override
    public final BigDecimal getBigDecimal(String a0, int a1) throws SQLException {
        return this.inner.getBigDecimal(a0, a1);
    }

    @Override
    public final BigDecimal getBigDecimal(String a0) throws SQLException {
        return this.inner.getBigDecimal(a0);
    }

    @Override
    public final BigDecimal getBigDecimal(int a0) throws SQLException {
        return this.inner.getBigDecimal(a0);
    }

    @Override
    public final Timestamp getTimestamp(int a0, Calendar a1) throws SQLException {
        return this.inner.getTimestamp(a0, a1);
    }

    @Override
    public final Timestamp getTimestamp(String a0, Calendar a1) throws SQLException {
        return this.inner.getTimestamp(a0, a1);
    }

    @Override
    public final Timestamp getTimestamp(String a0) throws SQLException {
        return this.inner.getTimestamp(a0);
    }

    @Override
    public final Timestamp getTimestamp(int a0) throws SQLException {
        return this.inner.getTimestamp(a0);
    }

    @Override
    public final InputStream getAsciiStream(String a0) throws SQLException {
        return this.inner.getAsciiStream(a0);
    }

    @Override
    public final InputStream getAsciiStream(int a0) throws SQLException {
        return this.inner.getAsciiStream(a0);
    }

    @Override
    public final InputStream getUnicodeStream(String a0) throws SQLException {
        return this.inner.getUnicodeStream(a0);
    }

    @Override
    public final InputStream getUnicodeStream(int a0) throws SQLException {
        return this.inner.getUnicodeStream(a0);
    }

    @Override
    public final InputStream getBinaryStream(String a0) throws SQLException {
        return this.inner.getBinaryStream(a0);
    }

    @Override
    public final InputStream getBinaryStream(int a0) throws SQLException {
        return this.inner.getBinaryStream(a0);
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        return this.inner.getWarnings();
    }

    @Override
    public final void clearWarnings() throws SQLException {
        this.inner.clearWarnings();
    }

    @Override
    public final String getCursorName() throws SQLException {
        return this.inner.getCursorName();
    }

    @Override
    public final ResultSetMetaData getMetaData() throws SQLException {
        return this.inner.getMetaData();
    }

    @Override
    public final int findColumn(String a0) throws SQLException {
        return this.inner.findColumn(a0);
    }

    @Override
    public final Reader getCharacterStream(int a0) throws SQLException {
        return this.inner.getCharacterStream(a0);
    }

    @Override
    public final Reader getCharacterStream(String a0) throws SQLException {
        return this.inner.getCharacterStream(a0);
    }

    @Override
    public final boolean isBeforeFirst() throws SQLException {
        return this.inner.isBeforeFirst();
    }

    @Override
    public final boolean isAfterLast() throws SQLException {
        return this.inner.isAfterLast();
    }

    @Override
    public final boolean isFirst() throws SQLException {
        return this.inner.isFirst();
    }

    @Override
    public final boolean isLast() throws SQLException {
        return this.inner.isLast();
    }

    @Override
    public final void beforeFirst() throws SQLException {
        this.inner.beforeFirst();
    }

    @Override
    public final void afterLast() throws SQLException {
        this.inner.afterLast();
    }

    @Override
    public final int getRow() throws SQLException {
        return this.inner.getRow();
    }

    @Override
    public final boolean absolute(int a0) throws SQLException {
        return this.inner.absolute(a0);
    }

    @Override
    public final boolean relative(int a0) throws SQLException {
        return this.inner.relative(a0);
    }

    @Override
    public final void setFetchDirection(int a0) throws SQLException {
        this.inner.setFetchDirection(a0);
    }

    @Override
    public final int getFetchDirection() throws SQLException {
        return this.inner.getFetchDirection();
    }

    @Override
    public final void setFetchSize(int a0) throws SQLException {
        this.inner.setFetchSize(a0);
    }

    @Override
    public final int getFetchSize() throws SQLException {
        return this.inner.getFetchSize();
    }

    @Override
    public final int getConcurrency() throws SQLException {
        return this.inner.getConcurrency();
    }

    @Override
    public final boolean rowUpdated() throws SQLException {
        return this.inner.rowUpdated();
    }

    @Override
    public final boolean rowInserted() throws SQLException {
        return this.inner.rowInserted();
    }

    @Override
    public final boolean rowDeleted() throws SQLException {
        return this.inner.rowDeleted();
    }

    @Override
    public final void updateNull(String a0) throws SQLException {
        this.inner.updateNull(a0);
    }

    @Override
    public final void updateNull(int a0) throws SQLException {
        this.inner.updateNull(a0);
    }

    @Override
    public final void updateBoolean(String a0, boolean a1) throws SQLException {
        this.inner.updateBoolean(a0, a1);
    }

    @Override
    public final void updateBoolean(int a0, boolean a1) throws SQLException {
        this.inner.updateBoolean(a0, a1);
    }

    @Override
    public final void updateByte(int a0, byte a1) throws SQLException {
        this.inner.updateByte(a0, a1);
    }

    @Override
    public final void updateByte(String a0, byte a1) throws SQLException {
        this.inner.updateByte(a0, a1);
    }

    @Override
    public final void updateShort(String a0, short a1) throws SQLException {
        this.inner.updateShort(a0, a1);
    }

    @Override
    public final void updateShort(int a0, short a1) throws SQLException {
        this.inner.updateShort(a0, a1);
    }

    @Override
    public final void updateInt(int a0, int a1) throws SQLException {
        this.inner.updateInt(a0, a1);
    }

    @Override
    public final void updateInt(String a0, int a1) throws SQLException {
        this.inner.updateInt(a0, a1);
    }

    @Override
    public final void updateLong(int a0, long a1) throws SQLException {
        this.inner.updateLong(a0, a1);
    }

    @Override
    public final void updateLong(String a0, long a1) throws SQLException {
        this.inner.updateLong(a0, a1);
    }

    @Override
    public final void updateFloat(int a0, float a1) throws SQLException {
        this.inner.updateFloat(a0, a1);
    }

    @Override
    public final void updateFloat(String a0, float a1) throws SQLException {
        this.inner.updateFloat(a0, a1);
    }

    @Override
    public final void updateDouble(String a0, double a1) throws SQLException {
        this.inner.updateDouble(a0, a1);
    }

    @Override
    public final void updateDouble(int a0, double a1) throws SQLException {
        this.inner.updateDouble(a0, a1);
    }

    @Override
    public final void updateBigDecimal(String a0, BigDecimal a1) throws SQLException {
        this.inner.updateBigDecimal(a0, a1);
    }

    @Override
    public final void updateBigDecimal(int a0, BigDecimal a1) throws SQLException {
        this.inner.updateBigDecimal(a0, a1);
    }

    @Override
    public final void updateString(String a0, String a1) throws SQLException {
        this.inner.updateString(a0, a1);
    }

    @Override
    public final void updateString(int a0, String a1) throws SQLException {
        this.inner.updateString(a0, a1);
    }

    @Override
    public final void updateBytes(String a0, byte[] a1) throws SQLException {
        this.inner.updateBytes(a0, a1);
    }

    @Override
    public final void updateBytes(int a0, byte[] a1) throws SQLException {
        this.inner.updateBytes(a0, a1);
    }

    @Override
    public final void updateDate(String a0, Date a1) throws SQLException {
        this.inner.updateDate(a0, a1);
    }

    @Override
    public final void updateDate(int a0, Date a1) throws SQLException {
        this.inner.updateDate(a0, a1);
    }

    @Override
    public final void updateTime(int a0, Time a1) throws SQLException {
        this.inner.updateTime(a0, a1);
    }

    @Override
    public final void updateTime(String a0, Time a1) throws SQLException {
        this.inner.updateTime(a0, a1);
    }

    @Override
    public final void updateTimestamp(int a0, Timestamp a1) throws SQLException {
        this.inner.updateTimestamp(a0, a1);
    }

    @Override
    public final void updateTimestamp(String a0, Timestamp a1) throws SQLException {
        this.inner.updateTimestamp(a0, a1);
    }

    @Override
    public final void updateAsciiStream(int a0, InputStream a1) throws SQLException {
        this.inner.updateAsciiStream(a0, a1);
    }

    @Override
    public final void updateAsciiStream(int a0, InputStream a1, long a2) throws SQLException {
        this.inner.updateAsciiStream(a0, a1, a2);
    }

    @Override
    public final void updateAsciiStream(String a0, InputStream a1, long a2) throws SQLException {
        this.inner.updateAsciiStream(a0, a1, a2);
    }

    @Override
    public final void updateAsciiStream(int a0, InputStream a1, int a2) throws SQLException {
        this.inner.updateAsciiStream(a0, a1, a2);
    }

    @Override
    public final void updateAsciiStream(String a0, InputStream a1, int a2) throws SQLException {
        this.inner.updateAsciiStream(a0, a1, a2);
    }

    @Override
    public final void updateAsciiStream(String a0, InputStream a1) throws SQLException {
        this.inner.updateAsciiStream(a0, a1);
    }

    @Override
    public final void updateBinaryStream(String a0, InputStream a1, long a2) throws SQLException {
        this.inner.updateBinaryStream(a0, a1, a2);
    }

    @Override
    public final void updateBinaryStream(String a0, InputStream a1) throws SQLException {
        this.inner.updateBinaryStream(a0, a1);
    }

    @Override
    public final void updateBinaryStream(int a0, InputStream a1, int a2) throws SQLException {
        this.inner.updateBinaryStream(a0, a1, a2);
    }

    @Override
    public final void updateBinaryStream(String a0, InputStream a1, int a2) throws SQLException {
        this.inner.updateBinaryStream(a0, a1, a2);
    }

    @Override
    public final void updateBinaryStream(int a0, InputStream a1, long a2) throws SQLException {
        this.inner.updateBinaryStream(a0, a1, a2);
    }

    @Override
    public final void updateBinaryStream(int a0, InputStream a1) throws SQLException {
        this.inner.updateBinaryStream(a0, a1);
    }

    @Override
    public final void updateCharacterStream(int a0, Reader a1, long a2) throws SQLException {
        this.inner.updateCharacterStream(a0, a1, a2);
    }

    @Override
    public final void updateCharacterStream(String a0, Reader a1) throws SQLException {
        this.inner.updateCharacterStream(a0, a1);
    }

    @Override
    public final void updateCharacterStream(String a0, Reader a1, int a2) throws SQLException {
        this.inner.updateCharacterStream(a0, a1, a2);
    }

    @Override
    public final void updateCharacterStream(String a0, Reader a1, long a2) throws SQLException {
        this.inner.updateCharacterStream(a0, a1, a2);
    }

    @Override
    public final void updateCharacterStream(int a0, Reader a1) throws SQLException {
        this.inner.updateCharacterStream(a0, a1);
    }

    @Override
    public final void updateCharacterStream(int a0, Reader a1, int a2) throws SQLException {
        this.inner.updateCharacterStream(a0, a1, a2);
    }

    @Override
    public final void updateObject(int a0, Object a1, int a2) throws SQLException {
        this.inner.updateObject(a0, a1, a2);
    }

    @Override
    public final void updateObject(int a0, Object a1) throws SQLException {
        this.inner.updateObject(a0, a1);
    }

    @Override
    public final void updateObject(String a0, Object a1, int a2) throws SQLException {
        this.inner.updateObject(a0, a1, a2);
    }

    @Override
    public final void updateObject(String a0, Object a1) throws SQLException {
        this.inner.updateObject(a0, a1);
    }

    @Override
    public final void insertRow() throws SQLException {
        this.inner.insertRow();
    }

    @Override
    public final void updateRow() throws SQLException {
        this.inner.updateRow();
    }

    @Override
    public final void deleteRow() throws SQLException {
        this.inner.deleteRow();
    }

    @Override
    public final void refreshRow() throws SQLException {
        this.inner.refreshRow();
    }

    @Override
    public final void cancelRowUpdates() throws SQLException {
        this.inner.cancelRowUpdates();
    }

    @Override
    public final void moveToInsertRow() throws SQLException {
        this.inner.moveToInsertRow();
    }

    @Override
    public final void moveToCurrentRow() throws SQLException {
        this.inner.moveToCurrentRow();
    }

    @Override
    public final Statement getStatement() throws SQLException {
        return this.inner.getStatement();
    }

    @Override
    public final Blob getBlob(int a0) throws SQLException {
        return this.inner.getBlob(a0);
    }

    @Override
    public final Blob getBlob(String a0) throws SQLException {
        return this.inner.getBlob(a0);
    }

    @Override
    public final Clob getClob(int a0) throws SQLException {
        return this.inner.getClob(a0);
    }

    @Override
    public final Clob getClob(String a0) throws SQLException {
        return this.inner.getClob(a0);
    }

    @Override
    public final void updateRef(String a0, Ref a1) throws SQLException {
        this.inner.updateRef(a0, a1);
    }

    @Override
    public final void updateRef(int a0, Ref a1) throws SQLException {
        this.inner.updateRef(a0, a1);
    }

    @Override
    public final void updateBlob(String a0, InputStream a1, long a2) throws SQLException {
        this.inner.updateBlob(a0, a1, a2);
    }

    @Override
    public final void updateBlob(int a0, InputStream a1, long a2) throws SQLException {
        this.inner.updateBlob(a0, a1, a2);
    }

    @Override
    public final void updateBlob(String a0, Blob a1) throws SQLException {
        this.inner.updateBlob(a0, a1);
    }

    @Override
    public final void updateBlob(int a0, InputStream a1) throws SQLException {
        this.inner.updateBlob(a0, a1);
    }

    @Override
    public final void updateBlob(int a0, Blob a1) throws SQLException {
        this.inner.updateBlob(a0, a1);
    }

    @Override
    public final void updateBlob(String a0, InputStream a1) throws SQLException {
        this.inner.updateBlob(a0, a1);
    }

    @Override
    public final void updateClob(int a0, Reader a1) throws SQLException {
        this.inner.updateClob(a0, a1);
    }

    @Override
    public final void updateClob(String a0, Clob a1) throws SQLException {
        this.inner.updateClob(a0, a1);
    }

    @Override
    public final void updateClob(String a0, Reader a1) throws SQLException {
        this.inner.updateClob(a0, a1);
    }

    @Override
    public final void updateClob(int a0, Reader a1, long a2) throws SQLException {
        this.inner.updateClob(a0, a1, a2);
    }

    @Override
    public final void updateClob(String a0, Reader a1, long a2) throws SQLException {
        this.inner.updateClob(a0, a1, a2);
    }

    @Override
    public final void updateClob(int a0, Clob a1) throws SQLException {
        this.inner.updateClob(a0, a1);
    }

    @Override
    public final void updateArray(String a0, Array a1) throws SQLException {
        this.inner.updateArray(a0, a1);
    }

    @Override
    public final void updateArray(int a0, Array a1) throws SQLException {
        this.inner.updateArray(a0, a1);
    }

    @Override
    public final RowId getRowId(int a0) throws SQLException {
        return this.inner.getRowId(a0);
    }

    @Override
    public final RowId getRowId(String a0) throws SQLException {
        return this.inner.getRowId(a0);
    }

    @Override
    public final void updateRowId(int a0, RowId a1) throws SQLException {
        this.inner.updateRowId(a0, a1);
    }

    @Override
    public final void updateRowId(String a0, RowId a1) throws SQLException {
        this.inner.updateRowId(a0, a1);
    }

    @Override
    public final int getHoldability() throws SQLException {
        return this.inner.getHoldability();
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.inner.isClosed();
    }

    @Override
    public final void updateNString(int a0, String a1) throws SQLException {
        this.inner.updateNString(a0, a1);
    }

    @Override
    public final void updateNString(String a0, String a1) throws SQLException {
        this.inner.updateNString(a0, a1);
    }

    @Override
    public final void updateNClob(String a0, Reader a1, long a2) throws SQLException {
        this.inner.updateNClob(a0, a1, a2);
    }

    @Override
    public final void updateNClob(String a0, NClob a1) throws SQLException {
        this.inner.updateNClob(a0, a1);
    }

    @Override
    public final void updateNClob(String a0, Reader a1) throws SQLException {
        this.inner.updateNClob(a0, a1);
    }

    @Override
    public final void updateNClob(int a0, Reader a1) throws SQLException {
        this.inner.updateNClob(a0, a1);
    }

    @Override
    public final void updateNClob(int a0, Reader a1, long a2) throws SQLException {
        this.inner.updateNClob(a0, a1, a2);
    }

    @Override
    public final void updateNClob(int a0, NClob a1) throws SQLException {
        this.inner.updateNClob(a0, a1);
    }

    @Override
    public final NClob getNClob(int a0) throws SQLException {
        return this.inner.getNClob(a0);
    }

    @Override
    public final NClob getNClob(String a0) throws SQLException {
        return this.inner.getNClob(a0);
    }

    @Override
    public final SQLXML getSQLXML(int a0) throws SQLException {
        return this.inner.getSQLXML(a0);
    }

    @Override
    public final SQLXML getSQLXML(String a0) throws SQLException {
        return this.inner.getSQLXML(a0);
    }

    @Override
    public final void updateSQLXML(String a0, SQLXML a1) throws SQLException {
        this.inner.updateSQLXML(a0, a1);
    }

    @Override
    public final void updateSQLXML(int a0, SQLXML a1) throws SQLException {
        this.inner.updateSQLXML(a0, a1);
    }

    @Override
    public final String getNString(int a0) throws SQLException {
        return this.inner.getNString(a0);
    }

    @Override
    public final String getNString(String a0) throws SQLException {
        return this.inner.getNString(a0);
    }

    @Override
    public final Reader getNCharacterStream(int a0) throws SQLException {
        return this.inner.getNCharacterStream(a0);
    }

    @Override
    public final Reader getNCharacterStream(String a0) throws SQLException {
        return this.inner.getNCharacterStream(a0);
    }

    @Override
    public final void updateNCharacterStream(int a0, Reader a1, long a2) throws SQLException {
        this.inner.updateNCharacterStream(a0, a1, a2);
    }

    @Override
    public final void updateNCharacterStream(int a0, Reader a1) throws SQLException {
        this.inner.updateNCharacterStream(a0, a1);
    }

    @Override
    public final void updateNCharacterStream(String a0, Reader a1, long a2) throws SQLException {
        this.inner.updateNCharacterStream(a0, a1, a2);
    }

    @Override
    public final void updateNCharacterStream(String a0, Reader a1) throws SQLException {
        this.inner.updateNCharacterStream(a0, a1);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return this.inner.getObject(columnIndex, type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.inner.getObject(columnLabel, type);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.inner.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.inner.isWrapperFor(iface);
    }
}

