/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import whatap.agent.Configure;
import whatap.agent.jdbc.WrCallableStatement;
import whatap.agent.jdbc.WrPreparedStatement;
import whatap.agent.jdbc.WrStatement;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.trace.sql.TraceSQL;
import whatap.agent.util.LeakableObject;
import whatap.lang.var.IntString;
import whatap.notice.CONNECTION_NOT_CLOSE;
import whatap.notice.WHATAP_ERROR;
import whatap.util.DateUtil;
import whatap.util.HashUtil;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectSimpleConnection
implements Connection {
    private static Configure conf = Configure.getInstance();
    private LeakableObject object;
    private Connection inner;
    private int dbc;
    private int service;
    static StringKeyLinkedMap<IntString> classNameMap = new StringKeyLinkedMap(31, 0.7f).setMax(31);

    public DetectSimpleConnection(Connection inner, int dbc, int service) {
        this.inner = inner;
        if (DetectSimpleConnection.conf.trace2_dbc_leak_enabled) {
            this.object = DetectSimpleConnection.conf.trace2_dbc_leak_fullstack_enabled ? new LeakableObject(new CONNECTION_NOT_CLOSE("connection leak detected"), dbc, service, DateUtil.now(), null, true) : new LeakableObject(WHATAP_ERROR.connection_not_close, dbc, service, DateUtil.now(), null, false);
        }
        this.dbc = dbc;
        this.service = service;
    }

    @Override
    public final void setReadOnly(boolean a0) throws SQLException {
        this.inner.setReadOnly(a0);
    }

    @Override
    public final void close() throws SQLException {
        if (this.object != null) {
            this.object.close();
        }
        if (!DetectSimpleConnection.conf.trace_dbc_close_enabled) {
            this.inner.close();
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (ctx != null && ctx.unclosedConnMap != null) {
                int id = TraceSQL.isql.getHashKey(this.inner);
                ctx.unclosedConnMap.remove(id);
            }
        } else {
            String innerClassName = this.inner.getClass().getName();
            IntString inner = classNameMap.get(innerClassName);
            if (inner == null) {
                inner = new IntString();
                inner.v2 = "[" + StringUtil.cutLastString(innerClassName, '.') + "].CLOSE-DBC()";
                inner.v1 = HashUtil.hash(inner.v2);
                classNameMap.put(innerClassName, inner);
            }
            Object stat = TraceSQL.dbcCloseStart(inner.v1, inner.v2, this.inner);
            SQLException err = null;
            try {
                this.inner.close();
            }
            catch (SQLException e) {
                err = e;
                throw e;
            }
            finally {
                TraceSQL.dbcCloseEnd(stat, err);
            }
        }
    }

    @Override
    public final boolean isReadOnly() throws SQLException {
        return this.inner.isReadOnly();
    }

    @Override
    public final Statement createStatement() throws SQLException {
        if (DetectSimpleConnection.conf.trace_stmt_wrap_enabled) {
            return new WrStatement(this, this.inner.createStatement());
        }
        return this.inner.createStatement();
    }

    @Override
    public final Statement createStatement(int a0, int a1) throws SQLException {
        return this.inner.createStatement(a0, a1);
    }

    @Override
    public final Statement createStatement(int a0, int a1, int a2) throws SQLException {
        return this.inner.createStatement(a0, a1, a2);
    }

    @Override
    public final PreparedStatement prepareStatement(String a0, int a1) throws SQLException {
        return this.inner.prepareStatement(a0, a1);
    }

    @Override
    public final PreparedStatement prepareStatement(String a0, int a1, int a2) throws SQLException {
        return this.inner.prepareStatement(a0, a1, a2);
    }

    @Override
    public final PreparedStatement prepareStatement(String a0, int a1, int a2, int a3) throws SQLException {
        return this.inner.prepareStatement(a0, a1, a2, a3);
    }

    @Override
    public final PreparedStatement prepareStatement(String a0, int[] a1) throws SQLException {
        return this.inner.prepareStatement(a0, a1);
    }

    @Override
    public final PreparedStatement prepareStatement(String a0, String[] a1) throws SQLException {
        return this.inner.prepareStatement(a0, a1);
    }

    @Override
    public final PreparedStatement prepareStatement(String a0) throws SQLException {
        if (DetectSimpleConnection.conf.trace_pstmt_wrap_enabled) {
            return new WrPreparedStatement(this, this.inner.prepareStatement(a0), a0);
        }
        return this.inner.prepareStatement(a0);
    }

    @Override
    public final CallableStatement prepareCall(String a0) throws SQLException {
        if (DetectSimpleConnection.conf.trace_cstmt_wrap_enabled) {
            return new WrCallableStatement((Connection)this, this.inner.prepareCall(a0), a0);
        }
        return this.inner.prepareCall(a0);
    }

    @Override
    public final CallableStatement prepareCall(String a0, int a1, int a2) throws SQLException {
        return this.inner.prepareCall(a0, a1, a2);
    }

    @Override
    public final CallableStatement prepareCall(String a0, int a1, int a2, int a3) throws SQLException {
        return this.inner.prepareCall(a0, a1, a2, a3);
    }

    @Override
    public final String nativeSQL(String a0) throws SQLException {
        return this.inner.nativeSQL(a0);
    }

    @Override
    public final void setAutoCommit(boolean auto) throws SQLException {
        this.inner.setAutoCommit(auto);
    }

    @Override
    public final boolean getAutoCommit() throws SQLException {
        return this.inner.getAutoCommit();
    }

    @Override
    public final void commit() throws SQLException {
        this.inner.commit();
    }

    @Override
    public final void rollback(Savepoint a0) throws SQLException {
        this.inner.rollback(a0);
    }

    @Override
    public final void rollback() throws SQLException {
        this.inner.rollback();
    }

    @Override
    public final boolean isClosed() throws SQLException {
        return this.inner.isClosed();
    }

    @Override
    public final DatabaseMetaData getMetaData() throws SQLException {
        return this.inner.getMetaData();
    }

    @Override
    public final void setCatalog(String a0) throws SQLException {
        this.inner.setCatalog(a0);
    }

    @Override
    public final String getCatalog() throws SQLException {
        return this.inner.getCatalog();
    }

    @Override
    public final void setTransactionIsolation(int a0) throws SQLException {
        this.inner.setTransactionIsolation(a0);
    }

    @Override
    public final int getTransactionIsolation() throws SQLException {
        return this.inner.getTransactionIsolation();
    }

    @Override
    public final SQLWarning getWarnings() throws SQLException {
        return this.inner.getWarnings();
    }

    @Override
    public final void clearWarnings() throws SQLException {
        this.inner.clearWarnings();
    }

    public final Map getTypeMap() throws SQLException {
        return this.inner.getTypeMap();
    }

    @Override
    public <T> T unwrap(Class<T> a0) throws SQLException {
        return this.inner.unwrap(a0);
    }

    @Override
    public boolean isWrapperFor(Class<?> a0) throws SQLException {
        return this.inner.isWrapperFor(a0);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> a0) throws SQLException {
        this.inner.setTypeMap(a0);
    }

    @Override
    public final void setHoldability(int a0) throws SQLException {
        this.inner.setHoldability(a0);
    }

    @Override
    public final int getHoldability() throws SQLException {
        return this.inner.getHoldability();
    }

    @Override
    public final Savepoint setSavepoint() throws SQLException {
        return this.inner.setSavepoint();
    }

    @Override
    public final Savepoint setSavepoint(String a0) throws SQLException {
        return this.inner.setSavepoint(a0);
    }

    @Override
    public final void releaseSavepoint(Savepoint a0) throws SQLException {
        this.inner.releaseSavepoint(a0);
    }

    @Override
    public final Clob createClob() throws SQLException {
        return this.inner.createClob();
    }

    @Override
    public final Blob createBlob() throws SQLException {
        return this.inner.createBlob();
    }

    @Override
    public final NClob createNClob() throws SQLException {
        return this.inner.createNClob();
    }

    @Override
    public final SQLXML createSQLXML() throws SQLException {
        return this.inner.createSQLXML();
    }

    @Override
    public final boolean isValid(int a0) throws SQLException {
        return this.inner.isValid(a0);
    }

    @Override
    public final void setClientInfo(Properties a0) throws SQLClientInfoException {
        this.inner.setClientInfo(a0);
    }

    @Override
    public final void setClientInfo(String a0, String a1) throws SQLClientInfoException {
        this.inner.setClientInfo(a0, a1);
    }

    @Override
    public final Properties getClientInfo() throws SQLException {
        return this.inner.getClientInfo();
    }

    @Override
    public final String getClientInfo(String a0) throws SQLException {
        return this.inner.getClientInfo(a0);
    }

    @Override
    public final Array createArrayOf(String a0, Object[] a1) throws SQLException {
        return this.inner.createArrayOf(a0, a1);
    }

    @Override
    public final Struct createStruct(String a0, Object[] a1) throws SQLException {
        return this.inner.createStruct(a0, a1);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.inner.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.inner.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.inner.abort(executor);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.inner.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.inner.getNetworkTimeout();
    }

    public String toString() {
        return this.inner.toString();
    }
}

