/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.data;

import whatap.agent.Configure;
import whatap.agent.ParamSecurity;
import whatap.agent.SecurityMaster;
import whatap.agent.conf.ConfTrace;
import whatap.agent.counter.meter.tx.MeterService;
import whatap.agent.data.DataTextAgent;
import whatap.agent.data.ZipProfileThread;
import whatap.agent.trace.TraceContext;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.ProfilePack;
import whatap.lang.service.TxRecord;
import whatap.lang.step.ResultSetStep;
import whatap.lang.step.Step;
import whatap.lang.value.MapValue;
import whatap.util.HashUtil;
import whatap.util.RequestQueue;

public class ProfileVirtualTxThread
extends Thread {
    private static ProfileVirtualTxThread instance;
    RequestQueue<ChildTx> queue = new RequestQueue(ConfTrace.trace_txsplit_queue_size);
    static SecurityMaster secuMaster;
    static Configure conf;

    public static final synchronized ProfileVirtualTxThread getInstance() {
        if (instance == null) {
            instance = new ProfileVirtualTxThread();
            instance.setDaemon(true);
            instance.start();
        }
        return instance;
    }

    private ProfileVirtualTxThread() {
        ConfObserver.add("ProfileVirtualTxThread", new Runnable(){

            public void run() {
                ProfileVirtualTxThread.this.queue.setCapacity(ConfTrace.trace_txsplit_queue_size);
            }
        });
    }

    public void add(long curTime, String childName, long childtxid, int childStart, int childElapsed, TraceContext p, Step[] steps) {
        ChildTx x = new ChildTx();
        x.etime = curTime;
        x.childStart = childStart;
        x.parent_txid = p.txid;
        x.child_txid = childtxid;
        x.steps = steps;
        x.service = childName;
        x.childElapsed = childElapsed;
        x.sql_count = p.sql_count;
        x.sql_time = p.sql_time;
        x.rs_count = p.rs_count;
        x.rs_time = (int)p.rs_time;
        x.dbc_time = p.dbc_time;
        x.httpc_count = p.httpc_count;
        x.httpc_time = p.httpc_time;
        x.method_count = p.method_count;
        x.method_time = p.method_time;
        if (p.error != null) {
            x.error = p.error.txErrorCode;
            x.error_class = p.error.className;
            x.error_message = p.error.message;
            p.error = null;
        }
        this.queue.put(x);
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    ChildTx childTx = this.queue.get();
                    ProfilePack p = new ProfilePack();
                    p.pcode = ProfileVirtualTxThread.secuMaster.PCODE;
                    p.oid = ProfileVirtualTxThread.secuMaster.OID;
                    p.time = childTx.etime;
                    int serviceHash = HashUtil.hash(childTx.service);
                    boolean isNew = DataTextAgent.SERVICE.add(serviceHash, childTx.service);
                    TxRecord tx = new TxRecord();
                    tx.txid = childTx.child_txid;
                    tx.mcaller = childTx.parent_txid;
                    tx.endTime = childTx.etime;
                    tx.cipher = ParamSecurity.keyHash;
                    tx.service = serviceHash;
                    tx.elapsed = childTx.childElapsed;
                    if (isNew && ConfTrace.trace_newname_safe_enabled) {
                        tx.txName = childTx.service;
                    }
                    tx.error = childTx.error;
                    tx.error_class = childTx.error_class;
                    tx.error_message = childTx.error_message;
                    if (tx.error != 0L) {
                        tx.errorLevel = (byte)20;
                    }
                    tx.fields = new MapValue();
                    tx.fields.put("ParentTxid", childTx.parent_txid);
                    tx.fields.put("TxType", "Virtual");
                    tx.fields.put("FirstStepIdx", childTx.steps[0].index);
                    if (childTx.childStart >= 0) {
                        int sql_count = 0;
                        int sql_time = 0;
                        int httpc_count = 0;
                        int httpc_time = 0;
                        int rs_count = 0;
                        int rs_time = 0;
                        int dbc_time = 0;
                        int method_count = 0;
                        int method_time = 0;
                        block11: for (int i = 0; i < childTx.steps.length; ++i) {
                            Step sp = childTx.steps[i];
                            sp.start_time -= childTx.childStart;
                            switch (sp.getStepType()) {
                                case 18: {
                                    ++sql_count;
                                    sql_time += sp.getElapsed();
                                    continue block11;
                                }
                                case 19: {
                                    ++httpc_count;
                                    httpc_time += sp.getElapsed();
                                    continue block11;
                                }
                                case 3: {
                                    rs_count += ((ResultSetStep)sp).fetch;
                                    rs_time += sp.getElapsed();
                                    continue block11;
                                }
                                case 17: {
                                    ++method_count;
                                    method_time = sp.getElapsed();
                                    continue block11;
                                }
                                case 8: {
                                    dbc_time += sp.getElapsed();
                                }
                            }
                        }
                        tx.sqlCount = sql_count;
                        tx.sqlTime = sql_time;
                        tx.sqlFetchCount = rs_count;
                        tx.sqlFetchTime = rs_time;
                        tx.dbcTime = dbc_time;
                        tx.httpcCount = httpc_count;
                        tx.httpcTime = httpc_time;
                        tx.methodCount = method_count;
                        tx.methodTime = method_time;
                        tx.fields.put("ParentElapsed", childTx.childStart + childTx.childElapsed);
                        tx.fields.put("ParentElapsed", childTx.childStart + childTx.childElapsed);
                        if (childTx.sql_count > 0) {
                            tx.fields.put("ParentSqlCount", childTx.sql_count);
                            tx.fields.put("ParentSqlTime", childTx.sql_time);
                        }
                        if (childTx.httpc_count > 0) {
                            tx.fields.put("ParentHttpCallCount", childTx.httpc_count);
                            tx.fields.put("ParentHttpCallTime", childTx.httpc_time);
                        }
                        if (childTx.rs_count > 0) {
                            tx.fields.put("ParentFetchCount", childTx.rs_count);
                            tx.fields.put("ParentFetchTime", childTx.rs_time);
                        }
                        if (childTx.dbc_time > 0) {
                            tx.fields.put("ParentDbcTime", childTx.dbc_time);
                        }
                    }
                    MeterService.getInstance().addVirtualTx(tx);
                    p.transaction = tx;
                    p.steps = Step.toBytes(childTx.steps);
                    ZipProfileThread.getInstance().add(p);
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    static {
        secuMaster = SecurityMaster.getInstance();
        conf = Configure.getInstance();
    }

    static class ChildTx {
        long etime;
        int childStart;
        long parent_txid;
        long child_txid;
        Step[] steps;
        String service;
        public int childElapsed;
        public int sql_count;
        public int sql_time;
        public int dbc_time;
        public int rs_count;
        public int rs_time;
        public int httpc_count;
        public int httpc_time;
        public int method_count;
        public int method_time;
        public long error;
        public String error_class;
        public String error_message;

        ChildTx() {
        }
    }
}

