/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.data;

import java.util.Enumeration;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.data.DataPackSender;
import whatap.agent.net.TcpSession;
import whatap.agent.util.ThreadNameUtil;
import whatap.lang.conf.ConfObserver;
import whatap.lang.pack.TextPack;
import whatap.util.DateUtil;
import whatap.util.HashUtil;
import whatap.util.IntKeyLinkedMap;
import whatap.util.IntLinkedSet;
import whatap.util.RequestQueue;
import whatap.util.StringKeyLinkedMap;

public class DataTextAgent
extends Thread {
    private static DataTextAgent instance;
    final Configure conf = Configure.getInstance();
    private RequestQueue<TextPack.TextRec> queue = new RequestQueue(200);
    long last_log;
    TextPack bufferPack = new TextPack();
    int bufferedLength = 0;
    static final int BUFFERED_MAX = 102400;
    long last_sent = DateUtil.now();
    private static IntKeyLinkedMap<HashedData> hashedDataTable;
    public static HashedData DBC;
    public static HashedData METHOD;
    public static HashedData HTTPC_URL;
    public static HashedData HTTPC_HOST;
    public static HashedData ERROR;
    public static HashedData SERVICE;
    public static HashedData SQL;
    public static HashedData STACK;
    public static HashedData MESSAGE;
    public static HashedData USERAGENT;
    public static HashedData REFERER;
    public static HashedData LOGIN;
    public static HashedData SQL_PARAM;
    public static HashedData HTTP_DOMAIN;
    public static HashedData MTRACE_SPEC;
    public static HashedData MTRACE_CALLER_URL;
    public static HashedData NET_DISPLAY;
    public static HashedData SPLIT_HTTP_HEADER;
    public static StringKeyLinkedMap<Runnable> resets;
    public static IntKeyLinkedMap<String> DbcUrlMap;

    public static synchronized DataTextAgent getInstance() {
        if (instance == null) {
            instance = new DataTextAgent();
            instance.setDaemon(true);
            instance.start();
            ThreadNameUtil.whatap(instance);
        }
        return instance;
    }

    public DataTextAgent() {
        this.queue.setCapacity(this.conf.text_queue_size);
        ConfObserver.add("DataTextAgent", new Runnable(){

            public void run() {
                DataTextAgent.this.queue.setCapacity(DataTextAgent.this.conf.text_queue_size);
            }
        });
    }

    public void add(byte type, int hash, String text) {
        long now;
        boolean ok = this.queue.put(new TextPack.TextRec(type, hash, text));
        if (!ok && (now = System.currentTimeMillis()) - this.last_log >= 10000L) {
            this.last_log = now;
            Logger.println("Overflow text-queue size=" + this.queue.size() + ", please increase \"conf.text_queue_size\"");
        }
    }

    public void add(byte type, int hash, int cipher, byte[] p1, byte[] p2) {
        this.queue.put(new TextPack.TextRec(type, hash, new TextPack.SqlParam(cipher, p1, p2)));
    }

    public void reset() {
        Enumeration<HashedData> e1 = hashedDataTable.values();
        while (e1.hasMoreElements()) {
            e1.nextElement().sent.clear();
        }
        Enumeration<Runnable> en = resets.values();
        while (en.hasMoreElements()) {
            en.nextElement().run();
        }
    }

    private long getHourUnit(long now) {
        return now / 3600000L;
    }

    public void run() {
        Configure conf = Configure.getInstance();
        int text_reset = conf.text_reset;
        long last_reset_timeunit = this.getHourUnit(DateUtil.now());
        while (true) {
            TextPack.TextRec r = this.queue.get(1000L);
            try {
                long today_reset_timeunit;
                if (r != null) {
                    this.bufferPack.records.add(r);
                    this.bufferedLength += r.text.length();
                    if (this.bufferedLength >= 102400) {
                        this.send();
                    }
                }
                long now = DateUtil.now();
                if (TcpSession.last_connected_time > 0L && this.bufferedLength > 0) {
                    if (now - this.last_sent >= 5000L) {
                        this.send();
                    }
                } else {
                    this.last_sent = now;
                }
                if (last_reset_timeunit == (today_reset_timeunit = this.getHourUnit(now)) && text_reset == conf.text_reset) continue;
                last_reset_timeunit = today_reset_timeunit;
                text_reset = conf.text_reset;
                if (this.bufferedLength > 0) {
                    this.send();
                }
                this.reset();
                continue;
            }
            catch (Throwable e) {
                System.setProperty("whatap.error.text", DateUtil.timestamp() + " " + e);
                continue;
            }
            break;
        }
    }

    private void send() {
        this.last_sent = DateUtil.now();
        if (this.conf.text_zip_enabled && this.bufferedLength >= 1024) {
            DataPackSender.sentZip(this.bufferPack);
        } else {
            DataPackSender.sent(this.bufferPack);
        }
        this.bufferPack = new TextPack();
        this.bufferPack.time = DateUtil.currentTime();
        this.bufferedLength = 0;
    }

    public static void append(byte type, int hash, String text) {
        HashedData hd = hashedDataTable.get(type);
        if (hd != null) {
            hd.add(hash, text);
        }
    }

    public static void addMethod(int fullname_hash, String fullname) {
        METHOD.add(fullname_hash, fullname);
    }

    public static void sendMethodAfterBoot() {
    }

    public static int send(byte type, String text) {
        int hash = HashUtil.hash(text);
        DataTextAgent.getInstance().add(type, hash, text);
        return hash;
    }

    public static void dbc(int dbc_hash, String url) {
        DBC.add(dbc_hash, url);
        DbcUrlMap.put(dbc_hash, url);
        if (Configure.getInstance().trace_dbc_hash_method_enabled) {
            METHOD.add(dbc_hash, url);
        }
    }

    static {
        hashedDataTable = new IntKeyLinkedMap();
        DBC = new HashedData(3, 1000);
        METHOD = new HashedData(6, 5000);
        HTTPC_URL = new HashedData(4, 2000);
        HTTPC_HOST = new HashedData(10, 2000);
        ERROR = new HashedData(5, 1000);
        SERVICE = new HashedData(1, 10000);
        SQL = new HashedData(2, 2000);
        STACK = new HashedData(7, 20000);
        MESSAGE = new HashedData(11, 2000);
        USERAGENT = new HashedData(9, 1000);
        REFERER = new HashedData(8, 1000);
        LOGIN = new HashedData(18, 1000);
        SQL_PARAM = new HashedData(19, 1000);
        HTTP_DOMAIN = new HashedData(20, 1000);
        MTRACE_SPEC = new HashedData(53, 1000);
        MTRACE_CALLER_URL = new HashedData(54, 2000);
        NET_DISPLAY = new HashedData(48, 500);
        SPLIT_HTTP_HEADER = new HashedData(70, 2000);
        resets = new StringKeyLinkedMap().setMax(20);
        DbcUrlMap = new IntKeyLinkedMap(1023, 1.0f).setMax(500);
    }

    public static class HashedData {
        private byte type;
        private final IntLinkedSet sent;

        public HashedData(byte type, int n) {
            this.type = type;
            this.sent = new IntLinkedSet().setMax(n);
            hashedDataTable.put(type, this);
        }

        public boolean add(int hash, String text) {
            if (!this.sent.contains(hash)) {
                this.sent.put(hash);
                DataTextAgent.getInstance().add(this.type, hash, text);
                return true;
            }
            return false;
        }

        public boolean addOk(int hash, String text) {
            if (!this.sent.contains(hash)) {
                this.sent.put(hash);
                DataTextAgent.getInstance().add(this.type, hash, text);
                return true;
            }
            return false;
        }

        public void add(int hash, StackTraceElement text) {
            if (!this.sent.contains(hash)) {
                this.sent.put(hash);
                DataTextAgent.getInstance().add(this.type, hash, text.toString());
            }
        }

        public boolean addOk(int hash, StackTraceElement text) {
            if (!this.sent.contains(hash)) {
                this.sent.put(hash);
                DataTextAgent.getInstance().add(this.type, hash, text.toString());
                return true;
            }
            return false;
        }

        public void add(int hash, int cipher, byte[] p1, byte[] p2) {
            if (!this.sent.contains(hash)) {
                this.sent.put(hash);
                DataTextAgent.getInstance().add(this.type, hash, cipher, p1, p2);
            }
        }
    }
}

