/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.res.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import whatap.agent.Logger;
import whatap.agent.conf.ConfSysMon;
import whatap.util.FileUtil;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;

public class LinuxProcStatUtil {
    private static final double millistime = 1000.0;
    private static CpuStatRaw lastCPUStatRaw;
    static StringKeyLinkedMap<H> handler;
    private static int pageSize;
    static long lastProcCpuTime;
    static long lastTime;

    public static boolean isLinux() {
        return new File("/proc/stat").exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Memory getMemory() {
        Memory memory;
        File file = new File("/proc", "meminfo");
        if (file == null || !file.exists()) {
            return null;
        }
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(file));
            Memory memperf = new Memory();
            while ((line = br.readLine()) != null) {
                String[] words = line.trim().split("[ \t\r\n]+");
                if (words == null || words.length < 3) continue;
                long value = Long.parseLong(words[1]) * LinuxProcStatUtil.toBytes(words[2]);
                H h = handler.get(words[0]);
                if (h == null) continue;
                h.set(memperf, value);
            }
            memory = memperf;
        }
        catch (Throwable throwable) {
            FileUtil.close(br);
            return null;
        }
        catch (Throwable throwable) {
            FileUtil.close(br);
            throw throwable;
        }
        FileUtil.close(br);
        return memory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int checkPageSize() {
        int n;
        BufferedReader br;
        InputStream es;
        OutputStream os;
        InputStream is;
        block8: {
            int n2;
            block7: {
                Runtime rt = Runtime.getRuntime();
                is = null;
                os = null;
                es = null;
                br = null;
                try {
                    Process process = rt.exec(new String[]{"getconf", "PAGE_SIZE"});
                    is = process.getInputStream();
                    os = process.getOutputStream();
                    es = process.getErrorStream();
                    br = new BufferedReader(new InputStreamReader(is));
                    String line = br.readLine();
                    if (line != null && line.length() > 0) {
                        n2 = Integer.parseInt(line);
                        FileUtil.close(is);
                        break block7;
                    }
                    Logger.println("LinuxProcStat", "page size error ");
                    n = 0;
                    FileUtil.close(is);
                    break block8;
                }
                catch (Exception e) {
                    Logger.println("LinuxProcStat", e.toString());
                    int n3 = 0;
                    return n3;
                }
            }
            FileUtil.close(os);
            FileUtil.close(es);
            FileUtil.close(br);
            return n2;
        }
        FileUtil.close(os);
        FileUtil.close(es);
        FileUtil.close(br);
        return n;
        finally {
            FileUtil.close(is);
            FileUtil.close(os);
            FileUtil.close(es);
            FileUtil.close(br);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getProcRss(int pid) {
        String statmFile = "/proc/" + pid + "/statm";
        BufferedReader br = null;
        try {
            String line;
            if (pageSize < 0) {
                pageSize = LinuxProcStatUtil.checkPageSize();
            }
            File file = new File(statmFile);
            br = new BufferedReader(new FileReader(file));
            while ((line = br.readLine()) != null) {
                String[] tokens = line.split(" ");
                if (tokens == null || tokens.length <= 2) continue;
                int rssPages = Integer.parseInt(tokens[1]);
                if (ConfSysMon.linux_pagesize > 0) {
                    long l = rssPages * ConfSysMon.linux_pagesize;
                    FileUtil.close(br);
                    return l;
                }
                long l = rssPages * pageSize;
                FileUtil.close(br);
                return l;
            }
            FileUtil.close(br);
            return 0L;
        }
        catch (Exception e) {
            Logger.println("LinuxProcStat", e.toString());
            return 0L;
        }
        finally {
            FileUtil.close(br);
        }
    }

    private static long toBytes(String unit) {
        long ret = "tb".equals(unit.toLowerCase()) ? 0x10000000000L : ("gb".equals(unit.toLowerCase()) ? 0x40000000L : ("mb".equals(unit.toLowerCase()) ? 0x100000L : ("kb".equals(unit.toLowerCase()) ? 1024L : 1L)));
        return ret;
    }

    public static float getProcCpu(int pid) {
        int ncpu = Runtime.getRuntime().availableProcessors();
        long now = System.currentTimeMillis();
        File file = new File("/proc/" + pid + "/stat");
        byte[] b = FileUtil.readAll(file);
        String s = new String(b);
        String[] words = StringUtil.tokenizer(s, " ");
        long uCpuTime = Long.parseLong(words[13]);
        long sCpuTime = Long.parseLong(words[14]);
        long totCpuTime = (uCpuTime += Long.parseLong(words[15])) + (sCpuTime += Long.parseLong(words[16]));
        long oldCpuTime = lastProcCpuTime;
        long scClkTck = 100L;
        double timediff = now - lastTime;
        lastTime = now;
        lastProcCpuTime = totCpuTime;
        if (oldCpuTime > 0L && timediff > 0.0) {
            return (float)(100.0 * (double)(totCpuTime - oldCpuTime) / (double)scClkTck / (timediff / 1000.0)) / (float)ncpu;
        }
        return 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CPUStat getCpu() {
        BufferedReader br;
        CpuStatRaw rawCPUStat;
        block7: {
            CPUStat cPUStat;
            rawCPUStat = new CpuStatRaw();
            br = null;
            try {
                br = new BufferedReader(new FileReader(new File("/proc", "stat")));
                String line = br.readLine();
                String[] words = StringUtil.tokenizer(line, " ");
                if (words.length > 8 && words[0].equals("cpu")) {
                    rawCPUStat.timestamp = System.currentTimeMillis();
                    rawCPUStat.user = Long.parseLong(words[1]);
                    rawCPUStat.nice = Long.parseLong(words[2]);
                    rawCPUStat.system = Long.parseLong(words[3]);
                    rawCPUStat.idle = Long.parseLong(words[4]);
                    rawCPUStat.iowait = Long.parseLong(words[5]);
                    rawCPUStat.irq = Long.parseLong(words[6]);
                    rawCPUStat.softirq = Long.parseLong(words[7]);
                    rawCPUStat.steal = Long.parseLong(words[8]);
                    break block7;
                }
                cPUStat = null;
            }
            catch (Throwable t) {
                try {
                    CPUStat words = null;
                    return words;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    FileUtil.close(br);
                }
            }
            FileUtil.close(br);
            return cPUStat;
        }
        FileUtil.close(br);
        CpuStatRaw oldRawCPUStat = lastCPUStatRaw;
        lastCPUStatRaw = rawCPUStat;
        CPUStat cpu = new CPUStat();
        if (oldRawCPUStat != null) {
            long user = rawCPUStat.user - oldRawCPUStat.user;
            long nice = rawCPUStat.nice - oldRawCPUStat.nice;
            long system = rawCPUStat.system - oldRawCPUStat.system;
            long idle = rawCPUStat.idle - oldRawCPUStat.idle;
            long iowait = rawCPUStat.iowait - oldRawCPUStat.iowait;
            long irq = rawCPUStat.irq - oldRawCPUStat.irq;
            long softirq = rawCPUStat.softirq - oldRawCPUStat.softirq;
            long steal = rawCPUStat.steal - oldRawCPUStat.steal;
            cpu.jiffies = user + nice + system + idle + iowait + irq + softirq + steal;
            cpu.pct = (float)(user + nice + system + irq + softirq + steal) * 100.0f / (float)cpu.jiffies;
            cpu.user = (float)user * 100.0f / (float)cpu.jiffies;
            cpu.nice = (float)nice * 100.0f / (float)cpu.jiffies;
            cpu.system = (float)system * 100.0f / (float)cpu.jiffies;
            cpu.idle = (float)idle * 100.0f / (float)cpu.jiffies;
            cpu.iowait = (float)iowait * 100.0f / (float)cpu.jiffies;
            cpu.irq = (float)irq * 100.0f / (float)cpu.jiffies;
            cpu.softirq = (float)softirq * 100.0f / (float)cpu.jiffies;
            cpu.steal = (float)steal * 100.0f / (float)cpu.jiffies;
        }
        return cpu;
    }

    static {
        handler = new StringKeyLinkedMap();
        handler.put("MemTotal:", new H(){

            public void set(Memory m, long v) {
                m.total = v;
            }
        });
        handler.put("MemFree:", new H(){

            public void set(Memory m, long v) {
                m.free = v;
            }
        });
        handler.put("MemAvailable:", new H(){

            public void set(Memory m, long v) {
                m.available = v;
            }
        });
        handler.put("Buffers:", new H(){

            public void set(Memory m, long v) {
                m.buffers = v;
            }
        });
        handler.put("SwapTotal:", new H(){

            public void set(Memory m, long v) {
                m.swaptotal = v;
            }
        });
        handler.put("SwapFree:", new H(){

            public void set(Memory m, long v) {
                m.swapfree = v;
            }
        });
        pageSize = -1;
        lastProcCpuTime = 0L;
        lastTime = 0L;
    }

    static interface H {
        public void set(Memory var1, long var2);
    }

    public static class Memory {
        public long total;
        public long free;
        public long available;
        public long buffers;
        public long swapfree;
        public long swaptotal;
    }

    public static class CPUStat {
        public long jiffies;
        public float pct;
        public float user;
        public float nice;
        public float system;
        public float idle;
        public float iowait;
        public float irq;
        public float softirq;
        public float steal;
    }

    static class CpuStatRaw {
        public long timestamp;
        public long user;
        public long nice;
        public long system;
        public long idle;
        public long iowait;
        public long irq;
        public long softirq;
        public long steal;

        CpuStatRaw() {
        }
    }
}

