/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.pools.other;

import java.lang.management.ManagementFactory;
import java.util.Enumeration;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import whatap.agent.Logger;
import whatap.agent.conf.ConfPool;
import whatap.agent.control.ds.DBPoolClassUtil;
import whatap.agent.counter.task.pools.CNT;
import whatap.agent.data.DataTextAgent;
import whatap.util.CastUtil;
import whatap.util.HashUtil;
import whatap.util.IntIntMap;
import whatap.util.LinkedMap;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;
import whatap.util.SystemUtil;

public class JmxPool {
    protected static LinkedMap<ObjectName, String> poolObjectNames = new LinkedMap();
    static StringKeyLinkedMap<CNT> detail = new StringKeyLinkedMap<CNT>(){

        @Override
        protected CNT create(String key) {
            return new CNT();
        }
    };
    static long last_init = 0L;
    static long allowLogTime = System.currentTimeMillis() + 1800000L;

    public static void process(IntIntMap db_num_active, IntIntMap db_num_idle) {
        long now;
        if (SystemUtil.IS_JAVA_IBM || SystemUtil.IS_WINDOWS) {
            return;
        }
        if (ConfPool.pool_detail_enabled) {
            detail.clear();
        }
        boolean allowLogOk = (now = System.currentTimeMillis()) <= allowLogTime;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        if (now > last_init + 600000L) {
            try {
                if (allowLogOk) {
                    Logger.println("JMX-POOL", "search filter: " + ConfPool.jmx_pool_object);
                }
                poolObjectNames.clear();
                Set<ObjectName> ds = server.queryNames(null, new ObjectName(ConfPool.jmx_pool_object));
                for (ObjectName o : ds) {
                    String jndi = StringUtil.strip(o.getKeyProperty("name"), '\"');
                    if (allowLogOk) {
                        Logger.println("JMX-POOL", "found name=" + jndi);
                    }
                    poolObjectNames.put(o, jndi);
                }
                last_init = System.currentTimeMillis();
                if (allowLogOk) {
                    Logger.println("JMX-POOL", "found #" + poolObjectNames.size());
                }
            }
            catch (Exception e) {
                Logger.println("JMX-POOL", "found err " + e);
                return;
            }
        }
        if (poolObjectNames.size() == 0) {
            return;
        }
        Enumeration<ObjectName> en = poolObjectNames.keys();
        while (en.hasMoreElements()) {
            ObjectName oi = en.nextElement();
            String url = null;
            int numActive = 0;
            int numIdle = 0;
            try {
                String jndi;
                block21: {
                    jndi = poolObjectNames.get(oi);
                    try {
                        url = jndi;
                        if (!"none".equals(ConfPool.jmx_pool_attr_url)) {
                            url = CastUtil.cString(server.getAttribute(oi, ConfPool.jmx_pool_attr_url));
                        }
                    }
                    catch (Exception e) {
                        if (!allowLogOk) break block21;
                        Logger.println("JMX-POOL", "get url err " + e);
                    }
                }
                int hash = HashUtil.hash(url);
                DataTextAgent.dbc(hash, url);
                numActive = CastUtil.cint(server.getAttribute(oi, ConfPool.jmx_pool_attr_active));
                numIdle = CastUtil.cint(server.getAttribute(oi, ConfPool.jmx_pool_attr_idle));
                if (ConfPool.pool_detail_enabled) {
                    if (ConfPool.jmx_pool_dsname_enabled) {
                        detail.intern(jndi).add(numActive, numIdle);
                    } else {
                        detail.intern(url).add(numActive, numIdle);
                    }
                }
                db_num_active.add(hash, numActive);
                db_num_idle.add(hash, numIdle);
            }
            catch (Exception e) {
                if (allowLogOk) {
                    Logger.println("JMX-POOL", url + " active/idle err " + e);
                }
                poolObjectNames.remove(oi);
            }
        }
        if (ConfPool.pool_detail_enabled) {
            DBPoolClassUtil.poolDetail("JmxPool", detail);
        }
    }
}

