/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.pools;

import java.lang.ref.WeakReference;
import java.util.Enumeration;
import whatap.agent.Logger;
import whatap.agent.conf.ConfPool;
import whatap.agent.control.ds.DBPoolClassUtil;
import whatap.agent.counter.task.pools.CNT;
import whatap.agent.counter.task.pools.IConnPoolObject;
import whatap.agent.counter.task.pools.PoolObjectReflect;
import whatap.agent.data.DataTextAgent;
import whatap.agent.trace.ConPool;
import whatap.util.HashUtil;
import whatap.util.IntIntMap;
import whatap.util.StringKeyLinkedMap;

public class RedisJedisPool
implements IConnPoolObject {
    public static String className = "RedisJedisPool";
    static int classNameHash = HashUtil.hash(className);

    public String id() {
        return className;
    }

    public boolean process(IntIntMap db_num_active, IntIntMap db_num_idle) {
        if (!ConfPool.jedis_pool_enabled) {
            return false;
        }
        StringKeyLinkedMap<CNT> detail = new StringKeyLinkedMap<CNT>(){

            @Override
            protected CNT create(String key) {
                return new CNT();
            }
        };
        try {
            Enumeration<WeakReference<Object>> poolEnum = ConPool.getObjectEnum(className);
            while (poolEnum.hasMoreElements()) {
                Object pool = poolEnum.nextElement().get();
                if (pool == null) continue;
                DataTextAgent.dbc(classNameHash, className);
                int act = PoolObjectReflect.getInt(pool, "getNumActive");
                int idle = PoolObjectReflect.getInt(pool, "getNumIdle");
                db_num_active.add(classNameHash, act);
                db_num_idle.add(classNameHash, idle);
                if (!ConfPool.pool_detail_enabled || act + idle <= 0) continue;
                ((CNT)detail.intern(className)).add(act, idle);
                if (!ConfPool.debug_pool_detail_enabled) continue;
                Logger.println("DBPOOL", className + ": pool=" + className + " act=" + act + " idle=" + idle);
            }
            if (ConfPool.pool_detail_enabled) {
                DBPoolClassUtil.poolDetail(className, detail);
            }
            return true;
        }
        catch (Throwable e) {
            Logger.println("RedisJedisPool", 3600000, e + ",hotfix: jedis_pool_enabled=false");
            return false;
        }
    }
}

