/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.pools;

import java.lang.ref.WeakReference;
import java.util.Enumeration;
import whatap.agent.Logger;
import whatap.agent.conf.ConfPool;
import whatap.agent.control.ds.DBPoolClassUtil;
import whatap.agent.counter.task.pools.CNT;
import whatap.agent.counter.task.pools.IConnPoolObject;
import whatap.agent.counter.task.pools.PoolObjectReflect;
import whatap.agent.data.DataTextAgent;
import whatap.agent.trace.ConPool;
import whatap.util.HashUtil;
import whatap.util.IntIntMap;
import whatap.util.StringKeyLinkedMap;

public class HikariConnPool
implements IConnPoolObject {
    public static String className = "HikariPool";
    static int classNameHash = HashUtil.hash(className);

    public String id() {
        return className;
    }

    public boolean process(IntIntMap db_num_active, IntIntMap db_num_idle) {
        ConfPool.hikari_pool_enabled = false;
        if (false) {
            return false;
        }
        try {
            StringKeyLinkedMap<CNT> detail = new StringKeyLinkedMap<CNT>(){

                @Override
                protected CNT create(String key) {
                    return new CNT();
                }
            };
            Enumeration<WeakReference<Object>> poolEnum = ConPool.getObjectEnum(className);
            while (poolEnum.hasMoreElements()) {
                Object pool = poolEnum.nextElement().get();
                if (pool == null) continue;
                String poolName = pool.toString();
                int poolHash = HashUtil.hash(poolName);
                DataTextAgent.dbc(poolHash, poolName);
                int act = PoolObjectReflect.getInt(pool, "getActiveConnections");
                int idle = PoolObjectReflect.getInt(pool, "getIdleConnections");
                db_num_active.add(poolHash, act);
                db_num_idle.add(poolHash, idle);
                if (!ConfPool.pool_detail_enabled) continue;
                ((CNT)detail.intern(poolName)).add(act, idle);
                if (!ConfPool.debug_pool_detail_enabled) continue;
                Logger.println("DBPOOL", className + ": pool=" + poolName + " act=" + act + " idle=" + idle);
            }
            if (ConfPool.pool_detail_enabled) {
                DBPoolClassUtil.poolDetail(className, detail);
            }
            return true;
        }
        catch (Exception e) {
            Logger.println("HikariPool", 3600000, e + ",hotfix: hikari_pool_enabled=false");
            return false;
        }
    }
}

