/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task.custom;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.counter.CountCollector;
import whatap.agent.counter.ICounterTask;
import whatap.util.CompareUtil;
import whatap.util.FileUtil;
import whatap.util.StringUtil;

public class CustomTaskLoader {
    protected static String this_jarfile;
    protected static boolean check_loaded;

    public static void load(ClassLoader parent) {
        Configure conf = Configure.getInstance();
        if (check_loaded && CompareUtil.equals(this_jarfile, conf.custom_task_jarfile)) {
            return;
        }
        check_loaded = true;
        this_jarfile = conf.custom_task_jarfile;
        if (StringUtil.isEmpty(this_jarfile)) {
            CountCollector.customTask = null;
            return;
        }
        try {
            File file = new File(this_jarfile);
            if (!file.exists()) {
                CountCollector.customTask = null;
                Logger.println("CustomTask load fail: " + file + " is not exist");
                return;
            }
            String main = CustomTaskLoader.getMain(file);
            if (StringUtil.isEmpty(main)) {
                CountCollector.customTask = null;
                Logger.println("CustomTask load fail: no mainClass is defined");
                return;
            }
            URL[] urls = new URL[]{file.toURI().toURL()};
            URLClassLoader loader = new URLClassLoader(urls, parent);
            CountCollector.customTask = (ICounterTask)Class.forName(main, true, loader).newInstance();
            Logger.println("CustomTask load success: " + this_jarfile + " " + main);
        }
        catch (Throwable t) {
            CountCollector.customTask = null;
            Logger.println("CustomTask load fail: " + t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getMain(File jar) {
        String string;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jar);
            Attributes attr = jarFile.getManifest().getMainAttributes();
            string = attr.getValue("Main-Class");
        }
        catch (Throwable throwable) {
            FileUtil.close(jarFile);
            return null;
        }
        catch (Throwable throwable) {
            FileUtil.close(jarFile);
            throw throwable;
        }
        FileUtil.close(jarFile);
        return string;
    }
}

