/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.task;

import whatap.agent.Configure;
import whatap.agent.counter.ICounterTask;
import whatap.agent.counter.meter.MeterActiveX;
import whatap.agent.counter.meter.MeterHTTPC;
import whatap.agent.trace.TraceHttpc;
import whatap.lang.pack.CounterPack1;
import whatap.util.IntEnumer;
import whatap.util.IntKeyLinkedMap;

public class ServiceHttpCall
implements ICounterTask {
    private long stime = System.currentTimeMillis();

    public ServiceHttpCall() {
        MeterHTTPC.getInstance().getBucketReset();
    }

    public void process(CounterPack1 p) {
        MeterHTTPC.Bucket httpc = MeterHTTPC.getInstance().getBucketReset();
        p.httpc_time_sum = httpc.time;
        p.httpc_count = httpc.count;
        p.httpc_error = httpc.error;
        long now = System.currentTimeMillis();
        long dtime = now - this.stime;
        if (dtime == 0L) {
            return;
        }
        this.stime = now;
        if (Configure.getInstance().httpc_host_meter_enabled) {
            this.httpc_meter(p);
        }
        if (Configure.getInstance().actx_meter_enabled) {
            this.httpc_actx_meter(p);
        }
    }

    public void httpc_meter(CounterPack1 p) {
        MeterHTTPC meter = MeterHTTPC.getInstance();
        if (meter.stat.size() > 0) {
            p.httpc_meter = new IntKeyLinkedMap();
            IntEnumer en = meter.stat.keys();
            for (int i = 0; i < 100 && en.hasMoreElements(); ++i) {
                int key = en.nextInt();
                MeterHTTPC.Bucket b = meter.stat.get(key);
                CounterPack1.HttpcMeter m = new CounterPack1.HttpcMeter();
                m.time = b.time;
                m.count = b.count;
                m.error = b.error;
                p.httpc_meter.put(key, m);
            }
            meter.resetStat();
        }
        TraceHttpc.resetMtraceRate();
    }

    private void httpc_actx_meter(CounterPack1 p) {
        MeterActiveX meter = MeterActiveX.getInstance();
        IntKeyLinkedMap<short[]> m = meter.act_httpc_slice;
        if (m != null && m.size() > 0) {
            if (p.httpc_meter == null) {
                p.httpc_meter = new IntKeyLinkedMap();
            }
            IntEnumer en = m.keys();
            for (int i = 0; i < 300 && en.hasMoreElements(); ++i) {
                int key = en.nextInt();
                CounterPack1.HttpcMeter httpcMeter = p.httpc_meter.get(key);
                if (httpcMeter == null) {
                    httpcMeter = new CounterPack1.HttpcMeter();
                    p.httpc_meter.put(key, httpcMeter);
                }
                httpcMeter.acts = m.get(key);
            }
        }
    }
}

