/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.meter;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Date;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.SecurityMaster;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.util.ThreadNameUtil;
import whatap.lang.value.MapValue;
import whatap.util.DateUtil;
import whatap.util.FileUtil;
import whatap.util.FormatUtil;
import whatap.util.Hexa32;
import whatap.util.SystemUtil;
import whatap.util.ThreadUtil;

public class ThreadDump
extends Thread {
    private static ThreadDump instance = null;

    public static final synchronized ThreadDump getInstance() {
        if (instance == null) {
            instance = new ThreadDump();
            instance.setDaemon(true);
            ThreadNameUtil.whatap(instance);
            instance.start();
        }
        return instance;
    }

    public static File getDumpFile(File root, String prefix) {
        String date = FormatUtil.print(new Date(), "yyyyMMdd-HHmmss");
        String name = prefix + "-" + date + ".wdmp";
        return new File(root, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void triggerThreadDump() {
        SecurityMaster secu = SecurityMaster.getInstance();
        PrintWriter out = null;
        try {
            File root = new File(System.getProperty("whatap.home", "."), "dump");
            if (!root.exists()) {
                root.mkdirs();
            }
            File file = ThreadDump.getDumpFile(root, "whatap-" + secu.PCODE + "-" + secu.ONAME);
            out = new PrintWriter(new FileWriter(file));
            out.print("pcode=" + SecurityMaster.getInstance().PCODE);
            out.print(" oid=" + SecurityMaster.getInstance().OID);
            out.println(" oname=" + SecurityMaster.getInstance().ONAME);
            out.println(DateUtil.timestamp(System.currentTimeMillis()));
            ThreadMXBean tmb = ManagementFactory.getThreadMXBean();
            long[] thread = tmb.getAllThreadIds();
            for (int i = 0; i < thread.length; ++i) {
                try {
                    ThreadInfo fo = tmb.getThreadInfo(thread[i], 500);
                    if (fo == null) continue;
                    long _id = fo.getThreadId();
                    String _name = fo.getThreadName();
                    String _stat = fo.getThreadState().toString();
                    long _cpu = tmb.getThreadCpuTime(thread[i]) / 1000000L;
                    out.print(i + " :::thread::: ");
                    out.print(_id + " ");
                    out.print(_name + " ");
                    out.print(_stat + " ");
                    if (!SystemUtil.IS_JAVA_IBM) {
                        ThreadDump.printThreadInfo(out, fo);
                    }
                    out.print(_cpu + "cpu");
                    TraceContext ctx = TraceContextManager.getContext(_id);
                    if (ctx != null) {
                        out.print(" :::tx::: " + Hexa32.toString32(ctx.txid) + " ");
                        out.print(ctx.service_name + " ");
                        out.print(ctx.getElapsedTime() + "ms ");
                        out.print(_cpu - ctx.start_cpu + "cpu");
                        if (ctx.sql_count > 0) {
                            out.print(": sql #" + ctx.sql_count + " " + ctx.sql_time + "ms");
                        }
                        if (ctx.httpc_count > 0) {
                            out.print(": httpc #" + ctx.sql_count + " " + ctx.sql_time + "ms");
                        }
                    }
                    out.println("");
                    out.println("");
                    ThreadDump.printStack(out, fo);
                    out.println("");
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable e) {
            try {
                Logger.println("A212", 10, e.toString());
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                FileUtil.close(out);
            }
        }
        FileUtil.close(out);
    }

    private static void printThreadInfo(PrintWriter out, ThreadInfo fo) {
        if (fo.getLockOwnerId() >= 0L) {
            out.print(",locked #" + fo.getLockName() + " owner " + fo.getLockOwnerName());
        }
        out.print(",blked #" + fo.getBlockedCount());
        long t = fo.getBlockedTime();
        if (t >= 0L) {
            out.print(" time " + t);
        }
        out.print(",waited #" + fo.getWaitedCount());
        t = fo.getWaitedTime();
        if (t >= 0L) {
            out.print(" time " + t);
        }
        out.print(": ");
    }

    private static void printStack(PrintWriter out, ThreadInfo f) {
        StackTraceElement[] se = f.getStackTrace();
        if (se != null) {
            for (int i = 0; i < se.length; ++i) {
                if (se[i] == null) continue;
                out.println("\t" + se[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        long last_active = 0L;
        while (true) {
            long now;
            ThreadDump threadDump = this;
            synchronized (threadDump) {
                ThreadUtil.wait(this);
            }
            if (Configure.getInstance().thread_dump_enabled && (now = System.currentTimeMillis()) - last_active > Math.max(Configure.getInstance().thread_dump_interval, 10000L)) {
                last_active = now;
                ThreadDump.triggerThreadDump();
            }
            ThreadUtil.sleep(30000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trigger() {
        ThreadDump lock;
        ThreadDump threadDump = lock = ThreadDump.getInstance();
        synchronized (threadDump) {
            lock.notifyAll();
        }
    }

    public static MapValue getDumpFiles() {
        MapValue out = new MapValue();
        String whatap_prefix = "whatap-";
        File dir = new File(System.getProperty("whatap.home", "."), "dump");
        File[] files = dir.listFiles();
        int len = files == null ? 0 : files.length;
        for (int i = 0; i < len; ++i) {
            String name;
            if (files[i].isDirectory() || !(name = files[i].getName()).startsWith(whatap_prefix) || !name.endsWith(".wdmp")) continue;
            try {
                out.put(files[i].getName(), files[i].length());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (out.size() >= 100) break;
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    public static String read(String file) {
        String string;
        if (file == null) {
            return null;
        }
        String whatap_prefix = "whatap-";
        if (!file.startsWith(whatap_prefix)) {
            return null;
        }
        File dir = new File(System.getProperty("whatap.home", "."), "dump");
        File dump = new File(dir, file);
        if (!dump.canRead()) {
            return null;
        }
        long available = dump.length();
        long readable = Math.min(available, 0x400000L);
        byte[] buff = new byte[(int)readable];
        RandomAccessFile r = null;
        try {
            r = new RandomAccessFile(dump, "r");
            r.read(buff);
            string = new String(buff);
        }
        catch (Throwable throwable) {
            FileUtil.close(r);
            catch (Throwable throwable2) {
                FileUtil.close(r);
                throw throwable2;
            }
        }
        FileUtil.close(r);
        return string;
        return null;
    }
}

