/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.meter;

import java.util.Enumeration;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.ConfUser;
import whatap.util.KeyGen;
import whatap.util.LongLongLinkedMap;
import whatap.util.SysJMX;
import whatap.util.cardinality.HyperLogLog;

public class MeterUsers {
    public static LongLongLinkedMap users = new LongLongLinkedMap(1001, 1.0f).setMax(70000);
    static Configure conf = Configure.getInstance();

    public static void add(long userid) {
        if (userid != 0L && ConfUser.wclient_enabled) {
            users.putLast(userid, System.currentTimeMillis());
        }
    }

    public static void addActive(long userid) {
        if (userid != 0L && ConfUser.wclient_enabled) {
            users.put(userid, System.currentTimeMillis());
        }
    }

    public static synchronized HyperLogLog getRealtimeUsers() {
        long max_think_time = ConfUser.wclient_thinktime_max;
        long now = System.currentTimeMillis();
        HyperLogLog loglog = new HyperLogLog();
        if (users.size() == 0) {
            return loglog;
        }
        try {
            Enumeration<LongLongLinkedMap.LongLongLinkedEntry> en = users.entries();
            while (en.hasMoreElements()) {
                LongLongLinkedMap.LongLongLinkedEntry e = en.nextElement();
                if (now - e.getValue() > max_think_time) {
                    users.remove(e.getKey());
                    continue;
                }
                loglog.offer(e.getKey());
            }
        }
        catch (Throwable t) {
            Logger.println("A211", 10, "METER-USERS " + t);
        }
        return loglog;
    }

    public static void main(String[] args) throws InterruptedException {
        for (int i = 1; i <= 100000; ++i) {
            MeterUsers.add(KeyGen.next());
        }
        long cpu1 = SysJMX.getCurrentThreadCPUnano();
        for (int i = 1; i <= 100; ++i) {
            MeterUsers.add(KeyGen.next());
        }
        long cpu2 = SysJMX.getCurrentThreadCPUnano();
        HyperLogLog log = MeterUsers.getRealtimeUsers();
        long cpu3 = SysJMX.getCurrentThreadCPUnano();
        Thread.sleep(1000L);
        System.out.println((cpu2 - cpu1) / 1000000L);
        System.out.println((cpu3 - cpu2) / 1000000L);
        System.out.println("user : " + log.cardinality());
    }
}

