/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.meter;

import whatap.agent.Configure;
import whatap.lang.PKIND;
import whatap.lang.POID;
import whatap.util.IntKeyLinkedMap;
import whatap.util.LinkedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeterActiveX {
    private static MeterActiveX inst = new MeterActiveX();
    public IntKeyLinkedMap<short[]> statByOid;
    public LinkedMap<PKIND, short[]> statByGroup;
    public LinkedMap<POID, short[]> statByPoid;
    public short[] unknown;
    Configure conf = Configure.getInstance();
    public IntKeyLinkedMap<short[]> act_sql_slice;
    public IntKeyLinkedMap<short[]> act_httpc_slice;

    public static MeterActiveX getInstance() {
        return inst;
    }

    public void addTx(long caller_pcode, int caller_okind, int caller_oid, int idx) {
        if (caller_oid != 0) {
            if (caller_pcode == Configure.PCODE) {
                short[] sArray = this.statByOid.intern(caller_oid);
                int n = idx;
                sArray[n] = (short)(sArray[n] + 1);
            } else {
                short[] sArray = this.statByPoid.intern(new POID(caller_pcode, caller_oid));
                int n = idx;
                sArray[n] = (short)(sArray[n] + 1);
            }
            if (this.conf.actx_meter_pkind_enabled) {
                short[] sArray = this.statByGroup.intern(new PKIND(caller_pcode, caller_okind));
                int n = idx;
                sArray[n] = (short)(sArray[n] + 1);
            }
        } else {
            int n = idx;
            this.unknown[n] = (short)(this.unknown[n] + 1);
        }
    }

    public void reinit() {
        this.statByOid = this.reset(this.statByOid);
        this.statByPoid = new LinkedMap<POID, short[]>(){

            @Override
            protected short[] create(POID key) {
                return new short[3];
            }
        };
        this.statByGroup = new LinkedMap<PKIND, short[]>(){

            @Override
            protected short[] create(PKIND key) {
                return new short[3];
            }
        };
        this.act_sql_slice = this.reset(this.act_sql_slice);
        this.act_httpc_slice = this.reset(this.act_httpc_slice);
        this.unknown = new short[3];
    }

    private IntKeyLinkedMap<short[]> reset(IntKeyLinkedMap<short[]> m) {
        if (m == null) {
            m = new IntKeyLinkedMap<short[]>(){

                @Override
                protected short[] create(int key) {
                    return new short[3];
                }
            };
        } else {
            m.clear();
        }
        return m;
    }

    public void addSql(int dbc, int elapsed) {
        short[] sArray = this.act_sql_slice.intern(dbc);
        int n = this.idx(elapsed);
        sArray[n] = (short)(sArray[n] + 1);
    }

    public void addHttpc(int host, int elapsed) {
        short[] sArray = this.act_httpc_slice.intern(host);
        int n = this.idx(elapsed);
        sArray[n] = (short)(sArray[n] + 1);
    }

    private int idx(int elapsed) {
        switch (elapsed / 1000) {
            case 0: 
            case 1: 
            case 2: {
                return 0;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 1;
            }
        }
        return 2;
    }
}

