/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.counter.meter;

import java.util.ArrayList;
import java.util.Enumeration;
import whatap.agent.Configure;
import whatap.agent.conf.ConfActiveStack;
import whatap.agent.data.DataPackSender;
import whatap.agent.data.DataTextAgent;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.util.ThreadNameUtil;
import whatap.lang.pack.AbstractPack;
import whatap.lang.pack.ActiveStackPack1;
import whatap.lang.step.ActiveStackStep;
import whatap.lang.step.SqlStepX;
import whatap.util.DateUtil;
import whatap.util.KeyGen;
import whatap.util.SysJMX;
import whatap.util.ThreadUtil;

public class ActiveStackDump
extends Thread {
    private static ActiveStackDump instance = null;
    Configure conf = Configure.getInstance();

    public static final synchronized ActiveStackDump getInstance() {
        if (instance == null) {
            instance = new ActiveStackDump();
            instance.setDaemon(true);
            instance.start();
            ThreadNameUtil.whatap(instance);
        }
        return instance;
    }

    public void run() {
        while (true) {
            int interval = Math.max(2, ConfActiveStack.active_stack_second);
            ThreadUtil.sleep(interval * 1000);
            try {
                if (!ConfActiveStack.active_stack_enabled) continue;
                if (!ConfActiveStack.active_stack_perfx_enabled) {
                    this.process();
                    continue;
                }
                this.process_perf_enabled();
            }
            catch (Throwable throwable) {
            }
        }
    }

    public void process() {
        ArrayList<AbstractPack> packs = null;
        if (ConfActiveStack.active_stack_zip_enabled) {
            packs = new ArrayList<AbstractPack>(40);
        }
        Enumeration<TraceContext> en = TraceContextManager.getContextEnumeration();
        int sent = 0;
        while (sent < ConfActiveStack.active_stack_count && en.hasMoreElements()) {
            TraceContext ctx = en.nextElement();
            if (ctx == null) continue;
            int elapsed = ctx.getElapsedTime();
            ++sent;
            ActiveStackPack1 actStack = new ActiveStackPack1();
            actStack.activeStackId = KeyGen.next();
            actStack.txid = ctx.txid;
            actStack.service = ctx.service_hash;
            ++ctx.profileActive;
            ActiveStackStep step = new ActiveStackStep(actStack.activeStackId);
            step.hasCallstack = true;
            StackTraceElement[] se = ctx.thread.getStackTrace();
            actStack.time = DateUtil.currentTime();
            actStack.elapsed = step.start_time = elapsed;
            ctx.profile.addTail(step);
            int max = Math.min(se.length, ConfActiveStack.active_callstack_depth);
            actStack.callstack = new int[max];
            for (int i = 0; i < max; ++i) {
                actStack.callstack[i] = se[i].hashCode();
                actStack.callstack_hash ^= actStack.callstack[i];
                DataTextAgent.STACK.add(actStack.callstack[i], se[i]);
            }
            actStack.perfx_included = false;
            if (ConfActiveStack.active_stack_thread_name_enabled) {
                actStack.thread_name = ctx.thread.getName();
            }
            if (packs != null) {
                packs.add(DataPackSender.setInfo(actStack));
                if (packs.size() < 30) continue;
                DataPackSender.sendActiveStackZip(packs);
                packs = new ArrayList(40);
                continue;
            }
            DataPackSender.send(actStack, sent % 100 == 0);
        }
        if (packs != null) {
            switch (packs.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    DataPackSender.send((ActiveStackPack1)packs.get(0), false);
                    break;
                }
                default: {
                    DataPackSender.sendActiveStackZip(packs);
                }
            }
        }
    }

    private void process_perf_enabled() {
        ArrayList<AbstractPack> packs = null;
        if (ConfActiveStack.active_stack_zip_enabled) {
            packs = new ArrayList<AbstractPack>(40);
        }
        Enumeration<TraceContext> en = TraceContextManager.getContextEnumeration();
        int sent = 0;
        while (sent < ConfActiveStack.active_stack_count && en.hasMoreElements()) {
            TraceContext ctx = en.nextElement();
            if (ctx == null) continue;
            int elapsed = ctx.getElapsedTime();
            ++sent;
            ActiveStackPack1 actStack = new ActiveStackPack1();
            actStack.activeStackId = KeyGen.next();
            actStack.txid = ctx.txid;
            actStack.service = ctx.service_hash;
            ++ctx.profileActive;
            ActiveStackStep step = new ActiveStackStep(actStack.activeStackId);
            step.hasCallstack = true;
            StackTraceElement[] se = ctx.thread.getStackTrace();
            actStack.time = DateUtil.currentTime();
            actStack.elapsed = step.start_time = elapsed;
            ctx.profile.addTail(step);
            int max = Math.min(se.length, ConfActiveStack.active_callstack_depth);
            actStack.callstack = new int[max];
            for (int i = 0; i < max; ++i) {
                actStack.callstack[i] = se[i].hashCode();
                actStack.callstack_hash ^= actStack.callstack[i];
                DataTextAgent.STACK.add(actStack.callstack[i], se[i]);
            }
            actStack.perfx_included = true;
            if (ctx.start_cpu > 0L) {
                actStack.cputime = (int)(SysJMX.getThreadCpuTime(ctx.thread.getId()) - ctx.start_cpu);
            }
            if (ctx.start_malloc > 0L) {
                actStack.malloc = SysJMX.getThreadAllocBytes(ctx.thread.getId()) - ctx.start_malloc;
            }
            actStack.sql_count = ctx.sql_count;
            actStack.sql_time = ctx.sql_time;
            SqlStepX sql = ctx.sql;
            if (sql != null) {
                actStack.active_sql_dbc = sql.dbc;
                actStack.active_sql_hash = sql.hash;
            }
            actStack.rs_count = ctx.rs_count;
            actStack.rs_time = (int)ctx.rs_time;
            actStack.httpc_count = ctx.httpc_count;
            actStack.httpc_time = ctx.httpc_time;
            actStack.active_httpc_hash = ctx.active_httpc_hash;
            if (ConfActiveStack.active_stack_thread_name_enabled) {
                actStack.thread_name = ctx.thread.getName();
            }
            if (packs != null) {
                packs.add(DataPackSender.setInfo(actStack));
                if (packs.size() < 30) continue;
                DataPackSender.sendActiveStackZip(packs);
                packs = new ArrayList(40);
                continue;
            }
            DataPackSender.send(actStack, sent % 100 == 0);
        }
        if (packs != null) {
            switch (packs.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    DataPackSender.send((ActiveStackPack1)packs.get(0), false);
                    break;
                }
                default: {
                    DataPackSender.sendActiveStackZip(packs);
                }
            }
        }
    }
}

