/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.control.dyna;

import java.lang.instrument.ClassDefinition;
import java.util.ArrayList;
import java.util.HashSet;
import whatap.agent.JavaAgent;
import whatap.agent.Logger;
import whatap.lang.value.ListValue;
import whatap.lang.value.MapValue;
import whatap.util.ClassUtil;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringLinkedSet;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynaBCIService {
    public static StringLinkedSet hookedSet = new StringLinkedSet().setMax(10000);
    public static StringLinkedSet options = new StringLinkedSet();

    public static boolean isTargetClass(String cname) {
        return hookedSet.contains(cname);
    }

    public static boolean isTargetMethod(String name, String desc) {
        return options.contains(name) || options.contains(name + desc);
    }

    public static boolean hasTarget() {
        return hookedSet.size() > 0;
    }

    public static void update(StringKeyLinkedMap<Boolean> classMap) {
        if (hookedSet.size() == 0) {
            return;
        }
        StringEnumer en = classMap.keys();
        while (en.hasMoreElements()) {
            String cname = en.nextString();
            if (!hookedSet.contains(cname.replace('.', '/'))) continue;
            classMap.put(cname, true);
        }
    }

    public static ListValue option() {
        ListValue out = new ListValue();
        StringEnumer en = options.elements();
        while (en.hasMoreElements()) {
            out.add(en.nextString());
        }
        return out;
    }

    public static String apply(MapValue classes, ListValue oplist) {
        DynaBCIService.upate(oplist);
        StringLinkedSet m2 = new StringLinkedSet();
        HashSet<String> redefSet = new HashSet<String>();
        StringEnumer en = classes.keys();
        while (en.hasMoreElements()) {
            String className = en.nextString();
            boolean doHooking = classes.getBoolean(className);
            if (doHooking) {
                m2.put(className.replace('.', '/'));
            }
            if (doHooking == hookedSet.contains(className)) continue;
            redefSet.add(className);
        }
        hookedSet = m2;
        return DynaBCIService.redefine(redefSet);
    }

    private static void upate(ListValue oplist) {
        StringLinkedSet newOption = new StringLinkedSet();
        for (int i = 0; i < oplist.size(); ++i) {
            newOption.put(StringUtil.trim(oplist.getString(i)));
        }
        options = newOption;
    }

    private static String redefine(HashSet<String> classes) {
        Class[] loadedClasses = JavaAgent.instrumentation.getAllLoadedClasses();
        ArrayList<ClassDefinition> classDefList = new ArrayList<ClassDefinition>();
        for (Class c : loadedClasses) {
            if (!classes.contains(c.getName())) continue;
            byte[] body = ClassUtil.getByteCode(c);
            if (body != null) {
                classDefList.add(new ClassDefinition(c, body));
                continue;
            }
            Logger.println("dynamic transaction redefine: " + c.getName() + " has no body");
        }
        if (classDefList.size() > 0) {
            ClassDefinition[] cd = classDefList.toArray(new ClassDefinition[classDefList.size()]);
            try {
                JavaAgent.instrumentation.redefineClasses(cd);
                return null;
            }
            catch (Throwable e) {
                Logger.println("dynamic transaction redefine:" + e);
                return "dynamic transaction redefine:" + e;
            }
        }
        return null;
    }
}

