/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.conf.util;

import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.conf.util.BaseConfig;
import whatap.agent.net.TcpReqClientProxy;
import whatap.io.DataInputX;
import whatap.io.DataOutputX;
import whatap.lang.value.MapValue;
import whatap.util.StopWatch;
import whatap.util.StringUtil;
import whatap.util.ThreadUtil;

public class ConfBaseClientThread
extends Thread {
    private static ConfBaseClientThread instance = null;
    private Configure conf = Configure.getInstance();
    private long conerr = 0L;

    public static final synchronized ConfBaseClientThread getInstance() {
        if (instance == null) {
            instance = new ConfBaseClientThread();
            instance.setDaemon(true);
            instance.setName("ConfBaseClient");
            instance.start();
        }
        return instance;
    }

    public void run() {
        while (true) {
            try {
                if (this.conf.confbase_enabled) {
                    this.process();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ThreadUtil.sleep(5000L);
        }
    }

    public void process() {
        MapValue r;
        MapValue p = new MapValue();
        p.put("cmd", "get");
        if (StringUtil.isNotEmpty(this.conf.confbase_id)) {
            p.put("id", this.conf.confbase_id);
        } else if (StringUtil.isNotEmpty(this.conf.OKIND_NAME)) {
            p.put("id", this.conf.OKIND_NAME);
        } else {
            p.put("id", "whatap");
        }
        p.put("filetime", BaseConfig.filetime);
        String oname = System.getProperty("whatap.oname");
        if (oname != null) {
            p.put("oname", oname);
        }
        if ((r = this.send(p)) == null) {
            return;
        }
        boolean exist = r.getBoolean("exist");
        if (!exist) {
            BaseConfig.filetime = 0L;
            BaseConfig.property = null;
            return;
        }
        long filetime = r.getLong("filetime");
        if (filetime > 0L) {
            BaseConfig.filetime = filetime;
            BaseConfig.property = (MapValue)r.get("config");
            Logger.info("CONFBASE", "ConfBase is changed: recv-config-size=" + (BaseConfig.property == null ? 0 : BaseConfig.property.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MapValue send(MapValue p) {
        if (this.conf.confbase_host == null) {
            return null;
        }
        StopWatch st = new StopWatch();
        TcpReqClientProxy client = new TcpReqClientProxy("ConfBase", this.conerr < 5L);
        try {
            boolean ok = client.open(this.conf.confbase_host, this.conf.confbase_port);
            if (!ok) {
                ++this.conerr;
                client.close();
                MapValue mapValue = null;
                return mapValue;
            }
            if (this.conerr > 0L) {
                Logger.println("TcpReqClient", -1, "ConfBase The connection " + this.conf.confbase_host + ":" + this.conf.confbase_port + " is success!");
            }
            this.conerr = 0L;
            client.send(DataOutputX.toBytes(p));
            byte[] out = client.read();
            if (out != null) {
                MapValue mapValue = (MapValue)new DataInputX(out).readValue();
                return mapValue;
            }
        }
        catch (Throwable t) {
            Logger.println("ConfBaseClient", 10, t + " " + st.getTime() + " ms", t);
        }
        finally {
            client.close();
        }
        return null;
    }
}

