/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm.weaving;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import whatap.agent.api.weaving.OriginMethod;
import whatap.agent.asm.IASM;
import whatap.agent.asm.WhaTapClassWriter;
import whatap.org.objectweb.asm.ClassWriter;
import whatap.org.objectweb.asm.Label;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Type;
import whatap.org.objectweb.asm.commons.JSRInlinerAdapter;
import whatap.org.objectweb.asm.commons.Method;
import whatap.org.objectweb.asm.tree.AbstractInsnNode;
import whatap.org.objectweb.asm.tree.AnnotationNode;
import whatap.org.objectweb.asm.tree.ClassNode;
import whatap.org.objectweb.asm.tree.FieldNode;
import whatap.org.objectweb.asm.tree.InsnList;
import whatap.org.objectweb.asm.tree.LabelNode;
import whatap.org.objectweb.asm.tree.MethodNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WeaveUtil {
    public static final Type ORIGIN_CLASS = Type.getType(OriginMethod.class);
    public static final Method CALL_METHOD = new Method("call", Type.getType(Object.class), new Type[0]);

    public static boolean isOriginMethodInvocation(String owner, String name, String desc) {
        return owner.equals(ORIGIN_CLASS.getInternalName()) && desc.equals(CALL_METHOD.getDescriptor());
    }

    public static MethodNode newMethodNode(MethodNode source) {
        return new MethodNode(IASM.API, source.access, source.name, source.desc, source.signature, source.exceptions.toArray(new String[source.exceptions.size()]));
    }

    public static FieldNode newFieldNode(FieldNode source) {
        return new FieldNode(IASM.API, source.access, source.name, source.desc, source.signature, source.value);
    }

    public static MethodNode copy(MethodNode source) {
        MethodNode result = WeaveUtil.newMethodNode(source);
        source.accept(result);
        return result;
    }

    public static LabelNode makeLabelNode() {
        LabelNode labelNode = new LabelNode();
        labelNode.getLabel().info = labelNode;
        return labelNode;
    }

    public static MethodNode getMethodNode(ClassNode classnode, String methodName, String methodDesc) {
        for (MethodNode method : classnode.methods) {
            if (!method.name.equals(methodName) || !method.desc.equals(methodDesc)) continue;
            return method;
        }
        return null;
    }

    public static MethodNode removeLineNumbers(MethodNode method) {
        MethodNode result = WeaveUtil.newMethodNode(method);
        method.accept(new MethodVisitor(IASM.API, result){

            public void visitLineNumber(int line, Label start) {
            }
        });
        return result;
    }

    public static MethodNode removeLabelNode(MethodNode method) {
        MethodNode result = WeaveUtil.newMethodNode(method);
        method.accept(new MethodVisitor(IASM.API, result){

            public void visitLabel(Label label) {
            }
        });
        return result;
    }

    public static MethodNode removeJSRInstructions(MethodNode method) {
        MethodNode result = WeaveUtil.newMethodNode(method);
        method.accept(new JSRInlinerAdapter(result, method.access, method.name, method.desc, method.signature, method.exceptions.toArray(new String[method.exceptions.size()])));
        return result;
    }

    public static String getClassResourceName(String internalName) {
        if (internalName.endsWith(".class")) {
            return internalName;
        }
        return internalName.replace('.', '/') + ".class";
    }

    public static byte[] toBytes(ClassNode n) {
        ClassWriter cw = WeaveUtil.getClassWriter(n.version);
        n.accept(cw);
        return cw.toByteArray();
    }

    public static ClassWriter getClassWriter(int version) {
        WhaTapClassWriter cw;
        switch (version) {
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 196653: {
                cw = new WhaTapClassWriter(1);
                break;
            }
            default: {
                cw = new WhaTapClassWriter(3);
            }
        }
        return cw;
    }

    public static MethodNode replace(MethodNode method, final String weaveClass, final String targetClass) {
        if (weaveClass.equals(targetClass)) {
            return method;
        }
        MethodNode out = WeaveUtil.newMethodNode(method);
        method.accept(new MethodVisitor(IASM.API, out){

            public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                if (owner.equals(weaveClass)) {
                    owner = targetClass;
                }
                super.visitFieldInsn(opcode, owner, name, descriptor);
            }

            public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                if (owner.equals(weaveClass)) {
                    owner = targetClass;
                }
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            }
        });
        return out;
    }

    public static void moveAnnotation(MethodNode src, MethodNode dest) {
        if (src.visibleAnnotations != null && src.visibleAnnotations.size() > 0) {
            dest.visibleAnnotations = new ArrayList<AnnotationNode>();
            for (AnnotationNode a : src.visibleAnnotations) {
                dest.visibleAnnotations.add(a);
            }
            src.visibleAnnotations = new ArrayList<AnnotationNode>(1);
        }
        if (src.invisibleAnnotations != null && src.invisibleAnnotations.size() > 0) {
            dest.invisibleAnnotations = new ArrayList<AnnotationNode>();
            for (AnnotationNode a : src.invisibleAnnotations) {
                dest.invisibleAnnotations.add(a);
            }
            src.invisibleAnnotations = new ArrayList<AnnotationNode>(1);
        }
    }

    public static void copyAnnotation(MethodNode src, MethodNode dest) {
        if (src.visibleAnnotations != null && src.visibleAnnotations.size() > 0) {
            dest.visibleAnnotations = new ArrayList<AnnotationNode>();
            for (AnnotationNode a : src.visibleAnnotations) {
                dest.visibleAnnotations.add(a);
            }
        }
        if (src.invisibleAnnotations != null && src.invisibleAnnotations.size() > 0) {
            dest.invisibleAnnotations = new ArrayList<AnnotationNode>();
            for (AnnotationNode a : src.invisibleAnnotations) {
                dest.invisibleAnnotations.add(a);
            }
        }
    }

    public static List<AnnotationNode> merge(List<AnnotationNode> src, List<AnnotationNode> dest) {
        if (src == null || src.isEmpty()) {
            return dest;
        }
        if (dest == null || dest.isEmpty()) {
            return new ArrayList<AnnotationNode>(src);
        }
        HashMap<String, AnnotationNode> annotationMap = new HashMap<String, AnnotationNode>();
        for (AnnotationNode compositeAnnotation : dest) {
            annotationMap.put(compositeAnnotation.desc, compositeAnnotation);
        }
        for (AnnotationNode weaveAnnotation : src) {
            annotationMap.put(weaveAnnotation.desc, weaveAnnotation);
        }
        return new ArrayList<AnnotationNode>(annotationMap.values());
    }

    public static boolean isEmptyConst(MethodNode method) {
        if (!method.name.equals("<init>") || !method.desc.equals("()V") || method.visibleAnnotations != null || method.invisibleAnnotations != null) {
            return false;
        }
        boolean STAT_START = false;
        boolean STAT_ALOAD = true;
        int STAT_METHOD = 2;
        int state = 0;
        InsnList instructions = method.instructions;
        int size = instructions.size();
        block5: for (int i = 0; i < size; ++i) {
            AbstractInsnNode node = instructions.get(i);
            switch (node.getOpcode()) {
                case 25: {
                    if (state != 0) {
                        return false;
                    }
                    state = 1;
                    continue block5;
                }
                case 183: {
                    if (state != 1) {
                        return false;
                    }
                    state = 2;
                    continue block5;
                }
                case 177: {
                    return state == 2;
                }
                default: {
                    if (node.getType() == 15 || node.getType() == 8 || node.getType() == 14) continue block5;
                    return false;
                }
            }
        }
        return false;
    }
}

