/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm.weaving;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import whatap.agent.Logger;
import whatap.agent.asm.weaving.ClassNodeX;
import whatap.agent.asm.weaving.StringKeyClassNodeListMap;
import whatap.org.objectweb.asm.ClassReader;
import whatap.util.AnsiPrint;
import whatap.util.ArrayUtil;
import whatap.util.BitUtil;
import whatap.util.CastUtil;
import whatap.util.FileUtil;
import whatap.util.StringEnumer;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringUtil;
import whatap.util.SystemUtil;

public class WeavePackage {
    public final String name;
    public StringKeyLinkedMap<byte[]> rawEntry = new StringKeyLinkedMap();
    public StringKeyLinkedMap<ClassNodeX> weavingEntry = new StringKeyLinkedMap();
    public Map<String, byte[]> addClassEntry = new HashMap<String, byte[]>();
    public String PlugIn;
    public int Build;
    public String MethodPrefix = "$$";
    private static AtomicInteger idx = new AtomicInteger(1);

    public WeavePackage(String name) {
        this.name = name;
    }

    public static WeavePackage load(File jar) {
        WeavePackage wb = new WeavePackage(jar.getName());
        wb.loadJarFile(jar);
        return wb;
    }

    public static WeavePackage load(String name, byte[] b) {
        WeavePackage wb = new WeavePackage(name);
        wb.loadBytes(b);
        return wb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadJarFile(File jar) {
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(jar);
            Manifest mf = jarFile.getManifest();
            if (mf != null) {
                Attributes attr = mf.getMainAttributes();
                this.PlugIn = StringUtil.trimEmpty(attr.getValue("PlugIn"));
                this.Build = CastUtil.cint(attr.getValue("Build"));
                this.MethodPrefix = StringUtil.trimEmpty(attr.getValue("MethodPrefix"));
            }
            if (this.MethodPrefix == null || this.MethodPrefix.length() == 0) {
                this.MethodPrefix = "$$" + idx.getAndIncrement();
            }
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                InputStream is;
                byte[] bytes;
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class") || ArrayUtil.isEmpty(bytes = FileUtil.readAll(is = jarFile.getInputStream(entry)))) continue;
                this.rawEntry.put(StringUtil.cutOut(name, "."), bytes);
            }
        }
        catch (Throwable t) {
            try {
                Logger.println("Load Error: " + jar.getAbsolutePath(), t);
            }
            catch (Throwable throwable) {
                FileUtil.close(jarFile);
                throw throwable;
            }
            FileUtil.close(jarFile);
        }
        FileUtil.close(jarFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBytes(byte[] bytes) {
        JarInputStream jar = null;
        try {
            jar = new JarInputStream(new ByteArrayInputStream(bytes));
            Manifest mf = jar.getManifest();
            if (mf != null) {
                Attributes attr = mf.getMainAttributes();
                this.PlugIn = StringUtil.trimEmpty(attr.getValue("PlugIn"));
                this.Build = CastUtil.cint(attr.getValue("Build"));
                this.MethodPrefix = StringUtil.trimEmpty(attr.getValue("MethodPrefix"));
            }
            if (this.MethodPrefix == null || this.MethodPrefix.length() == 0) {
                this.MethodPrefix = "$$" + idx.getAndIncrement();
            }
            JarEntry ent = jar.getNextJarEntry();
            while (ent != null) {
                byte[] buff = FileUtil.readAll(jar);
                if (buff != null && !ArrayUtil.isEmpty(buff) && ent.getName().endsWith(".class")) {
                    this.rawEntry.put(ent.getName(), buff);
                }
                ent = jar.getNextJarEntry();
            }
            FileUtil.close(jar);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            FileUtil.close(jar);
        }
    }

    public boolean parseBytes() {
        if (this.rawEntry == null || this.rawEntry.size() == 0) {
            return false;
        }
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<byte[]>> en = this.rawEntry.entries();
        while (en.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<byte[]> ent = en.nextElement();
            ClassNodeX node = new ClassNodeX();
            node.realBody = ent.getValue();
            new ClassReader(ent.getValue()).accept(node, 0);
            node.parent = this;
            node.buildWeave();
            short major = BitUtil.getLow(node.version);
            if (major > SystemUtil.majorVersion) {
                Logger.println("Weaving", "fail " + this.toString() + " because " + node.name + " compiled by jdk" + SystemUtil.getJavaVersion(major));
                return false;
            }
            if (node.match == null) {
                this.addClassEntry.put(node.realClassName, ent.getValue());
                continue;
            }
            if (node.match.equals("ignore")) continue;
            this.weavingEntry.put(node.realClassName, node);
        }
        return true;
    }

    public void regist(StringKeyClassNodeListMap classTable, StringKeyClassNodeListMap superTable, StringKeyClassNodeListMap interfaceTable) {
        StringEnumer en = this.weavingEntry.keys();
        while (en.hasMoreElements()) {
            String className = en.nextString();
            ClassNodeX classNode = this.weavingEntry.get(className);
            if (classNode.match.equals("class")) {
                ((List)classTable.intern(className)).add(classNode);
                continue;
            }
            if (classNode.match.equals("super")) {
                ((List)superTable.intern(className)).add(classNode);
                continue;
            }
            if (!classNode.match.equals("interface")) continue;
            ((List)interfaceTable.intern(className)).add(classNode);
        }
    }

    private void waring(String className, ClassNodeX loaded, ClassNodeX newLoad) {
        try {
            StringBuffer sb = new StringBuffer();
            sb.append(AnsiPrint.red("Warning!!"));
            sb.append(" fail to load ").append(className);
            sb.append(" from [").append(newLoad.parent.name).append("]");
            sb.append(" because the weaving-class has already loaded from [").append(loaded.parent.name).append("]");
            Logger.info("WEAVING", sb.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[").append(this.name);
        builder.append("]");
        builder.append(" prefix=" + this.MethodPrefix);
        return builder.toString();
    }
}

