/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm.weaving;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import whatap.agent.ClassDesc;
import whatap.agent.Configure;
import whatap.agent.JavaAgent;
import whatap.agent.Logger;
import whatap.agent.asm.IASM;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.asm.weaving.AddNewClass;
import whatap.agent.asm.weaving.ClassNodeX;
import whatap.agent.asm.weaving.MethodNodeWrap;
import whatap.agent.asm.weaving.OriginMethodCall;
import whatap.agent.asm.weaving.StringKeyClassNodeListMap;
import whatap.agent.asm.weaving.WConf;
import whatap.agent.asm.weaving.WeavePackage;
import whatap.agent.asm.weaving.WeaveUtil;
import whatap.agent.conf.ConfWeaving;
import whatap.lang.var.I2;
import whatap.org.objectweb.asm.ClassReader;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Type;
import whatap.org.objectweb.asm.commons.JSRInlinerAdapter;
import whatap.org.objectweb.asm.commons.Method;
import whatap.org.objectweb.asm.tree.AbstractInsnNode;
import whatap.org.objectweb.asm.tree.FieldNode;
import whatap.org.objectweb.asm.tree.MethodInsnNode;
import whatap.org.objectweb.asm.tree.MethodNode;
import whatap.util.AnsiPrint;
import whatap.util.FileUtil;
import whatap.util.LinkedMap;
import whatap.util.LinkedSet;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringLinkedSet;
import whatap.util.SystemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeaveMain {
    static boolean _hasWeave = false;
    static StringKeyClassNodeListMap classTable = new StringKeyClassNodeListMap();
    static StringKeyClassNodeListMap superTable = new StringKeyClassNodeListMap();
    static StringKeyClassNodeListMap interfaceTable = new StringKeyClassNodeListMap();
    static boolean weaving_dump_enabled = "true".equalsIgnoreCase(System.getProperty("weaving_dump"));
    private static LinkedSet<I2> added = new LinkedSet().setMax(10000);

    public static void load() {
        Object en;
        StringLinkedSet reserved;
        File root;
        StringKeyLinkedMap<WeavePackage> compTable = new StringKeyLinkedMap<WeavePackage>();
        if (ConfWeaving.weaving_plugin_enabled && (root = new File(System.getProperty("whatap.home", "."), "weaving")).exists()) {
            WeaveMain.listup(root, compTable);
        }
        if ((reserved = (ConfWeaving.weaving_reserved = WeaveMain.removeWeavingWebfluxSet(ConfWeaving.weaving_reserved))) != null && reserved.size() > 0) {
            en = reserved.elements();
            while (en.hasMoreElements()) {
                String jarname = en.nextString();
                byte[] buf = WeaveMain.embWeavingPlugin(jarname);
                int len = buf == null ? 0 : buf.length;
                if (len <= 0) continue;
                WeaveMain.push(compTable, WeaveMain.event(WeavePackage.load(jarname, buf)));
            }
        }
        en = compTable.values();
        while (en.hasMoreElements()) {
            WeavePackage w = (WeavePackage)en.nextElement();
            boolean ok = w.parseBytes();
            if (!ok) continue;
            w.regist(classTable, superTable, interfaceTable);
            w.rawEntry = null;
            Logger.println("Weaving", AnsiPrint.green("Load " + w));
        }
        _hasWeave = classTable.size() > 0 || superTable.size() > 0 || interfaceTable.size() > 0;
    }

    public static void listup(File root, StringKeyLinkedMap<WeavePackage> compTable) {
        File[] files;
        for (File jar : files = root.listFiles()) {
            if (!jar.isFile() || !jar.getName().endsWith(".jar")) continue;
            WeaveMain.push(compTable, WeaveMain.event(WeavePackage.load(jar)));
        }
    }

    private static WeavePackage event(WeavePackage p) {
        try {
            WConf.loaded(p.name);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return p;
    }

    private static void push(StringKeyLinkedMap<WeavePackage> table, WeavePackage newComp) {
        if (newComp == null) {
            return;
        }
        WeavePackage w = table.get(newComp.name);
        if (w == null) {
            table.put(newComp.name, newComp);
        }
    }

    private static byte[] embWeavingPlugin(String jarname) {
        try {
            byte[] newBytes = null;
            InputStream is = JavaAgent.class.getResourceAsStream("/weaving/" + jarname + ".jar");
            if (is != null) {
                newBytes = FileUtil.readAll(is);
                is.close();
            }
            return newBytes;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<ClassNodeX> getForThis(String name) {
        return (List)classTable.get(name);
    }

    public static List<ClassNodeX> getForSuper(String name) {
        return (List)superTable.get(name);
    }

    public static List<ClassNodeX> getForInterface(String name) {
        return (List)interfaceTable.get(name);
    }

    public static byte[] weaving(ClassLoader loader, ClassNodeX weavingClassNode, byte[] classfileBuffer) throws IOException {
        WeaveMain.loadNotWeaving(loader, weavingClassNode);
        return WeaveMain.doWeavingReal(weavingClassNode, classfileBuffer);
    }

    static byte[] doWeavingReal(ClassNodeX weavingClassNode, byte[] classfileBuffer) {
        String methodPrefix = weavingClassNode.parent.MethodPrefix;
        ClassNodeX originClassNode = new ClassNodeX();
        new ClassReader(classfileBuffer).accept(originClassNode, 8);
        originClassNode.buildNormal();
        if (weavingClassNode.version > originClassNode.version) {
            if (ConfWeaving.weaving_ignore_compile_version_enabled) {
                Logger.println("Weaving", AnsiPrint.green("Warning ") + weavingClassNode.name + "," + AnsiPrint.green("weaving-class-ver(" + SystemUtil.getJavaVersion(weavingClassNode.version) + ") is higher then target-class-ver(" + SystemUtil.getJavaVersion(originClassNode.version) + ")"));
            } else {
                Logger.println("Weaving", AnsiPrint.red("Error ") + weavingClassNode.name + "," + AnsiPrint.red("weaving-class-ver(" + SystemUtil.getJavaVersion(weavingClassNode.version) + ") is higher then target-class-ver(" + SystemUtil.getJavaVersion(originClassNode.version) + ")"));
                return classfileBuffer;
            }
        }
        Enumeration<LinkedMap.LinkedEntry<Method, MethodNodeWrap>> en = weavingClassNode.methodMap.entries();
        while (en.hasMoreElements()) {
            MethodNode destMethod;
            MethodNode orgMethod;
            LinkedMap.LinkedEntry<Method, MethodNodeWrap> ent = en.nextElement();
            if (AsmUtil.isAbstract(((MethodNodeWrap)ent.getValue()).method.access) || ((MethodNodeWrap)ent.getValue()).skip) continue;
            Method selectKey = (Method)ent.getKey();
            MethodNodeWrap weavingMethodWrap = (MethodNodeWrap)ent.getValue();
            MethodNode weavingMethodNode = WeaveUtil.replace(weavingMethodWrap.method, weavingClassNode.name, originClassNode.name);
            if (weavingMethodNode.name.equals("<clinit>")) {
                WeaveMain.weavingClassConstuctor(selectKey, originClassNode, weavingMethodNode, methodPrefix);
                continue;
            }
            if (weavingMethodNode.name.equals("<init>")) {
                if (WeaveUtil.isEmptyConst(weavingMethodNode)) continue;
                WeaveMain.weavingConstuctor(selectKey, originClassNode, weavingMethodNode, methodPrefix);
                continue;
            }
            if (!originClassNode.methodMap.containsKey(selectKey)) {
                if (!weavingMethodWrap.hasChecked) {
                    boolean bl = weavingMethodWrap.isOriginMethodCall = OriginMethodCall.findOriginMethodCall(weavingMethodNode.instructions) != null;
                }
                if (weavingMethodWrap.isOriginMethodCall) continue;
                originClassNode.methodMap.put(selectKey, new MethodNodeWrap(originClassNode.methods.size(), weavingMethodNode));
                originClassNode.methods.add(weavingMethodNode);
                continue;
            }
            MethodNodeWrap oldOrigin = originClassNode.methodMap.get(selectKey);
            if (AsmUtil.isStatic(oldOrigin.method.access) != AsmUtil.isStatic(weavingMethodNode.access)) {
                Logger.println("Weaving", "weaving fail, different static/nonstatic, " + originClassNode.name + " " + selectKey);
                return classfileBuffer;
            }
            OriginMethodCall replaceResult = new OriginMethodCall(originClassNode.name, weavingMethodNode).replace(methodPrefix);
            replaceResult.getMethodNode().access = oldOrigin.method.access;
            if (replaceResult.isMerged()) {
                oldOrigin.method.name = methodPrefix + oldOrigin.method.name;
                orgMethod = oldOrigin.method;
                destMethod = replaceResult.getMethodNode();
                destMethod.visibleAnnotations = WeaveUtil.merge(orgMethod.visibleAnnotations, destMethod.visibleAnnotations);
                destMethod.invisibleAnnotations = WeaveUtil.merge(orgMethod.invisibleAnnotations, destMethod.invisibleAnnotations);
                if (orgMethod.visibleAnnotations != null) {
                    orgMethod.visibleAnnotations.clear();
                }
                if (orgMethod.invisibleAnnotations != null) {
                    orgMethod.invisibleAnnotations.clear();
                }
                originClassNode.methodMap.put(new Method(orgMethod.name, orgMethod.desc), new MethodNodeWrap(oldOrigin.index, orgMethod));
                originClassNode.methodMap.put(selectKey, new MethodNodeWrap(originClassNode.methods.size(), destMethod));
                originClassNode.methods.add(destMethod);
                continue;
            }
            orgMethod = oldOrigin.method;
            destMethod = replaceResult.getMethodNode();
            destMethod.visibleAnnotations = WeaveUtil.merge(orgMethod.visibleAnnotations, destMethod.visibleAnnotations);
            destMethod.invisibleAnnotations = WeaveUtil.merge(orgMethod.invisibleAnnotations, destMethod.invisibleAnnotations);
            originClassNode.methodMap.put(selectKey, new MethodNodeWrap(oldOrigin.index, destMethod));
            originClassNode.methods.set(oldOrigin.index, destMethod);
        }
        for (FieldNode fieldNode : weavingClassNode.fields) {
            String fieldName = fieldNode.name;
            if (originClassNode.fieldMap.containsKey(fieldName)) continue;
            if (ConfWeaving.weaving_field_debug_enabled) {
                Logger.println("weaving field: " + originClassNode.name + ": " + fieldNode.desc + " " + fieldNode.name + "=" + fieldNode.value);
            }
            if (ConfWeaving.weaving_field_v2_enabled) {
                FieldNode newField = WeaveUtil.newFieldNode(fieldNode);
                originClassNode.fieldMap.put(fieldName, newField);
                originClassNode.fields.add(newField);
                continue;
            }
            originClassNode.fieldMap.put(fieldName, fieldNode);
            originClassNode.fields.add(fieldNode);
        }
        byte[] b = WeaveUtil.toBytes(originClassNode);
        if (weaving_dump_enabled) {
            String outfile = "./" + originClassNode.name.replace('/', '.') + ".class";
            FileUtil.save(outfile, b);
            System.out.println("weaving dump: " + outfile);
        }
        return b;
    }

    private static void weavingConstuctor(Method selectKey, ClassNodeX originClassNode, MethodNode weavingMethodNode, String methodPrefix) {
        MethodNodeWrap orgInit = originClassNode.methodMap.get(selectKey);
        if (orgInit == null) {
            originClassNode.methodMap.put(new Method(weavingMethodNode.name, weavingMethodNode.desc), new MethodNodeWrap(originClassNode.methods.size(), weavingMethodNode));
            originClassNode.methods.add(weavingMethodNode);
        } else {
            final MethodNode weaveInit = WeaveMain.resetConstToNormal(weavingMethodNode);
            weaveInit.name = methodPrefix + "init";
            final String className = originClassNode.name;
            MethodNode newInit = WeaveUtil.newMethodNode(orgInit.method);
            orgInit.method.accept(new MethodVisitor(IASM.API, newInit){

                public void visitInsn(int opcode) {
                    if (opcode >= 172 && opcode <= 177) {
                        this.mv.visitVarInsn(25, 0);
                        int sidx = 1;
                        Type[] paramTypes = Type.getArgumentTypes(weaveInit.desc);
                        for (int i = 0; i < paramTypes.length; ++i) {
                            Type type = paramTypes[i];
                            switch (type.getSort()) {
                                case 1: 
                                case 2: 
                                case 3: 
                                case 4: 
                                case 5: {
                                    this.mv.visitVarInsn(21, sidx);
                                    break;
                                }
                                case 7: {
                                    this.mv.visitVarInsn(22, sidx);
                                    break;
                                }
                                case 6: {
                                    this.mv.visitVarInsn(23, sidx);
                                    break;
                                }
                                case 8: {
                                    this.mv.visitVarInsn(24, sidx);
                                    break;
                                }
                                default: {
                                    this.mv.visitVarInsn(25, sidx);
                                }
                            }
                            sidx += type.getSize();
                        }
                        this.mv.visitMethodInsn(182, className, weaveInit.name, weaveInit.desc, false);
                    }
                    this.mv.visitInsn(opcode);
                }
            });
            originClassNode.methodMap.put(selectKey, new MethodNodeWrap(orgInit.index, newInit));
            originClassNode.methods.set(orgInit.index, newInit);
            originClassNode.methodMap.put(new Method(weaveInit.name, weaveInit.desc), new MethodNodeWrap(originClassNode.methods.size(), weaveInit));
            originClassNode.methods.add(weaveInit);
        }
    }

    private static void weavingClassConstuctor(Method selectKey, ClassNodeX originClassNode, MethodNode weavingMethodNode, String methodPrefix) {
        MethodNodeWrap orgInit = originClassNode.methodMap.get(selectKey);
        if (orgInit == null) {
            originClassNode.methodMap.put(new Method(weavingMethodNode.name, weavingMethodNode.desc), new MethodNodeWrap(originClassNode.methods.size(), weavingMethodNode));
            originClassNode.methods.add(weavingMethodNode);
        } else {
            final MethodNode weaveInit = WeaveUtil.copy(weavingMethodNode);
            weaveInit.name = methodPrefix + "clinit";
            final String className = originClassNode.name;
            MethodNode newInit = WeaveUtil.newMethodNode(orgInit.method);
            orgInit.method.accept(new MethodVisitor(IASM.API, newInit){

                public void visitInsn(int opcode) {
                    if (opcode >= 172 && opcode <= 177) {
                        this.mv.visitMethodInsn(184, className, weaveInit.name, weaveInit.desc, false);
                    }
                    this.mv.visitInsn(opcode);
                }
            });
            originClassNode.methodMap.put(selectKey, new MethodNodeWrap(orgInit.index, newInit));
            originClassNode.methods.set(orgInit.index, newInit);
            originClassNode.methodMap.put(new Method(weaveInit.name, weaveInit.desc), new MethodNodeWrap(originClassNode.methods.size(), weaveInit));
            originClassNode.methods.add(weaveInit);
        }
    }

    private static void loadNotWeaving(ClassLoader loader, ClassNodeX weaveClass) throws IOException {
        int h2;
        int h1;
        I2 k;
        Map<String, byte[]> addNewEntry = weaveClass.parent.addClassEntry;
        if (addNewEntry != null && addNewEntry.size() > 0 && !added.contains(k = new I2(h1 = System.identityHashCode(loader), h2 = System.identityHashCode(addNewEntry)))) {
            AddNewClass.addToClassLoader(loader, addNewEntry);
            added.put(k);
        }
    }

    public static MethodNode removeJSRInstructions(MethodNode m) {
        MethodNode result = WeaveUtil.newMethodNode(m);
        m.accept(new JSRInlinerAdapter(result, m.access, m.name, m.desc, m.signature, m.exceptions.toArray(new String[m.exceptions.size()])));
        return result;
    }

    public static boolean hasWeave() {
        return _hasWeave;
    }

    public static boolean hasInterface() {
        return interfaceTable.size() > 0;
    }

    public static byte[] weaving(ClassLoader loader, byte[] classfileBuffer, ClassDesc classDesc) throws IOException {
        String[] stringArray;
        int n;
        int n2;
        List<ClassNodeX> weaveClassNode = WeaveMain.getForThis(classDesc.name);
        if (weaveClassNode != null) {
            for (ClassNodeX classNodeX : weaveClassNode) {
                Logger.println("Weaving", "weaving class " + classDesc.name + " by " + classNodeX.parent.name);
                classfileBuffer = WeaveMain.weaving(loader, classNodeX, classfileBuffer);
            }
            return classfileBuffer;
        }
        weaveClassNode = WeaveMain.getForSuper(classDesc.superName);
        if (weaveClassNode != null) {
            for (ClassNodeX classNodeX : weaveClassNode) {
                if (classNodeX.hasPrefix && !classDesc.name.startsWith(classNodeX.prefix)) continue;
                Logger.println("Weaving", "weaving super " + classDesc.name + " by " + classNodeX.parent.name);
                classfileBuffer = WeaveMain.weaving(loader, classNodeX, classfileBuffer);
            }
            return classfileBuffer;
        }
        if (WeaveMain.hasInterface() && (n2 = 0) < (n = (stringArray = classDesc.interfaces).length)) {
            String inf = stringArray[n2];
            weaveClassNode = WeaveMain.getForInterface(inf);
            if (weaveClassNode != null) {
                for (ClassNodeX classNodeX : weaveClassNode) {
                    if (classNodeX.hasPrefix && !classDesc.name.startsWith(classNodeX.prefix)) continue;
                    Logger.println("Weaving", "weaving interface " + classDesc.name + " by " + classNodeX.parent.name);
                    classfileBuffer = WeaveMain.weaving(loader, classNodeX, classfileBuffer);
                }
            }
            return classfileBuffer;
        }
        return classfileBuffer;
    }

    public static MethodNode resetConstToNormal(MethodNode ctor) {
        MethodNode result = WeaveUtil.copy(ctor);
        while (result.instructions.size() > 0) {
            AbstractInsnNode insn = result.instructions.getFirst();
            result.instructions.remove(insn);
            if (insn.getType() != 5) continue;
            MethodInsnNode methodInsn = (MethodInsnNode)insn;
            if (!"<init>".equals(methodInsn.name)) continue;
            break;
        }
        return result;
    }

    private static StringLinkedSet removeWeavingWebfluxSet(StringLinkedSet weaving_reserved) {
        try {
            if (weaving_reserved == null || weaving_reserved.isEmpty()) {
                return weaving_reserved;
            }
            String[] weavingArray = weaving_reserved.getArray();
            boolean hasSpringBootOption = false;
            StringLinkedSet removedWebflux = new StringLinkedSet();
            for (int i = 0; i < weavingArray.length; ++i) {
                if (weavingArray[i].startsWith("spring-boot-2") || weavingArray[i].startsWith("spring-boot-3")) {
                    hasSpringBootOption = true;
                }
                if (!weavingArray[i].startsWith("webflux")) continue;
                weaving_reserved.remove(weavingArray[i]);
                removedWebflux.put(weavingArray[i]);
            }
            if (!removedWebflux.isEmpty()) {
                String weavingString = removedWebflux.toString();
                Logger.yellow("Weaving", "webflux option deprecated. removing " + weavingString.substring(1, weavingString.length() - 1));
                if (!hasSpringBootOption) {
                    Logger.yellow("Weaving", "Use weaving=spring-boot-2.1 or weaving=spring-boot-2.5 or weaving=spring-boot-2.7");
                }
            }
            if (!weaving_reserved.isEmpty()) {
                String weavingString = weaving_reserved.toString();
                Logger.green("Weaving", "applying weaving=" + weavingString.substring(1, weavingString.length() - 1));
            }
        }
        catch (Throwable t) {
            Logger.println("Weaving", t);
        }
        return weaving_reserved;
    }

    public static void main(String[] args) {
        Configure conf = Configure.getInstance();
        StringLinkedSet weaving_reserved = ConfWeaving.getStringWeavingSet(conf, "weaving", "spring-boot-2.7,spring-boot-2.2,spring-boot-3.0,webflux-5.1", ",");
        System.out.println("weaving_reserved=" + weaving_reserved);
        try {
            if (weaving_reserved == null || weaving_reserved.isEmpty()) {
                System.out.println("(Weaving) no weaving options");
            }
            String[] weavingArray = weaving_reserved.getArray();
            boolean hasSpringBootOption = false;
            StringLinkedSet removedWebflux = new StringLinkedSet();
            for (int i = 0; i < weavingArray.length; ++i) {
                if (weavingArray[i].startsWith("spring-boot-2") || weavingArray[i].startsWith("spring-boot-3")) {
                    hasSpringBootOption = true;
                }
                if (!weavingArray[i].startsWith("webflux")) continue;
                weaving_reserved.remove(weavingArray[i]);
                removedWebflux.put(weavingArray[i]);
            }
            if (!removedWebflux.isEmpty()) {
                String weavingString = removedWebflux.toString();
                System.out.println("(Weaving) webflux option deprecated. removing " + weavingString.substring(1, weavingString.length() - 1));
                if (!hasSpringBootOption) {
                    System.out.println("(Weaving) Use weaving=spring-boot-2.1 or weaving=spring-boot-2.5 or weaving=spring-boot-2.7 instead");
                }
            }
            if (!weaving_reserved.isEmpty()) {
                String weavingString = weaving_reserved.toString();
                System.out.println("(Weaving) weaving=" + weavingString.substring(1, weavingString.length() - 1));
            }
        }
        catch (Throwable t) {
            Logger.println("Weaving", t);
        }
    }
}

