/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import whatap.agent.asm.util.HookComponentMap;
import whatap.util.StrMatch;
import whatap.util.StringSet;
import whatap.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HookingSet {
    public byte xType = 0;
    public StrMatch classMatch = null;
    protected StringSet inner = new StringSet(11, 1.0f);
    private boolean all_flag = false;
    public static final HookingSet empty = new HookingSet();

    public boolean isA(String method, String desc) {
        if (this.all_flag) {
            return true;
        }
        if (this.contains(method)) {
            return true;
        }
        return this.contains(method + desc);
    }

    private boolean contains(String methodAndDesc) {
        return this.inner.hasKey(methodAndDesc);
    }

    public void add(String methodAndDesc) {
        if ("*".equals(methodAndDesc)) {
            this.all_flag = true;
        } else {
            this.inner.put(methodAndDesc);
        }
    }

    public HookingSet setAll() {
        this.all_flag = true;
        return this;
    }

    public HookingSet addList(List<String> names) {
        for (String m : names) {
            if ("*".equals(m)) {
                this.all_flag = true;
                continue;
            }
            this.inner.put(m);
        }
        return this;
    }

    public static Map<String, HookingSet> getHookingSet(String arg) {
        String[] c = StringUtil.split(arg, ',');
        HashMap<String, HookingSet> classSet = new HashMap<String, HookingSet>();
        for (int i = 0; i < c.length; ++i) {
            String s = c[i];
            int x = s.lastIndexOf(".");
            if (x <= 0) continue;
            String cname = s.substring(0, x).replace('.', '/');
            String mname = s.substring(x + 1);
            HookingSet methodSet = (HookingSet)classSet.get(cname);
            if (methodSet == null) {
                methodSet = new HookingSet();
                classSet.put(cname, methodSet);
            }
            methodSet.add(mname);
        }
        return classSet;
    }

    public static List<HookingSet> getHookingMethodSet(String patterns) {
        String[] methodPatterns = StringUtil.split(patterns, ',');
        HashMap<String, HookingSet> classMap = new HashMap<String, HookingSet>();
        for (int i = 0; i < methodPatterns.length; ++i) {
            String pattern = methodPatterns[i];
            int dotPos = pattern.lastIndexOf(".");
            if (dotPos <= 0) continue;
            String cname = pattern.substring(0, dotPos).replace('.', '/').trim();
            String mname = pattern.substring(dotPos + 1).trim();
            HookingSet methodSet = (HookingSet)classMap.get(cname);
            if (methodSet == null) {
                methodSet = new HookingSet();
                classMap.put(cname, methodSet);
            }
            methodSet.add(mname);
        }
        ArrayList<HookingSet> list = new ArrayList<HookingSet>();
        for (Map.Entry e : classMap.entrySet()) {
            ((HookingSet)e.getValue()).classMatch = new StrMatch((String)e.getKey());
            list.add((HookingSet)e.getValue());
        }
        return list;
    }

    public static HashMap<String, HookingSet> getHookingClassMethodSet(String patterns) {
        String[] methodPatterns = StringUtil.split(patterns, ',');
        HashMap<String, HookingSet> classMap = new HashMap<String, HookingSet>();
        for (int i = 0; i < methodPatterns.length; ++i) {
            String pattern = methodPatterns[i];
            int dotPos = pattern.lastIndexOf(".");
            if (dotPos <= 0) continue;
            String cname = pattern.substring(0, dotPos).replace('.', '/').trim();
            String mname = pattern.substring(dotPos + 1).trim();
            HookingSet methodSet = classMap.get(cname);
            if (methodSet == null) {
                methodSet = new HookingSet();
                classMap.put(cname, methodSet);
            }
            methodSet.add(mname);
        }
        return classMap;
    }

    public static void setHookingMethod(Map<String, HookingSet> classSet, String cname, String mname) {
        HookingSet methodSet = classSet.get(cname);
        if (methodSet == null) {
            methodSet = new HookingSet();
            classSet.put(cname, methodSet);
        }
        methodSet.add(mname);
    }

    public static void add(List<HookingSet> list, String classname, String method) {
        HookingSet.add(list, classname, method, (byte)0);
    }

    public static void add(List<HookingSet> list, String classname, String method, byte serviceType) {
        for (int i = 0; i < list.size(); ++i) {
            HookingSet m = list.get(i);
            if (!m.classMatch.include(classname)) continue;
            m.add(method);
            return;
        }
        HookingSet m = new HookingSet();
        m.xType = serviceType;
        m.classMatch = new StrMatch(classname);
        m.add(method);
        list.add(m);
    }

    public static HashSet<String> getHookingClassSet(String arg) {
        String[] c = StringUtil.tokenizer(arg, ",");
        HashSet<String> classSet = new HashSet<String>();
        if (c == null) {
            return classSet;
        }
        for (int i = 0; i < c.length; ++i) {
            classSet.add(c[i].replace('.', '/'));
        }
        return classSet;
    }

    public static Map<String, String> getClassFieldSet(String arg) {
        String[] c = StringUtil.split(arg, ',');
        HashMap<String, String> m = new HashMap<String, String>();
        for (int i = 0; i < c.length; ++i) {
            String s = c[i];
            int x = s.lastIndexOf(".");
            if (x <= 0) continue;
            String cname = s.substring(0, x).replace('.', '/').trim();
            String mname = s.substring(x + 1).trim();
            m.put(cname, mname);
        }
        return m;
    }

    public static Map<String, String> getClassAndKey(String arg) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (arg == null) {
            return m;
        }
        try {
            String[] c = StringUtil.split(arg, ',');
            for (int i = 0; i < c.length; ++i) {
                String s = c[i];
                int x = s.indexOf("@");
                if (x <= 0) continue;
                String key = s.substring(0, x).trim();
                String cname = s.substring(x + 1).replace('.', '/').trim();
                if (key.length() <= 0 || cname.indexOf(47) <= 0) continue;
                m.put(cname, key);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return m;
    }

    public static HookComponentMap getHookComponent(String hook_component) {
        HookComponentMap out = new HookComponentMap();
        String[] c = StringUtil.tokenizer(hook_component, ",");
        if (c != null) {
            for (int i = 0; i < c.length; ++i) {
                String s = c[i];
                int x = s.indexOf("@");
                if (x <= 0) continue;
                String componentName = s.substring(0, x).trim();
                String fullname = s.substring(x + 1).trim();
                String[] classAndMethod = HookingSet.kv(fullname);
                if (classAndMethod == null) continue;
                String classInternalName = classAndMethod[0].replace('.', '/');
                String methodKey = classAndMethod[1];
                out.putMethod(classInternalName, methodKey, componentName);
            }
        }
        return out;
    }

    private static String[] kv(String line) {
        int x = line.lastIndexOf("#");
        if (x < 0 && (x = line.lastIndexOf(".")) < 0) {
            return null;
        }
        String s1 = line.substring(0, x);
        String s2 = line.substring(x + 1);
        return new String[]{s1, s2};
    }
}

