/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.Logger;
import whatap.agent.asm.IASM;
import whatap.agent.asm.TraceHelperExtMV;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.asm.util.HookingSet;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.org.objectweb.asm.Type;

class TraceHelperExtCV
extends ClassVisitor
implements Opcodes {
    public String className;
    private HookingSet mset;

    public TraceHelperExtCV(ClassVisitor cv, HookingSet mset, String className) {
        super(IASM.API, cv);
        this.mset = mset;
        this.className = className;
    }

    public MethodVisitor visitMethod(int access, String methodName, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, methodName, desc, signature, exceptions);
        if (mv == null || !this.mset.isA(methodName, desc)) {
            return mv;
        }
        if (AsmUtil.isInitMethod(methodName)) {
            return mv;
        }
        Logger.println("A101", 10, "tracehelper: " + this.className + "." + methodName + desc);
        return new TraceHelperExtMV(access, desc, mv, Type.getArgumentTypes(desc), (access & 8) != 0, this.className, methodName, desc);
    }
}

