/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.HashMap;
import java.util.List;
import whatap.agent.ClassDesc;
import whatap.agent.asm.IASM;
import whatap.agent.asm.MStatCV;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.agent.conf.ConfMethodStat;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;

public class MethodStatASM
extends IASM
implements Opcodes {
    private List<HookingSet> target = HookingSet.getHookingMethodSet(ConfMethodStat.hook_method_stat_patterns);
    private HashMap<String, HookingSet> supers = HookingSet.getHookingClassMethodSet(ConfMethodStat.hook_method_stat_supers);
    private HashMap<String, HookingSet> interfaces = HookingSet.getHookingClassMethodSet(ConfMethodStat.hook_method_stat_interfaces);
    private boolean hasConf = this.target.size() > 0 || this.supers.size() > 0 || this.interfaces.size() > 0;

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.target);
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!ConfHook.hook_methods_enabled || !this.hasConf) {
            return cv;
        }
        if (ConfHook.isIgnoreMethodClass(className)) {
            return cv;
        }
        for (int i = 0; i < this.target.size(); ++i) {
            HookingSet mset = this.target.get(i);
            if (!mset.classMatch.include(className)) continue;
            return new MStatCV(cv, mset, className, className);
        }
        HookingSet mset = this.supers.get(classDesc.superName);
        if (mset != null) {
            return new MStatCV(cv, mset, className, classDesc.superName);
        }
        if (this.interfaces.size() > 0 && classDesc.interfaces != null) {
            for (int i = 0; i < classDesc.interfaces.length; ++i) {
                mset = this.interfaces.get(classDesc.interfaces[i]);
                if (mset == null) continue;
                return new MStatCV(cv, mset, className, classDesc.interfaces[i]);
            }
        }
        return cv;
    }
}

