/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.ClassDesc;
import whatap.agent.Logger;
import whatap.agent.asm.IASM;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.jdbc.JdbcAsm;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Label;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.org.objectweb.asm.Type;
import whatap.org.objectweb.asm.commons.LocalVariablesSorter;
import whatap.util.StringSet;

public class JDBCDriverManagerOpenASM
extends IASM
implements Opcodes {
    private static String className = "java/sql/DriverManager";
    private static String methodName = "getConnection";
    private static StringSet methodDesc = new StringSet();

    public void reserved(ReservedSet classSet) {
    }

    public ClassVisitor transform(ClassVisitor cv, String cname, ClassDesc classDesc) {
        if (!ConfHook.hook_drivermanager_enabled) {
            return cv;
        }
        if (!cname.equals(className)) {
            return cv;
        }
        Logger.println("BCI", "jdbc-drmgr-open " + className);
        return new DriverManagerOpenCV(cv);
    }

    static {
        methodDesc.put("(Ljava/lang/String;)Ljava/sql/Connection;");
        methodDesc.put("(Ljava/lang/String;Ljava/util/Properties;)Ljava/sql/Connection;");
        methodDesc.put("(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/sql/Connection;");
    }

    static class DriverManagerOpenMV
    extends LocalVariablesSorter
    implements Opcodes {
        private static final String TRACE_SQL = JdbcAsm.TRACE_SQL;
        private static final String START_METHOD = "drmOpenStart";
        private static final String START_SIGNATURE = "(Ljava/lang/String;)Ljava/lang/Object;";
        private static final String END_METHOD = "drmOpenEnd";
        private static final String END_SIGNATURE = "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;";
        private static final String END_SIGNATURE2 = "(Ljava/lang/Object;Ljava/lang/Throwable;)V";
        private Label startFinally = new Label();
        private int statIdx;

        public DriverManagerOpenMV(int access, String desc, MethodVisitor mv) {
            super(IASM.API, access, desc, mv);
        }

        public void visitCode() {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitMethodInsn(184, TRACE_SQL, START_METHOD, START_SIGNATURE, false);
            this.statIdx = this.newLocal(Type.getType(Object.class));
            this.mv.visitVarInsn(58, this.statIdx);
            this.mv.visitLabel(this.startFinally);
            this.mv.visitCode();
        }

        public void visitInsn(int opcode) {
            if (opcode >= 172 && opcode <= 177) {
                this.mv.visitVarInsn(25, this.statIdx);
                this.mv.visitMethodInsn(184, TRACE_SQL, END_METHOD, END_SIGNATURE, false);
                this.mv.visitTypeInsn(192, "java/sql/Connection");
            }
            this.mv.visitInsn(opcode);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
            Label endFinally = new Label();
            this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
            this.mv.visitLabel(endFinally);
            this.mv.visitInsn(89);
            int errIdx = this.newLocal(Type.getType(Throwable.class));
            this.mv.visitVarInsn(58, errIdx);
            this.mv.visitVarInsn(25, this.statIdx);
            this.mv.visitVarInsn(25, errIdx);
            this.mv.visitMethodInsn(184, TRACE_SQL, END_METHOD, END_SIGNATURE2, false);
            this.mv.visitInsn(191);
            this.mv.visitMaxs(maxStack + 8, maxLocals + 2);
        }
    }

    static class DriverManagerOpenCV
    extends ClassVisitor
    implements Opcodes {
        public DriverManagerOpenCV(ClassVisitor cv) {
            super(IASM.API, cv);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            if (mv == null || !methodName.equals(name) || !methodDesc.hasKey(desc)) {
                return mv;
            }
            return new DriverManagerOpenMV(access, desc, mv);
        }
    }
}

