/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.HashSet;
import whatap.agent.ClassDesc;
import whatap.agent.asm.HttpJakartaCV;
import whatap.agent.asm.IASM;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;

public class HttpJakartaASM
extends IASM
implements Opcodes {
    public HashSet<String> servlets = HookingSet.getHookingClassSet(ConfHook.hook_jakarta_servlet_classes);
    public HashSet<String> supers = HookingSet.getHookingClassSet(ConfHook.hook_jakarta_servlet_supers);
    public HashSet<String> filters = HookingSet.getHookingClassSet(ConfHook.hook_jakarta_filters);

    public HttpJakartaASM() {
        if (ConfHook.hook_jakarta_default_enabled) {
            this.servlets.add("jakarta/servlet/http/HttpServlet");
            this.servlets.add("org/apache/catalina/core/ApplicationFilterChain");
            this.filters.add("jakarta/servlet/Filter");
        }
    }

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.servlets);
        classSet.addInterface("jakarta/servlet/Filter");
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!ConfHook.hook_jakarta_http_enabled) {
            return cv;
        }
        if (this.servlets.contains(className)) {
            return new HttpJakartaCV(cv, className);
        }
        if (this.supers.contains(classDesc.superName)) {
            return new HttpJakartaCV(cv, className);
        }
        for (int i = 0; i < classDesc.interfaces.length; ++i) {
            if (!this.filters.contains(classDesc.interfaces[i])) continue;
            return new HttpJakartaCV(cv, className);
        }
        return cv;
    }
}

