/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.asm.IASM;
import whatap.agent.trace.TraceMain;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.org.objectweb.asm.Type;
import whatap.org.objectweb.asm.commons.LocalVariablesSorter;

class GtidReturnMV
extends LocalVariablesSorter
implements Opcodes {
    private static final String TRACE_MAIN = TraceMain.class.getName().replace('.', '/');
    private static final String END_METHOD = "gtidReturn";
    private static final String END_SIGNATURE = "(Ljava/lang/Object;)V";
    private Type returnType;

    public GtidReturnMV(int access, String desc, MethodVisitor mv, Type[] paramTypes, boolean isStatic, String classname, String methodname, String methoddesc) {
        super(IASM.API, access, desc, mv);
        this.returnType = Type.getReturnType(desc);
    }

    public void visitInsn(int opcode) {
        if (opcode >= 172 && opcode <= 177) {
            this.capReturn();
        }
        this.mv.visitInsn(opcode);
    }

    private void capReturn() {
        Type tp = this.returnType;
        if (tp == null || tp.equals(Type.VOID_TYPE)) {
            return;
        }
        int i = this.newLocal(tp);
        switch (tp.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            default: {
                this.mv.visitVarInsn(58, i);
                this.mv.visitVarInsn(25, i);
                this.mv.visitVarInsn(25, i);
                this.mv.visitMethodInsn(184, TRACE_MAIN, END_METHOD, END_SIGNATURE, false);
            }
        }
    }
}

