/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.HashSet;
import whatap.agent.ClassDesc;
import whatap.agent.asm.ExceptionCreateCV;
import whatap.agent.asm.IASM;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;

public class ExceptionCreateASM
extends IASM
implements Opcodes {
    private HashSet<String> target = HookingSet.getHookingClassSet(ConfHook.hook_create_exception_classes);
    private HashSet<String> supers = HookingSet.getHookingClassSet(ConfHook.hook_create_exception_supers);
    private HashSet<String> interfaces = HookingSet.getHookingClassSet(ConfHook.hook_create_exception_interfaces);
    private boolean ok = this.target.size() > 0 || this.supers.size() > 0 || this.interfaces.size() > 0;

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (!this.ok) {
            return cv;
        }
        if (this.target.contains(className)) {
            return new ExceptionCreateCV(cv, className);
        }
        if (this.supers.contains(classDesc.superName)) {
            return new ExceptionCreateCV(cv, className);
        }
        if (this.interfaces.size() > 0 && classDesc.interfaces != null) {
            for (int i = 0; i < classDesc.interfaces.length; ++i) {
                if (!this.interfaces.contains(classDesc.interfaces[i])) continue;
                return new ExceptionCreateCV(cv, className);
            }
        }
        return cv;
    }

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.target);
    }
}

