/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import whatap.agent.api.trace.TxMethod;
import whatap.agent.api.trace.TxMethodCtx;
import whatap.agent.asm.IASM;
import whatap.agent.asm.util.AsmUtil;
import whatap.org.objectweb.asm.Label;
import whatap.org.objectweb.asm.MethodVisitor;
import whatap.org.objectweb.asm.Opcodes;
import whatap.org.objectweb.asm.Type;
import whatap.org.objectweb.asm.commons.LocalVariablesSorter;

class DynaMethodMV
extends LocalVariablesSorter
implements Opcodes {
    private static final String TRACEMAIN = TxMethod.class.getName().replace('.', '/');
    private static final String START_METHOD = "start";
    private static final String START_SIGNATURE = "(ILjava/lang/String;)Lwhatap/agent/api/trace/TxMethodCtx;";
    private static final String END_METHOD = "end";
    private static final String END_SIGNATURE = "(Lwhatap/agent/api/trace/TxMethodCtx;Ljava/lang/Throwable;)V";
    private Label startFinally = new Label();
    private int fullname_hash;
    private String fullname;
    private int statIdx;

    public DynaMethodMV(int access, String desc, MethodVisitor mv, String fullname, int fullname_hash) {
        super(IASM.API, access, desc, mv);
        this.fullname = fullname;
        this.fullname_hash = fullname_hash;
    }

    public void visitCode() {
        AsmUtil.PUSH(this.mv, this.fullname_hash);
        this.mv.visitLdcInsn(this.fullname);
        this.mv.visitMethodInsn(184, TRACEMAIN, START_METHOD, START_SIGNATURE, false);
        this.statIdx = this.newLocal(Type.getType(TxMethodCtx.class));
        this.mv.visitVarInsn(58, this.statIdx);
        this.mv.visitLabel(this.startFinally);
        this.mv.visitCode();
    }

    public void visitInsn(int opcode) {
        if (opcode >= 172 && opcode <= 177) {
            this.mv.visitVarInsn(25, this.statIdx);
            this.mv.visitInsn(1);
            this.mv.visitMethodInsn(184, TRACEMAIN, END_METHOD, END_SIGNATURE, false);
        }
        this.mv.visitInsn(opcode);
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        Label endFinally = new Label();
        this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
        this.mv.visitLabel(endFinally);
        this.mv.visitInsn(89);
        int errIdx = this.newLocal(Type.getType(Throwable.class));
        this.mv.visitVarInsn(58, errIdx);
        this.mv.visitVarInsn(25, this.statIdx);
        this.mv.visitVarInsn(25, errIdx);
        this.mv.visitMethodInsn(184, TRACEMAIN, END_METHOD, END_SIGNATURE, false);
        this.mv.visitInsn(191);
        this.mv.visitMaxs(maxStack + 8, maxLocals + 2);
    }
}

