/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.asm;

import java.util.HashMap;
import java.util.Map;
import whatap.agent.ClassDesc;
import whatap.agent.asm.ConnectionPoolCV;
import whatap.agent.asm.IASM;
import whatap.agent.asm.ReservedSet;
import whatap.agent.asm.util.HookingSet;
import whatap.agent.conf.ConfHook;
import whatap.agent.counter.task.pools.BasicDataSourcePool;
import whatap.agent.counter.task.pools.C3P0DataSourcePool;
import whatap.agent.counter.task.pools.DruidConnPool;
import whatap.agent.counter.task.pools.HbyrisDataSourcePool;
import whatap.agent.counter.task.pools.JBossConnPool;
import whatap.agent.counter.task.pools.JBossDataSourcePool;
import whatap.agent.counter.task.pools.JeusConnPool;
import whatap.agent.counter.task.pools.MyDataSource;
import whatap.agent.counter.task.pools.RedisJedisPool;
import whatap.agent.counter.task.pools.TomcatConnnPool;
import whatap.agent.counter.task.pools.WebLogicConnPool;
import whatap.org.objectweb.asm.ClassVisitor;
import whatap.org.objectweb.asm.Opcodes;

public class ConnectionPoolASM
extends IASM
implements Opcodes {
    public Map<String, String> target = new HashMap<String, String>();

    public void reserved(ReservedSet classSet) {
        classSet.addClass(this.target.keySet());
    }

    public ConnectionPoolASM() {
        this.target.clear();
        if (ConfHook.hook_default_pool_enabled) {
            this.setDefaultPoolClass();
        }
        this.target.putAll(HookingSet.getClassAndKey(ConfHook.custom_pool_classes));
    }

    private void setDefaultPoolClass() {
        if (ConfHook.hook_hikari_pool_enabled) {
            this.target.put("com/zaxxer/hikari/pool/HikariPool", "HikariPool");
        }
        if (ConfHook.hook_dbcp_pool_enabled) {
            this.target.put("org/apache/commons/dbcp/BasicDataSource", BasicDataSourcePool.className);
            this.target.put("org/apache/commons/dbcp2/BasicDataSource", BasicDataSourcePool.className);
            this.target.put("org/apache/tomcat/dbcp/dbcp/BasicDataSource", BasicDataSourcePool.className);
            this.target.put("org/apache/tomcat/dbcp/dbcp2/BasicDataSource", BasicDataSourcePool.className);
        }
        if (ConfHook.hook_tomcat_pool_enabled) {
            this.target.put("org/apache/tomcat/jdbc/pool/ConnectionPool", TomcatConnnPool.className);
        }
        if (ConfHook.hook_weblogic_pool_enabled) {
            this.target.put("weblogic/jdbc/common/internal/ConnectionPool", WebLogicConnPool.classNameId);
        }
        if (ConfHook.hook_jeus_pool_enabled) {
            this.target.put("jeus/jdbc/connectionpool/ConnectionPoolImpl", JeusConnPool.className);
        }
        if (ConfHook.hook_jboss_pool_enabled) {
            this.target.put("org/jboss/jca/core/connectionmanager/pool/PoolStatisticsImpl", JBossConnPool.className);
        }
        if (ConfHook.hook_jboss_datasource_pool_enabled) {
            this.target.put("org/jboss/jca/core/api/management/DataSource", JBossDataSourcePool.className);
        }
        if (ConfHook.hook_jedis_pool_enabled) {
            this.target.put("redis/clients/jedis/JedisPool", RedisJedisPool.className);
        }
        if (ConfHook.hook_hybris_pool_enabled) {
            this.target.put("de/hybris/platform/jdbcwrapper/DataSourceImpl", HbyrisDataSourcePool.className);
        }
        if (ConfHook.hook_c3p0_pool_enabled) {
            this.target.put("com/mchange/v2/c3p0/ComboPooledDataSource", C3P0DataSourcePool.className);
        }
        if (ConfHook.hook_druid_pool_enabled) {
            this.target.put("com/alibaba/druid/pool/DruidDataSource", DruidConnPool.className);
        }
        this.target.put("bmt/ds/MyDataSource", MyDataSource.className);
    }

    public ClassVisitor transform(ClassVisitor cv, String className, ClassDesc classDesc) {
        if (this.target.containsKey(className)) {
            return new ConnectionPoolCV(cv, this.target.get(className));
        }
        return cv;
    }
}

