/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.app;

import java.util.ArrayList;
import whatap.agent.Configure;
import whatap.agent.app.IAppCtx;
import whatap.agent.app.NameAndUrl;
import whatap.agent.trace.TraceContext;
import whatap.util.HashUtil;
import whatap.util.IntKeyLinkedMap;
import whatap.util.IntLinkedSet;
import whatap.util.StringUtil;

public class PathPrefix
implements IAppCtx {
    static Configure conf = Configure.getInstance();
    NameAndUrl[] list = new NameAndUrl[0];
    int confHash = 0;
    private static IntLinkedSet noNeedSet = new IntLinkedSet(1025, 1.0f).setMax(10000);
    private static IntKeyLinkedMap<String> parsedSet = new IntKeyLinkedMap().setMax(10000);

    public void update() {
        String val = conf.getValue("app_context_path_set", "");
        int confHashNew = HashUtil.hash(val);
        if (this.confHash != confHashNew) {
            this.confHash = confHashNew;
            try {
                ArrayList<NameAndUrl> out = new ArrayList<NameAndUrl>();
                String[] lst = StringUtil.tokenizer(val, ",");
                block6: for (int i = 0; i < lst.length; ++i) {
                    String[] item = StringUtil.divKeyValueTrim(lst[i], "@");
                    switch (item.length) {
                        case 2: {
                            out.add(new NameAndUrl(item[0], item[1]));
                            continue block6;
                        }
                        case 1: {
                            out.add(new NameAndUrl(item[0], item[0]));
                        }
                    }
                }
                this.list = out.toArray(new NameAndUrl[out.size()]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            noNeedSet.clear();
            parsedSet.clear();
        }
    }

    public String parse(int hash, String url, TraceContext ctx) {
        if (noNeedSet.contains(hash)) {
            return null;
        }
        String newUrl = parsedSet.get(hash);
        if (newUrl != null) {
            return newUrl;
        }
        NameAndUrl[] tmp = this.list;
        for (int i = 0; i < tmp.length; ++i) {
            if (!url.startsWith(tmp[i].url)) continue;
            parsedSet.put(hash, tmp[i].name);
            return tmp[i].name;
        }
        noNeedSet.put(hash);
        return null;
    }

    public String name() {
        return "prefix";
    }
}

