/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.api.trace;

import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.api.trace.Request;
import whatap.agent.api.trace.Response;
import whatap.agent.conf.ConfUser;
import whatap.util.HashUtil;
import whatap.util.Hexa32;
import whatap.util.KeyGen;

public class TxWebUtil {
    static Configure conf = Configure.getInstance();
    private static final String WHATAP_R = "WHATAP";

    public static long getWCID(Request req, Response res, long defValue) {
        try {
            String cookie = req.getHeader("Cookie");
            if (cookie != null) {
                int x1 = cookie.indexOf(WHATAP_R);
                if (x1 >= 0) {
                    String value = null;
                    int x2 = cookie.indexOf(59, x1);
                    value = x2 > 0 ? cookie.substring(x1 + WHATAP_R.length() + 1, x2) : cookie.substring(x1 + WHATAP_R.length() + 1);
                    try {
                        return Hexa32.toLong32(value);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (cookie.length() >= ConfUser.wclient_cookie_limit) {
                    return defValue;
                }
            }
            res.setNewClientCookie(KeyGen.next());
        }
        catch (Throwable t) {
            Logger.println("A502", 10, "" + t);
        }
        return 0L;
    }

    public static String parseCookie(String cookie, String key) {
        try {
            int x1 = cookie.indexOf(key + "=");
            if (x1 >= 0) {
                String value = null;
                int x2 = cookie.indexOf(59, x1);
                value = x2 > 0 ? cookie.substring(x1 + key.length() + 1, x2) : cookie.substring(x1 + key.length() + 1);
                return value;
            }
        }
        catch (Throwable t) {
            Logger.println("A504", 10, "" + t);
        }
        return null;
    }

    public static long getWCIDCustom(Request req, Response res, String key) {
        if (key == null || key.length() == 0) {
            return 0L;
        }
        try {
            int x1;
            String cookie = req.getHeader("Cookie");
            if (cookie != null && (x1 = cookie.indexOf(key)) >= 0) {
                String value = null;
                int x2 = cookie.indexOf(59, x1);
                value = x2 > 0 ? cookie.substring(x1 + key.length() + 1, x2) : cookie.substring(x1 + key.length() + 1);
                if (value != null) {
                    return HashUtil.hash(value);
                }
            }
        }
        catch (Throwable t) {
            Logger.println("A503", 10, "" + t);
        }
        return 0L;
    }

    public static long getWCIDFromHeader(Request req) {
        String ticket = req.getHeader(ConfUser.wclient_header_key);
        if (ticket != null && ticket.length() > 0) {
            return HashUtil.hash(ticket);
        }
        return 0L;
    }

    public static boolean isStaticContents(String serviceName) {
        int x = serviceName.lastIndexOf(46);
        if (x <= 0) {
            return false;
        }
        try {
            String ext = serviceName.substring(x + 1);
            return conf.isStaticContents(ext);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void main(String[] args) {
        String cookie = "lang=en; wa=\"W/Kz829oWnH9XO5deG5iPQTZzzpleFDaY4MQrtzivtU3E48c0B5sZdjwDRS5RhGHNp+AKl3ll5c=\"; JSESSIONID=L5GU1wQMdXGi4xIpMWUjx4Md5-fGBdg6WAOwxtaz";
        String key = "JSESSIONID";
        try {
            int x1 = cookie.indexOf(key + "=");
            if (x1 >= 0) {
                String value = null;
                int x2 = cookie.indexOf(59, x1);
                System.out.println("x2>0 ? " + (x2 > 0));
                value = x2 > 0 ? cookie.substring(x1 + key.length() + 1, x2) : cookie.substring(x1 + key.length() + 1);
                System.out.println("value=" + value);
            }
        }
        catch (Throwable t) {
            System.out.println(t.getMessage() + "\n" + t);
        }
    }
}

