/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.api.trace;

import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.List;
import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.ParamSecurity;
import whatap.agent.SecurityMaster;
import whatap.agent.api.trace.IgnoreCheck;
import whatap.agent.api.trace.Request;
import whatap.agent.api.trace.Response;
import whatap.agent.api.trace.TxWebUtil;
import whatap.agent.app.AppCtxStatCollector;
import whatap.agent.asm.util.AsmUtil;
import whatap.agent.conf.ConfMTrace;
import whatap.agent.conf.ConfThrottle;
import whatap.agent.conf.ConfTrace;
import whatap.agent.conf.ConfUser;
import whatap.agent.conf.util.ServiceNameMode;
import whatap.agent.counter.meter.MeterUsers;
import whatap.agent.counter.meter.tx.MeterService;
import whatap.agent.data.DataProfileAgent;
import whatap.agent.data.DataTextAgent;
import whatap.agent.plugin.PluginAppServiceEnd;
import whatap.agent.plugin.PluginAppServiceStart;
import whatap.agent.plugin.PluginHttpServiceEnd;
import whatap.agent.plugin.PluginHttpServiceStart;
import whatap.agent.stat.ErrorArg;
import whatap.agent.stat.StatError;
import whatap.agent.trace.Alert;
import whatap.agent.trace.HookArgs;
import whatap.agent.trace.HttpLog;
import whatap.agent.trace.MTraceHelper;
import whatap.agent.trace.RejectUtil;
import whatap.agent.trace.Throttle;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.trace.TraceHttpc;
import whatap.agent.trace.TraceSamplingManager;
import whatap.agent.trace.exception.ExceptionAlert;
import whatap.agent.trace.urlnorm.URLPrefixProxy;
import whatap.agent.trace.urlnorm.UrlNormProxy;
import whatap.io.DataInputX;
import whatap.lang.pack.ProfilePack;
import whatap.lang.ref.BYTE;
import whatap.lang.service.TxRecord;
import whatap.lang.service.WebMethod;
import whatap.lang.step.MessageStep;
import whatap.lang.step.MessageStepX;
import whatap.lang.step.MethodStepX;
import whatap.lang.step.SecureMsgStep;
import whatap.lang.value.DecimalValue;
import whatap.lang.value.ListValue;
import whatap.lang.value.TextValue;
import whatap.notice.REQUEST_REJECT;
import whatap.notice.WHATAP_ERROR;
import whatap.reqlog.ReqLogConf;
import whatap.reqlog.file.ReqLogThread;
import whatap.reqlog.sink.ReqLogSinkThread;
import whatap.util.AnsiPrint;
import whatap.util.BitUtil;
import whatap.util.DateUtil;
import whatap.util.HashUtil;
import whatap.util.IPUtil;
import whatap.util.IntSet;
import whatap.util.KeyGen;
import whatap.util.LinkedMap;
import whatap.util.StrMatch;
import whatap.util.StringUtil;
import whatap.util.SysJMX;

public class TxTrace {
    protected static Configure conf = Configure.getInstance();
    public static LinkedMap<Object, WeakReference<TraceContext>> txTraceMap = new LinkedMap().setMax(TxTrace.conf.trace_attach_link_max);
    private static MeterService meter = MeterService.getInstance();
    static int mtraceErrorCount = 30;
    private static int req_err_log = 30;
    protected static Error REJECT = new REQUEST_REJECT("rejected request");
    protected static long last_log;
    private static int childThreadProfileHash;
    static ThreadLocal sampling;

    public void service(String name) {
        if (name == null) {
            return;
        }
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx != null) {
            ctx.service_hash = HashUtil.hash(name);
            ctx.service_name = name;
        }
    }

    public static TraceContext startHttpTx(Request req, Response res) {
        if (!TxTrace.conf.transaction_enabled) {
            return null;
        }
        if (ConfTrace.trace_sampling_enabled) {
            if (req.getAttribute("WHATAP_SAMPLING") != null) {
                return null;
            }
            if (!TraceSamplingManager.traceOk()) {
                req.setAttribute("WHATAP_SAMPLING", "off");
                return TraceContext.sampling();
            }
        }
        try {
            if (TraceContext.isActivated(req)) {
                return null;
            }
            TraceContext ctx = TxTrace._httpStartRealTx(req, res);
            if (ctx.service_name == null) {
                ctx.service_name = "Non-URI";
            } else if (TxTrace.conf.app_context_enabled) {
                ctx.appctx = AppCtxStatCollector.getContextPath(ctx.service_hash, ctx.service_name, ctx);
            }
            if (!ctx.isStaticContents) {
                PluginHttpServiceStart.process(ctx, req, res);
            }
            return ctx;
        }
        catch (Throwable t) {
            Logger.println("HttpTx", 10, "fail to deploy ", t);
            return null;
        }
    }

    private static String plus(String service_name, String append) {
        StringBuilder sb = new StringBuilder(service_name.length() + append.length() + 16);
        sb.append(service_name).append(ConfTrace.trace_tx_name_with_method_delimiter).append(append);
        return sb.toString();
    }

    private static TraceContext _httpStartRealTx(Request request, Response response) {
        String userAgent;
        String referer;
        TraceContext ctx = new TraceContext(ConfTrace._trace_collecting_mode);
        ctx.activate(KeyGen.next(), request, response);
        ctx.thread = Thread.currentThread();
        ctx.resetStartTime();
        if (TxTrace.conf.trace_cpu_endpoint_enabled) {
            ctx.start_cpu = SysJMX.getCurrentThreadCPU();
        }
        if (TxTrace.conf.trace_malloc_endpoint_enabled) {
            ctx.start_malloc = SysJMX.getCurrentThreadAllocBytes();
        }
        TraceContextManager.start(ctx);
        TxTrace.setServiceNameFromURI(ctx, request);
        ctx.http_method = request.getMethod();
        if (ConfTrace.trace_tx_name_with_method_enabled && ctx.http_method != null) {
            ctx.service_name = TxTrace.plus(ctx.service_name, ctx.http_method);
        }
        ctx.service_hash = HashUtil.hash(ctx.service_name);
        if (TxTrace.conf.trace_ignore_active_url_set.contains(ctx.service_hash)) {
            ctx.addMeterServiceEnabled = false;
            ctx.addActiveTxListEnabled = false;
            ctx.addActiveTxCounterEnabled = false;
            return ctx;
        }
        if (TxTrace.conf.trace_ignore_url_set.contains(ctx.service_hash)) {
            ctx.isStaticContents = true;
            return ctx;
        }
        if (TxTrace.conf._has_trace_ignore_url_prefix && IgnoreCheck.isIgnoreUrl(ctx.service_hash, ctx.service_name)) {
            ctx.isStaticContents = true;
            return ctx;
        }
        ctx.isStaticContents = TxWebUtil.isStaticContents(ctx.service_name);
        if (ctx.isStaticContents) {
            return ctx;
        }
        ctx.http_url = request.getRequestURL();
        if (ctx.http_method != null && TxTrace.conf._ignore_http_method.get(ctx.http_method) != 0) {
            ctx.isStaticContents = true;
            return ctx;
        }
        ++TxTrace.meter.arrival;
        ctx.http_query = request.getQueryString();
        ctx.http_content_type = request.getContentType();
        ctx.http_host = request.getHeader("host");
        if (ctx.http_host != null) {
            ctx.http_host_hash = HashUtil.hash(ctx.http_host);
            DataTextAgent.HTTP_DOMAIN.add(ctx.http_host_hash, ctx.http_host);
        }
        try {
            ctx.remoteAddr = TxTrace.getRemoteAddr(request);
            if (ConfTrace.trace_remote_ip6_enabled && ctx.remoteAddr != null && ctx.remoteAddr.indexOf(58) >= 0) {
                ctx.remoteAddrIPv6 = true;
            } else {
                ctx.remoteIp = DataInputX.toInt(IPUtil.toBytes(ctx.remoteAddr), 0);
            }
            switch (ConfUser.wclient_trace_type) {
                case 1: {
                    ctx.wclientId = ctx.remoteAddrIPv6 ? HashUtil.hash64(ctx.remoteAddr) : (long)ctx.remoteIp;
                    MeterUsers.add(ctx.wclientId);
                    break;
                }
                case 4: {
                    ctx.wclientId = TxWebUtil.getWCIDCustom(request, response, ConfUser.wclient_jsession_key);
                    MeterUsers.add(ctx.wclientId);
                    break;
                }
                case 2: {
                    ctx.wclientId = TxWebUtil.getWCID(request, response, ctx.remoteIp);
                    MeterUsers.add(ctx.wclientId);
                    break;
                }
                case 3: {
                    ctx.wclientId = TxWebUtil.getWCIDFromHeader(request);
                    MeterUsers.add(ctx.wclientId);
                    break;
                }
                default: {
                    ctx.wclientId = 0L;
                }
            }
            if (TxTrace.conf._has_request_encoding) {
                request.setCharacterEncoding(TxTrace.conf.http_request_encoding);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (TxTrace.conf._has_request_encoding) {
            request.setCharacterEncoding(TxTrace.conf.http_request_encoding);
        }
        if (TxTrace.conf.trace_referer_enabled && (referer = request.getHeader("referer")) != null) {
            ctx.referer = HashUtil.hash(referer);
            DataTextAgent.REFERER.add(ctx.referer, referer);
        }
        if ((userAgent = request.getHeader("User-Agent")) != null) {
            ctx.userAgent = HashUtil.hash(userAgent);
            ctx.userAgentString = userAgent;
            DataTextAgent.USERAGENT.add(ctx.userAgent, userAgent);
        }
        if (ConfMTrace.mtrace_enabled) {
            TxTrace.mtrace(ctx, request);
        }
        if (ConfTrace.trace_http_header_enabled && (ConfTrace.trace_http_header_url_prefix == null || ctx.service_name.indexOf(ConfTrace.trace_http_header_url_prefix) >= 0)) {
            if (ConfTrace.trace_http_header_hash_enabled) {
                TxTrace.traceHttpHeaderHash(ctx, request);
            } else {
                TxTrace.traceHttpHeader(ctx, request);
            }
        }
        return ctx;
    }

    private static void traceHttpHeader(TraceContext ctx, Request request) {
        Enumeration en = request.getHeaderNames();
        if (en != null) {
            int start_time = ctx.getElapsedTime();
            int hash = HashUtil.hash("HTTP-HEADERS");
            DataTextAgent.MESSAGE.add(hash, "HTTP-HEADERS");
            MessageStep step = new MessageStep();
            step.hash = hash;
            step.start_time = start_time;
            StringBuilder vb = new StringBuilder();
            if (ConfTrace.trace_http_header_ignore_keys.size() == 0) {
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    vb.append(key).append("=").append(StringUtil.limiting(request.getHeader(key), 1024)).append("\n");
                }
            } else {
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    if (ConfTrace.trace_http_header_ignore_keys.hasKey(key)) continue;
                    vb.append(key).append("=").append(StringUtil.limiting(request.getHeader(key), 1024)).append("\n");
                }
            }
            step.desc = vb.toString();
            ctx.profile.add(step);
        }
    }

    private static void traceHttpHeaderHash(TraceContext ctx, Request request) {
        Enumeration en = request.getHeaderNames();
        if (en != null) {
            int start_time = ctx.getElapsedTime();
            MessageStepX step = new MessageStepX();
            step.title = "HTTP-HEADERS";
            step.start_time = start_time;
            ListValue headerHash = new ListValue();
            if (ConfTrace.trace_http_header_ignore_keys.size() == 0) {
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    TxTrace.addSplitHttpHeader(request, key, headerHash);
                }
            } else {
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    if (ConfTrace.trace_http_header_ignore_keys.hasKey(key)) continue;
                    TxTrace.addSplitHttpHeader(request, key, headerHash);
                }
            }
            if (!headerHash.isEmpty()) {
                step.setAttr("hash_array", headerHash);
                ctx.profile.add(step);
            }
        }
    }

    private static void addSplitHttpHeader(Request request, String key, ListValue headerHash) {
        String data = key + "=" + StringUtil.limiting(request.getHeader(key), 1024);
        int _hash = HashUtil.hash(data);
        headerHash.add(_hash);
        DataTextAgent.SPLIT_HTTP_HEADER.add(_hash, data);
    }

    private static void mtrace(TraceContext ctx, Request request) {
        String custid;
        String poid;
        long traceparentStepId;
        boolean hasTraceparentKey;
        block16: {
            String parentKey = request.getHeader(ConfMTrace._trace_mtrace_traceparent_key);
            hasTraceparentKey = false;
            traceparentStepId = 0L;
            if (parentKey != null) {
                hasTraceparentKey = true;
                String[] parts = parentKey.trim().split("-");
                if (parts.length >= 4) {
                    block15: {
                        String mcallerTraceIdValue;
                        ctx.mcallerTraceparentValue = mcallerTraceIdValue = parts[1];
                        try {
                            String mtidHex = mcallerTraceIdValue.substring(16);
                            ctx.mtid = Long.parseUnsignedLong(mtidHex, 16);
                            if (ctx.mtid != 0L) {
                                ctx.mtid_build_checked = true;
                            }
                        }
                        catch (Throwable e) {
                            if (mtraceErrorCount-- < 0) break block15;
                            Logger.println("traceparent", e);
                        }
                    }
                    try {
                        ctx.mcaller_stepId = traceparentStepId = Long.parseUnsignedLong(parts[2], 16);
                    }
                    catch (Throwable e) {
                        if (mtraceErrorCount-- < 0) break block16;
                        Logger.println("traceparent", e);
                    }
                }
            }
        }
        if ((poid = request.getHeader(ConfMTrace._trace_mtrace_poid_key)) != null) {
            String val;
            ctx.setCallerPOID(poid);
            String mstt = request.getHeader(ConfMTrace._trace_mtrace_caller_key);
            if (mstt != null) {
                ctx.setTransferMTID_CALLERTX(mstt);
            }
            if (ConfMTrace.stat_mtrace_enabled && (val = request.getHeader(ConfMTrace._trace_mtrace_spec_key1)) != null && val.length() > 0) {
                ctx.setTransferSPEC_URL1(val);
            }
        }
        if (hasTraceparentKey && traceparentStepId != ctx.mcaller_stepId) {
            ctx.mcaller_stepId = traceparentStepId;
            ctx.mcaller_txid = 0L;
        }
        if (ConfMTrace._custom_trace_header_enabled && (custid = request.getHeader(ConfMTrace.custom_trace_header_key)) != null) {
            if (ctx.mtid == 0L) {
                ctx.customTrace(custid);
            } else {
                ctx.custid = custid;
                ctx.mtid_build_checked = true;
            }
        }
        if (!ctx.mtid_build_checked) {
            ctx.mtid = MTraceHelper.createId(ctx.userAgentString);
            ctx.mtid_build_checked = true;
        }
    }

    private static void setServiceNameFromURI(TraceContext ctx, Request request) {
        String uri = request.getRequestURI();
        try {
            if (uri == null) {
                ctx.service_name = "no-url";
            } else {
                int y;
                int x = uri.indexOf(ConfTrace.url_cut_ch1);
                if (x > 0) {
                    uri = uri.substring(0, x);
                }
                if (ConfTrace.url_cut_ch2 != '\u0000' && (y = uri.indexOf(ConfTrace.url_cut_ch2)) > 0) {
                    uri = uri.substring(0, y);
                }
                if (TxTrace.conf.trace_normalize_enabled) {
                    ctx.service_name = URLPrefixProxy.normalize(uri);
                    if (ctx.service_name == uri) {
                        ctx.service_name = UrlNormProxy.normalize(uri);
                    }
                    if (ctx.service_name != uri) {
                        ctx.origin_url = uri;
                    }
                } else {
                    ctx.service_name = uri;
                }
            }
        }
        catch (Throwable t) {
            ctx.service_name = uri;
        }
    }

    private static String getRemoteAddr(Request request) {
        try {
            if (TxTrace.conf.has_client_ip_header_key) {
                String addr = request.getHeader(TxTrace.conf.trace_http_client_ip_header_key);
                return addr != null ? addr : request.getRemoteAddr();
            }
            return request.getRemoteAddr();
        }
        catch (Throwable t) {
            return "0.0.0.0";
        }
    }

    public static boolean endHttpTxAnyway(TraceContext ctx, Throwable thro) {
        if (ConfTrace.trace_sampling_enabled && ctx != null && ctx.isFake()) {
            TraceContextManager.detach();
            return true;
        }
        if (TraceContext.isNullOrClosed(ctx)) {
            TraceContextManager.detach();
            return false;
        }
        TxTrace._httpEndRealTx(ctx, thro);
        return true;
    }

    public static boolean endHttpTx(TraceContext ctx, Throwable thro) {
        if (ConfTrace.trace_sampling_enabled && ctx != null && ctx.isFake()) {
            TraceContextManager.detach();
            return true;
        }
        if (TraceContext.isNullOrClosed(ctx)) {
            if (thro != null && TraceContext.isActivated(ctx = TraceContextManager.getLocalContext()) && ctx.exception == null) {
                ctx.exception = thro;
                if (ConfTrace.trace_endtx_error_stack && !ctx.hasErrorStack) {
                    ctx.profile(thro, ConfTrace.trace_endtx_error_depth);
                    ctx.hasErrorStack = true;
                }
            }
            return false;
        }
        if (ctx.isAsyncForwarded()) {
            if (thro != null && ctx.exception == null) {
                ctx.exception = thro;
            }
            TraceContextManager.detach();
            return false;
        }
        TxTrace._httpEndRealTx(ctx, thro);
        return true;
    }

    public static void _preHandleHttpEndRealTx(TraceContext ctx, Throwable thro) {
        try {
            if (ctx.isPreHandled.get()) {
                return;
            }
            if (ctx.isStaticContents) {
                TraceContextManager.end(ctx.txid);
                return;
            }
            ctx.preHandled();
            ctx.status = ctx.response.getStatus();
            if (ConfTrace.trace_http_parameter_enabled && (ConfTrace.trace_http_parameter_url_prefix == null || ctx.service_name.indexOf(ConfTrace.trace_http_parameter_url_prefix) >= 0)) {
                if (ConfTrace.trace_http_parameter_keys != null) {
                    TxTrace.doDump(ctx.request, ctx, ConfTrace.trace_http_parameter_keys);
                } else {
                    TxTrace.doDump(ctx.request, ctx);
                }
            }
            TxTrace.addServiceName(ctx, ctx.request);
            ctx.endTime = DateUtil.currentTime();
        }
        catch (Throwable e) {
            Logger.println("PreHandle EndTx", 10, e);
        }
    }

    private static void _httpEndRealTx(TraceContext ctx, Throwable thro) {
        try {
            ctx.close();
            if (ctx.request == null) {
                TxTrace._serviceEndRealTx(ctx, null, thro);
                return;
            }
            if (ctx.isStaticContents) {
                TraceContextManager.end(ctx.txid);
                return;
            }
            TxTrace._preHandleHttpEndRealTx(ctx, thro);
            ctx.handleEndTxErrorStack(thro);
            if (ConfTrace.trace_exception_overwrite_enabled && ctx.exception != null && ctx.error != null && ctx.exception != ctx.error.exception) {
                ctx.error = null;
            }
            if (ConfTrace.trace_thread_id_enabled && ctx.thread != null) {
                ctx.setExtraField("threadId", new DecimalValue(ctx.thread.getId()));
            }
            if (ConfTrace.trace_thread_name_enabled && ctx.thread != null) {
                ctx.setExtraField("threadName", new TextValue(ctx.thread.getName()));
            }
            PluginHttpServiceEnd.process(ctx, ctx.request, ctx.response);
            TraceContextManager.end(ctx.txid);
            SecurityMaster secu = SecurityMaster.getInstance();
            boolean isNew = DataTextAgent.SERVICE.add(ctx.service_hash, ctx.service_name);
            ProfilePack profile = new ProfilePack();
            TxRecord tx = new TxRecord();
            tx.txid = ctx.txid;
            tx.endTime = ctx.endTime;
            tx.elapsed = ctx.elapsed = ctx.getElapsedTime();
            if (tx.elapsed < 0) {
                ctx.elapsed = 0;
                tx.elapsed = 0;
            }
            tx.service = ctx.service_hash;
            if (ConfTrace.txtext_txname_enabled) {
                tx.txName = ctx.service_name;
            }
            tx.wclientId = ctx.wclientId;
            tx.userAgent = ctx.userAgent;
            tx.mcaller_pcode = ctx.mcaller_pcode;
            tx.mcaller_okind = ctx.mcaller_okind;
            tx.mcaller_oid = ctx.mcaller_oid;
            tx.custid = ctx.custid;
            tx.mtid = ctx.mtid;
            tx.mdepth = ctx.mdepth;
            tx.mcaller = ctx.mcaller_txid;
            tx.mcallerStepId = ctx.mcaller_stepId;
            if (ConfTrace.trace_origin_url_enabled) {
                tx.originUrl = ctx.origin_url;
            }
            tx.cipher = ParamSecurity.keyHash;
            if (ctx.start_cpu > 0L) {
                tx.cpuTime = (int)(SysJMX.getCurrentThreadCPU() - ctx.start_cpu);
            }
            if (ctx.start_malloc > 0L) {
                tx.malloc = SysJMX.getCurrentThreadAllocBytes() - ctx.start_malloc;
            }
            tx.sqlCount = ctx.sql_count;
            tx.sqlTime = ctx.sql_time;
            tx.sqlFetchCount = ctx.rs_count;
            tx.sqlFetchTime = (int)ctx.rs_time;
            tx.dbcTime = ctx.dbc_time;
            if (ctx.error != null) {
                tx.error = ctx.error.txErrorCode;
                tx.errorLevel = ctx.error.level;
                if (TxTrace.isBizException(ctx.error.className.hashCode())) {
                    tx.errorLevel = (byte)10;
                }
                TxTrace.errorMessageToTx(tx, ctx.error);
            } else if (ctx.exception != null && !TxTrace.isIgnoreExceptionTx(ctx.exception, ctx.service_hash, ctx.service_name)) {
                ErrorArg arg = new ErrorArg();
                arg.exception = ctx.exception;
                arg.message = ctx.exception.getMessage();
                arg.status = ctx.status;
                arg.setTraceCtx(ctx);
                tx.error = StatError.getInstance().addError(arg);
                if (TxTrace.isBizException(ctx.exception) || TxTrace.isBizExceptionAndStaus(ctx.exception, ctx.status)) {
                    tx.errorLevel = (byte)10;
                } else {
                    tx.errorLevel = (byte)20;
                    ExceptionAlert.getInstance().service(ctx, arg);
                }
                TxTrace.errorMessageToTx(tx, arg);
            } else if (ctx.unclosedConnMap != null && ctx.unclosedConnMap.size() > 0) {
                ErrorArg arg = new ErrorArg();
                arg.exception = WHATAP_ERROR.connection_not_close;
                arg.message = WHATAP_ERROR.connection_not_close.getMessage();
                arg.status = ctx.status;
                arg.setTraceCtx(ctx);
                StackTraceElement[] stack = ctx.unclosedConnMap.entries().nextElement().getValue();
                tx.error = StatError.getInstance().addJdbcLeak(arg, stack);
                tx.errorLevel = (byte)20;
                TxTrace.errorMessageToTx(tx, arg);
            } else if (ctx.unclosedStmtMap != null && ctx.unclosedStmtMap.size() > 0) {
                ErrorArg arg = new ErrorArg();
                arg.exception = WHATAP_ERROR.stmt_not_close;
                arg.message = WHATAP_ERROR.stmt_not_close.getMessage();
                arg.status = ctx.status;
                arg.setTraceCtx(ctx);
                StackTraceElement[] stack = ctx.unclosedStmtMap.entries().nextElement().getValue();
                tx.error = StatError.getInstance().addJdbcLeak(arg, stack);
                tx.errorLevel = (byte)20;
                TxTrace.errorMessageToTx(tx, arg);
            } else if (ctx.customLeak > 0) {
                ErrorArg arg = new ErrorArg();
                arg.exception = WHATAP_ERROR.custom_leak;
                arg.message = WHATAP_ERROR.custom_leak.getMessage();
                arg.status = ctx.status;
                arg.setTraceCtx(ctx);
                tx.error = StatError.getInstance().addError(arg);
                tx.errorLevel = (byte)20;
                TxTrace.errorMessageToTx(tx, arg);
            } else if (TxTrace.conf.transaction_status_error_enable) {
                TxTrace.checkTxStatus(ctx, tx);
            }
            tx.domain = ctx.http_host_hash;
            tx.referer = ctx.referer;
            tx.httpcCount = ctx.httpc_count;
            tx.httpcTime = ctx.httpc_time;
            tx.status = ctx.status;
            if (ctx.http_method != null) {
                tx.http_method = (byte)WebMethod.names.get(ctx.http_method);
            }
            if (ctx.remoteAddrIPv6) {
                ctx.setExtraField("RemoteIp6", new TextValue(ctx.remoteAddr));
            } else {
                tx.ipaddr = ctx.remoteIp;
            }
            tx.fields = ctx.fields;
            if (ctx.addMeterServiceEnabled) {
                MeterService.getInstance().add(tx);
            }
            if (TxTrace.conf.app_context_enabled) {
                AppCtxStatCollector.getInstance().endTx(ctx.appctx, tx);
                tx.appctx = ctx.appctx;
            }
            profile.oid = secu.OID;
            profile.transaction = tx;
            profile.time = tx.endTime;
            DataProfileAgent.sendProfile(ctx, profile, thro == REJECT);
            if (ReqLogConf.reqlog_enabled) {
                if (ReqLogConf._reqlog_has_httpreq) {
                    TxTrace.reqLogHttpReq(ctx);
                }
                if (ReqLogConf.reqlog_file_enabled) {
                    ReqLogThread.getInstance().add(ctx);
                }
                if (ReqLogConf.reqlog_logsink_enabled) {
                    ReqLogSinkThread.getInstance().add(ctx);
                }
            } else {
                ctx.reset();
            }
        }
        catch (Throwable e) {
            Logger.println("EndTx", 10, e);
        }
    }

    static void errorMessageToTx(TxRecord tx, ErrorArg error) {
        if (ConfTrace.txtext_error_enabled) {
            tx.error_class = error.className;
            if (error.message != null) {
                tx.error_message = error.message.length() > ConfTrace.txtext_error_length ? error.message.substring(0, ConfTrace.txtext_error_length) : error.message;
            }
        }
    }

    private static void reqLogHttpReq(TraceContext ctx) {
        block10: {
            try {
                String cookie;
                int i;
                int len;
                HttpLog reqlog;
                ctx.reqlog = reqlog = new HttpLog();
                reqlog.req_header_key = ReqLogConf.reqlog_header;
                if (reqlog.req_header_key != null) {
                    len = reqlog.req_header_key.length;
                    reqlog.req_header_value = new String[len];
                    for (i = 0; i < len; ++i) {
                        reqlog.req_header_value[i] = ctx.request.getHeader(reqlog.req_header_key[i]);
                    }
                }
                reqlog.req_parameter_key = ReqLogConf.reqlog_parameter;
                if (reqlog.req_parameter_key != null) {
                    len = reqlog.req_parameter_key.length;
                    reqlog.req_parameter_value = new String[len];
                    for (i = 0; i < len; ++i) {
                        reqlog.req_parameter_value[i] = ctx.request.getParameter(reqlog.req_parameter_key[i]);
                    }
                }
                reqlog.req_cookie_key = ReqLogConf.reqlog_cookie;
                if (reqlog.req_cookie_key != null && (cookie = ctx.request.getHeader("Cookie")) != null) {
                    int len2 = reqlog.req_cookie_key.length;
                    reqlog.req_cookie_value = new String[len2];
                    for (int i2 = 0; i2 < len2; ++i2) {
                        reqlog.req_cookie_value[i2] = TxWebUtil.parseCookie(cookie, reqlog.req_cookie_key[i2]);
                    }
                }
                reqlog.resp_header_key = ReqLogConf.reqlog_resp_header;
                if (reqlog.resp_header_key != null) {
                    int len3 = reqlog.resp_header_key.length;
                    reqlog.resp_header_value = new String[len3];
                    for (i = 0; i < len3; ++i) {
                        reqlog.resp_header_value[i] = ctx.response.getHeader(reqlog.resp_header_key[i]);
                    }
                }
            }
            catch (Throwable e) {
                if (!Logger.checkOk("ReqLogHttpReqError", 10) || req_err_log <= 0) break block10;
                --req_err_log;
                Logger.println("ReqLogHttpReqError", e);
            }
        }
    }

    private static void checkTxStatus(TraceContext ctx, TxRecord tx) {
        switch (ctx.status / 100) {
            case 4: 
            case 5: {
                if (TxTrace.conf.status_ignore.contains(ctx.status) || TxTrace.ignoreStatus(ctx.status, ctx.service_hash)) break;
                ErrorArg arg = new ErrorArg();
                arg.exception = WHATAP_ERROR.status_error;
                arg.message = "Status " + ctx.status;
                arg.status = ctx.status;
                arg.setTraceCtx(ctx);
                tx.error = StatError.getInstance().addError(arg);
                tx.errorLevel = (byte)20;
                if (TxTrace.conf.transaction_status_error_mode == 2) {
                    if (TxTrace.conf.status_alert_ignore.contains(ctx.status)) {
                        arg.level = (byte)10;
                    } else if (TxTrace.ignoreStatusAlert(ctx.status, ctx.service_hash)) {
                        arg.level = (byte)10;
                    }
                }
                tx.errorLevel = arg.level;
                TxTrace.errorMessageToTx(tx, arg);
                if (!TxTrace.conf.exception_alert_status_error_enabled) break;
                ExceptionAlert.getInstance().service(ctx, arg);
            }
        }
    }

    private static boolean ignoreStatus(int status, int url) {
        IntSet set = TxTrace.conf.status_ignore_set.get(status);
        if (set == null) {
            return false;
        }
        return set.contains(url);
    }

    private static boolean ignoreStatusAlert(int status, int url) {
        IntSet set = TxTrace.conf.status_alert_ignore_set.get(status);
        if (set == null) {
            return false;
        }
        boolean result = set.contains(url);
        return result;
    }

    public static void doDump(Request request, TraceContext ctx) {
        try {
            Enumeration en = request.getParameterNames();
            if (en != null) {
                int start_time = ctx.getElapsedTime();
                int hash = HashUtil.hash("HTTP-PARAMETERS");
                DataTextAgent.MESSAGE.add(hash, "HTTP-PARAMETERS");
                SecureMsgStep step = new SecureMsgStep();
                step.hash = hash;
                step.start_time = start_time;
                StringBuilder vb = new StringBuilder();
                int count = 0;
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    vb.append(key).append("=").append(StringUtil.limiting(request.getParameter(key), 1024)).append("\n");
                    ++count;
                }
                if (count == 0) {
                    return;
                }
                BYTE crc = new BYTE();
                step.value = TxTrace.encrypt(vb.toString(), crc);
                step.crc = crc.value;
                ctx.profile.addTail(step);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void doDump(Request request, TraceContext ctx, String[] keys) {
        try {
            int start_time = ctx.getElapsedTime();
            int hash = HashUtil.hash("HTTP-PARAMETERS");
            DataTextAgent.MESSAGE.add(hash, "HTTP-PARAMETERS");
            SecureMsgStep step = new SecureMsgStep();
            step.hash = hash;
            step.start_time = start_time;
            StringBuilder vb = new StringBuilder();
            int count = 0;
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                String value = request.getParameter(key);
                if (value == null) continue;
                vb.append(key).append("=").append(StringUtil.limiting(value, 1024)).append("\n");
                ++count;
            }
            if (count == 0) {
                return;
            }
            BYTE crc = new BYTE();
            step.value = TxTrace.encrypt(vb.toString(), crc);
            step.crc = crc.value;
            ctx.profile.addTail(step);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static byte[] encrypt(String p, BYTE crc) {
        if (p.length() == 0) {
            return null;
        }
        byte[] b = p.getBytes();
        b = ParamSecurity.encrypt(b, crc);
        return b;
    }

    private static void addServiceName(TraceContext ctx, Request req) {
        try {
            String v;
            if (!TxTrace.conf._has_transaction_name_key) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            if (TxTrace.conf.trace_transaction_name_key != null && (v = req.getParameter(TxTrace.conf.trace_transaction_name_key)) != null) {
                if (sb.length() == 0) {
                    sb.append(ctx.service_name);
                }
                sb.append('$').append(TxTrace.conf.trace_transaction_name_key).append("=").append(v);
            }
            if (TxTrace.conf.trace_transaction_name_header_key != null && (v = req.getHeader(TxTrace.conf.trace_transaction_name_header_key)) != null) {
                if (sb.length() == 0) {
                    sb.append(ctx.service_name);
                }
                sb.append('$').append(TxTrace.conf.trace_transaction_name_header_key).append("=").append(v);
            }
            if (sb.length() > 0) {
                ctx.service_name = sb.toString();
                ctx.service_hash = HashUtil.hash(ctx.service_name);
            }
        }
        catch (Throwable t) {
            Logger.println("AddTxName", 10, t);
        }
    }

    static boolean isBizExceptionAndStaus(Throwable ex, int status) {
        if (!TxTrace.conf._enable_biz_exceptions_status || status == 0) {
            return false;
        }
        IntSet s = TxTrace.conf.biz_exceptions_status.get(ex.getClass().getName().hashCode());
        if (s == null) {
            return false;
        }
        return s.contains(status);
    }

    static boolean isBizException(Throwable ex) {
        return TxTrace.conf._enable_biz_exceptions && TxTrace.conf.biz_exceptions.contains(ex.getClass().getName().hashCode());
    }

    static boolean isBizException(int errorClassHashCode) {
        return TxTrace.conf._enable_biz_exceptions && TxTrace.conf.biz_exceptions.contains(errorClassHashCode);
    }

    static boolean isIgnoreException(Throwable ex) {
        return TxTrace.conf._enable_ignore_exceptions && TxTrace.conf.ignore_exceptions.contains(ex.getClass().getName().hashCode());
    }

    static boolean isIgnoreExceptionTx(Throwable ex, int serviceHash, String serviceName) {
        if (ex == null) {
            return false;
        }
        if (TxTrace.isIgnoreException(ex)) {
            return true;
        }
        if (!TxTrace.conf._enable_ignore_exception_tx) {
            return false;
        }
        int exHash = ex.getClass().getName().hashCode();
        long key = BitUtil.composite(exHash, serviceHash);
        int val = TxTrace.conf.ignoreExTxMap.get(key);
        switch (val) {
            case 1: {
                return true;
            }
            case -1: {
                return false;
            }
        }
        List<StrMatch> txPatterns = TxTrace.conf.ignore_exception_tx_pattern.get(exHash);
        if (txPatterns == null || txPatterns.size() == 0) {
            TxTrace.conf.ignoreExTxMap.put(key, -1);
            return false;
        }
        for (int i = 0; i < txPatterns.size(); ++i) {
            StrMatch m = txPatterns.get(i);
            if (!m.include(serviceName)) continue;
            TxTrace.conf.ignoreExTxMap.put(key, 1);
            return true;
        }
        TxTrace.conf.ignoreExTxMap.put(key, -1);
        return false;
    }

    public static Error reject(TraceContext ctx) {
        block19: {
            if (ConfThrottle.throttle_enabled) {
                try {
                    if (ctx == null) {
                        return null;
                    }
                    if (ctx.isStaticContents) {
                        return null;
                    }
                    Request req = ctx.request;
                    Response res = ctx.response;
                    if (req == null || res == null) {
                        return null;
                    }
                    if (Throttle.isBlocking(ctx.service_hash, ctx.remoteIp)) {
                        switch (ConfThrottle.throttle_blocked_mode) {
                            case 2: {
                                res.sendRedirect(RejectUtil.getRejectUrl(ConfThrottle.throttle_blocked_forward, ctx));
                                break;
                            }
                            case 1: {
                                res.sendHtml(ConfThrottle.throttle_blocked_html.contents);
                                break;
                            }
                            default: {
                                res.sendMessage(ConfThrottle.throttle_blocked_message);
                            }
                        }
                        TxTrace.endHttpTx(ctx, REJECT);
                        if (ConfThrottle.reject_event_enabled) {
                            Alert.rejected(ctx.service_hash, ctx.service_name, ctx.remoteIp);
                        }
                        return REJECT;
                    }
                    if (TraceContextManager.size() > ConfThrottle.throttle_limit) {
                        if (Throttle.isPassing(ctx.service_hash, ctx.service_name)) {
                            return null;
                        }
                        switch (ConfThrottle.throttle_rejected_mode) {
                            case 2: {
                                res.sendRedirect(RejectUtil.getRejectUrl(ConfThrottle.throttle_rejected_forward, ctx));
                                break;
                            }
                            case 1: {
                                res.sendHtml(ConfThrottle.throttle_rejected_html.contents);
                                break;
                            }
                            default: {
                                res.sendMessage(ConfThrottle.throttle_rejected_message);
                            }
                        }
                        TxTrace.endHttpTx(ctx, REJECT);
                        if (ConfThrottle.reject_event_enabled) {
                            Alert.rejected(ctx.service_hash, ctx.service_name, ctx.remoteIp);
                        }
                        return REJECT;
                    }
                }
                catch (Throwable t) {
                    long now = System.currentTimeMillis();
                    if (now <= last_log + 3600000L) break block19;
                    last_log = now;
                    Logger.println("Reject", 10, "reject exception", t);
                }
            }
        }
        return null;
    }

    public static TraceContext startBranch(TraceContext pctx) {
        if (childThreadProfileHash == 0) {
            childThreadProfileHash = HashUtil.hash("SubTx-Trace");
        }
        DataTextAgent.METHOD.add(childThreadProfileHash, "SubTx-Trace");
        return TxTrace.startChild(pctx, childThreadProfileHash);
    }

    public static TraceContext startBranch(TraceContext pctx, String method) {
        String hashName = "[Trace] " + method;
        if (childThreadProfileHash == 0) {
            childThreadProfileHash = HashUtil.hash(hashName);
        }
        DataTextAgent.METHOD.add(childThreadProfileHash, hashName);
        return TxTrace.startChild(pctx, childThreadProfileHash);
    }

    public static void startChild(TraceContext pctx) {
        if (childThreadProfileHash == 0) {
            childThreadProfileHash = HashUtil.hash("SubTx-Trace");
        }
        DataTextAgent.METHOD.add(childThreadProfileHash, "SubTx-Trace");
        TxTrace.startChild(pctx, childThreadProfileHash);
    }

    public static void startChild(TraceContext pctx, String name) {
        int hash = HashUtil.hash(name);
        DataTextAgent.METHOD.add(hash, name);
        TxTrace.startChild(pctx, hash);
    }

    protected static TraceContext startChild(TraceContext pctx, int threadNameHash) {
        if (pctx == null || pctx.thread == Thread.currentThread()) {
            return null;
        }
        TraceContext ctx = new TraceContext(ConfTrace._trace_collecting_mode);
        ctx.thread = Thread.currentThread();
        ctx.txid = pctx.txid;
        ctx.mtid = pctx.mtid;
        ctx.mtid_build_checked = true;
        ctx.mdepth = pctx.mdepth;
        ctx.service_hash = pctx.service_hash;
        ctx.service_name = pctx.service_name;
        ctx.login = pctx.login;
        if (TxTrace.conf.trace_cpu_endpoint_enabled) {
            ctx.start_cpu = SysJMX.getCurrentThreadCPU();
        }
        if (TxTrace.conf.trace_malloc_endpoint_enabled) {
            ctx.start_malloc = SysJMX.getCurrentThreadAllocBytes();
        }
        ctx.resetStartTime(pctx.getElapsedTime());
        MethodStepX step = new MethodStepX();
        step = new MethodStepX();
        step.hash = threadNameHash;
        ctx.profile.push(step);
        ctx.childStartStep = step;
        TraceContextManager.attach(ctx);
        return ctx;
    }

    public static void endChild(TraceContext pctx) {
        if (pctx == null || pctx.thread == Thread.currentThread()) {
            return;
        }
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx != null) {
            TraceContextManager.detach();
            pctx.httpc_count += ctx.httpc_count;
            pctx.httpc_time += ctx.httpc_time;
            pctx.sql_count += ctx.sql_count;
            pctx.sql_time += ctx.sql_time;
            pctx.rs_count += ctx.rs_count;
            pctx.method_count += ctx.method_count;
            pctx.method_time += ctx.method_time;
            if (ctx.childStartStep != null) {
                ctx.childStartStep.elapsed = ctx.getElapsedTime();
                ctx.profile.pop(ctx.childStartStep);
            }
            pctx.profile.append(ctx.parentOffsetTime, ctx.profile.getSteps());
        }
    }

    public static void endBranch(TraceContext pctx, TraceContext ctx) {
        if (pctx != null && ctx != null) {
            pctx.httpc_count += ctx.httpc_count;
            pctx.httpc_time += ctx.httpc_time;
            pctx.sql_count += ctx.sql_count;
            pctx.sql_time += ctx.sql_time;
            pctx.rs_count += ctx.rs_count;
            pctx.method_count += ctx.method_count;
            pctx.method_time += ctx.method_time;
            if (ctx.childStartStep != null) {
                ctx.childStartStep.elapsed = ctx.getElapsedTime();
                ctx.profile.pop(ctx.childStartStep);
            }
            pctx.profile.append(ctx.parentOffsetTime, ctx.profile.getSteps());
        }
    }

    public static TraceContext getTraceContext() {
        return TraceContextManager.getLocalContext();
    }

    public static void setRatedMtraceKey(TraceContext ctx) {
        TraceHttpc.setRatedMtraceKey(ctx);
    }

    public static TraceContext startTx(String name, String className, String methodName, String methodDesc, Object _this, Object[] arg) {
        if (!TxTrace.conf.transaction_enabled) {
            return null;
        }
        if (ConfTrace.trace_sampling_enabled) {
            if (sampling.get() != null) {
                return null;
            }
            if (!TraceSamplingManager.traceOk()) {
                sampling.set("off");
                return TraceContext.sampling();
            }
        }
        try {
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (TraceContext.isActivated(ctx)) {
                return null;
            }
            switch (TxTrace.conf.service_name_mode) {
                case 5: {
                    name = AsmUtil.makeMethodFullName(className, methodName, methodDesc);
                    break;
                }
                case 1: {
                    name = className;
                    break;
                }
                case 2: {
                    name = methodName;
                    break;
                }
                case 3: {
                    name = ServiceNameMode.getFirstString(arg);
                    break;
                }
                case 4: {
                    name = ServiceNameMode.getIndex(TxTrace.conf.service_name_index, arg);
                }
            }
            ctx = TxTrace._serviceStartRealTx(name);
            PluginAppServiceStart.process(ctx, new HookArgs(className, methodName, methodDesc, _this, arg));
            return ctx;
        }
        catch (Throwable t) {
            Logger.println("ServiceTx", 10, t);
            return null;
        }
    }

    public static TraceContext startTx(String name) {
        if (!TxTrace.conf.transaction_enabled) {
            return null;
        }
        if (ConfTrace.trace_sampling_enabled) {
            if (sampling.get() != null) {
                return null;
            }
            if (!TraceSamplingManager.traceOk()) {
                sampling.set("off");
                return TraceContext.sampling();
            }
        }
        try {
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (TraceContext.isActivated(ctx)) {
                return null;
            }
            ctx = TxTrace._serviceStartRealTx(name);
            if (TxTrace.conf.app_context_enabled) {
                ctx.appctx = AppCtxStatCollector.getContextPath(ctx.service_hash, ctx.service_name, ctx);
            }
            PluginAppServiceStart.process(ctx, new HookArgs("", "", "", "", new Object[0]));
            return ctx;
        }
        catch (Throwable t) {
            Logger.println("ServiceTx", 10, t);
            return null;
        }
    }

    public static TraceContext startScheduledTx(String name) {
        if (!TxTrace.conf.transaction_enabled) {
            return null;
        }
        if (ConfTrace.trace_sampling_enabled) {
            if (sampling.get() != null) {
                return null;
            }
            if (!TraceSamplingManager.traceOk()) {
                sampling.set("off");
                return TraceContext.sampling();
            }
        }
        try {
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (TraceContext.isActivated(ctx)) {
                return null;
            }
            ctx = TxTrace._serviceStartScheduledTx(name);
            if (TxTrace.conf.app_context_enabled) {
                ctx.appctx = AppCtxStatCollector.getContextPath(ctx.service_hash, ctx.service_name, ctx);
            }
            PluginAppServiceStart.process(ctx, new HookArgs("", "", "", "", new Object[0]));
            return ctx;
        }
        catch (Throwable t) {
            Logger.println("ServiceTx", 10, t);
            return null;
        }
    }

    protected static TraceContext _serviceStartScheduledTx(String name) {
        ++TxTrace.meter.arrival;
        TraceContext ctx = TxTrace.startTrace(name);
        ctx.setIsScheduled(true);
        TraceContextManager.start(ctx);
        return ctx;
    }

    protected static TraceContext _serviceStartRealTx(String name) {
        ++TxTrace.meter.arrival;
        TraceContext ctx = TxTrace.startTrace(name);
        TraceContextManager.start(ctx);
        return ctx;
    }

    private static TraceContext startTrace(String name) {
        TraceContext ctx = new TraceContext(ConfTrace._trace_collecting_mode);
        ctx.thread = Thread.currentThread();
        ctx.service_hash = HashUtil.hash(name);
        ctx.service_name = name;
        ctx.resetStartTime();
        if (TxTrace.conf.trace_cpu_endpoint_enabled) {
            ctx.start_cpu = SysJMX.getCurrentThreadCPU();
        }
        if (TxTrace.conf.trace_malloc_endpoint_enabled) {
            ctx.start_malloc = SysJMX.getCurrentThreadAllocBytes();
        }
        ctx.txid = KeyGen.next();
        return ctx;
    }

    public static void endTx(TraceContext ctx, Throwable thro) {
        try {
            if (ConfTrace.trace_sampling_enabled && ctx != null && ctx.isFake()) {
                sampling.set(null);
                return;
            }
            if (TraceContext.isNullOrClosed(ctx)) {
                return;
            }
            TxTrace._serviceEndRealTx(ctx, null, thro);
        }
        catch (Throwable t) {
            Logger.println("EndTx", 10, t);
        }
    }

    public static void endTx(TraceContext ctx, Object rtn, Throwable thro) {
        try {
            if (ConfTrace.trace_sampling_enabled && ctx != null && ctx.isFake()) {
                sampling.set(null);
                return;
            }
            if (TraceContext.isNullOrClosed(ctx)) {
                return;
            }
            TxTrace._serviceEndRealTx(ctx, rtn, thro);
        }
        catch (Throwable t) {
            Logger.println("EndTx", 10, t);
        }
    }

    public static void endTxAnyway(TraceContext ctx, Throwable thro) {
        try {
            if (TraceContext.isNullOrClosed(ctx)) {
                return;
            }
            TxTrace._serviceEndRealTx(ctx, null, thro);
        }
        catch (Throwable t) {
            Logger.println("EndTxAnyway", 10, t);
        }
    }

    protected static void _serviceEndRealTx(TraceContext ctx, Object rtn, Throwable thr) {
        ctx.close();
        ctx.handleEndTxErrorStack(thr);
        if (ConfTrace.trace_exception_overwrite_enabled && ctx.exception != null && ctx.error != null && ctx.exception != ctx.error.exception) {
            ctx.error = null;
        }
        String name = null;
        switch (TxTrace.conf.service_name_mode) {
            case 6: {
                if (rtn == null) {
                    name = "null";
                    break;
                }
                ctx.service_name = name = rtn.toString();
                ctx.service_hash = HashUtil.hash(ctx.service_name);
            }
        }
        if (ConfTrace.trace_thread_id_enabled && ctx.thread != null) {
            ctx.setExtraField("threadId", new DecimalValue(ctx.thread.getId()));
        }
        if (ConfTrace.trace_thread_name_enabled && ctx.thread != null) {
            ctx.setExtraField("threadName", new TextValue(ctx.thread.getName()));
        }
        PluginAppServiceEnd.process(ctx, rtn);
        TraceContextManager.end(ctx.txid);
        boolean isNew = DataTextAgent.SERVICE.add(ctx.service_hash, ctx.service_name);
        ProfilePack profile = new ProfilePack();
        TxRecord tx = new TxRecord();
        tx.txid = ctx.txid;
        if (ConfTrace.txtext_txname_enabled) {
            tx.txName = ctx.service_name;
        }
        tx.wclientId = ctx.wclientId;
        tx.cipher = ParamSecurity.keyHash;
        tx.userAgent = ctx.userAgent;
        tx.mcaller_pcode = ctx.mcaller_pcode;
        tx.mcaller_okind = ctx.mcaller_okind;
        tx.mcaller_oid = ctx.mcaller_oid;
        tx.custid = ctx.custid;
        tx.mtid = ctx.mtid;
        tx.mdepth = ctx.mdepth;
        tx.mcaller = ctx.mcaller_txid;
        tx.mcallerStepId = ctx.mcaller_stepId;
        if (ConfTrace.trace_origin_url_enabled) {
            tx.originUrl = ctx.origin_url;
        }
        tx.endTime = ctx.endTime = DateUtil.currentTime();
        tx.elapsed = ctx.elapsed = ctx.getElapsedTime();
        if (tx.elapsed < 0) {
            ctx.elapsed = 0;
            tx.elapsed = 0;
        }
        tx.service = ctx.service_hash;
        if (ctx.start_cpu > 0L) {
            tx.cpuTime = (int)(SysJMX.getCurrentThreadCPU() - ctx.start_cpu);
        }
        if (ctx.start_malloc > 0L) {
            tx.malloc = SysJMX.getCurrentThreadAllocBytes() - ctx.start_malloc;
        }
        tx.sqlCount = ctx.sql_count;
        tx.sqlTime = ctx.sql_time;
        tx.sqlFetchCount = ctx.rs_count;
        tx.sqlFetchTime = (int)ctx.rs_time;
        tx.dbcTime = ctx.dbc_time;
        tx.methodCount = ctx.method_count;
        tx.methodTime = ctx.method_time;
        if (ctx.error != null) {
            tx.error = ctx.error.txErrorCode;
            tx.errorLevel = ctx.error.level;
            if (TxTrace.isBizException(ctx.error.className.hashCode())) {
                tx.errorLevel = (byte)10;
            }
            TxTrace.errorMessageToTx(tx, ctx.error);
        } else if (ctx.exception != null && !TxTrace.isIgnoreExceptionTx(ctx.exception, ctx.service_hash, ctx.service_name)) {
            ErrorArg arg = new ErrorArg();
            arg.exception = ctx.exception;
            arg.message = ctx.exception.getMessage();
            arg.status = ctx.status;
            arg.setTraceCtx(ctx);
            tx.error = StatError.getInstance().addError(arg);
            if (TxTrace.isBizException(ctx.exception) || TxTrace.isBizExceptionAndStaus(ctx.exception, ctx.status)) {
                tx.errorLevel = (byte)10;
            } else {
                tx.errorLevel = (byte)20;
                ExceptionAlert.getInstance().service(ctx, arg);
            }
            TxTrace.errorMessageToTx(tx, arg);
        } else if (ctx.unclosedConnMap != null && ctx.unclosedConnMap.size() > 0) {
            ErrorArg arg = new ErrorArg();
            arg.exception = WHATAP_ERROR.connection_not_close;
            arg.message = WHATAP_ERROR.connection_not_close.getMessage();
            arg.status = ctx.status;
            arg.setTraceCtx(ctx);
            StackTraceElement[] stack = ctx.unclosedConnMap.entries().nextElement().getValue();
            tx.error = StatError.getInstance().addJdbcLeak(arg, stack);
            tx.errorLevel = (byte)20;
            TxTrace.errorMessageToTx(tx, arg);
        } else if (ctx.unclosedStmtMap != null && ctx.unclosedStmtMap.size() > 0) {
            ErrorArg arg = new ErrorArg();
            arg.exception = WHATAP_ERROR.stmt_not_close;
            arg.message = WHATAP_ERROR.stmt_not_close.getMessage();
            arg.status = ctx.status;
            arg.setTraceCtx(ctx);
            StackTraceElement[] stack = ctx.unclosedStmtMap.entries().nextElement().getValue();
            tx.error = StatError.getInstance().addJdbcLeak(arg, stack);
            tx.errorLevel = (byte)20;
            TxTrace.errorMessageToTx(tx, arg);
        } else if (ctx.customLeak > 0) {
            ErrorArg arg = new ErrorArg();
            arg.exception = WHATAP_ERROR.custom_leak;
            arg.message = WHATAP_ERROR.custom_leak.getMessage();
            arg.status = ctx.status;
            arg.setTraceCtx(ctx);
            tx.error = StatError.getInstance().addError(arg);
            tx.errorLevel = (byte)20;
            TxTrace.errorMessageToTx(tx, arg);
        }
        tx.domain = ctx.http_host_hash;
        tx.referer = ctx.referer;
        tx.httpcCount = ctx.httpc_count;
        tx.httpcTime = ctx.httpc_time;
        if (ctx.remoteAddrIPv6) {
            ctx.setExtraField("RemoteIp6", new TextValue(ctx.remoteAddr));
        } else {
            tx.ipaddr = ctx.remoteIp;
        }
        tx.fields = ctx.fields;
        MeterService.getInstance().add(tx);
        if (TxTrace.conf.app_context_enabled) {
            AppCtxStatCollector.getInstance().endTx(ctx.appctx, tx);
            tx.appctx = ctx.appctx;
        }
        profile.oid = SecurityMaster.getInstance().OID;
        profile.transaction = tx;
        profile.time = tx.endTime;
        DataProfileAgent.sendProfile(ctx, profile, thr == REJECT);
        ctx.reset();
    }

    public static void error(Throwable e) {
        if (e == null) {
            return;
        }
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx != null) {
            ctx.handleEndTxErrorStack(e);
        }
    }

    public static void startLog(TraceContext ctx, Class class1) {
        if (ctx != null) {
            if (ctx.request != null) {
                Logger.println(AnsiPrint.red("http tx start " + class1.getSimpleName() + " txid=" + ctx.txid + " " + Thread.currentThread().getName()));
            } else {
                Logger.println(AnsiPrint.red("service tx start " + class1.getSimpleName() + " txid=" + ctx.txid + " " + Thread.currentThread().getName()));
            }
        }
    }

    public static void endLog(TraceContext ctx, String title) {
        Logger.println(AnsiPrint.green(title + " txid=" + ctx.txid + " " + Thread.currentThread().getName()));
    }

    public static void endLog(TraceContext ctx, Class class1) {
        Logger.println(AnsiPrint.green("end tx " + class1.getSimpleName() + " txid=" + ctx.txid + " " + Thread.currentThread().getName()));
    }

    static {
        childThreadProfileHash = 0;
        sampling = new ThreadLocal();
    }
}

