/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.api.trace;

import whatap.agent.Logger;
import whatap.agent.conf.ConfTrace;
import whatap.agent.counter.meter.MeterSQL;
import whatap.agent.data.DataTextAgent;
import whatap.agent.stat.ErrorArg;
import whatap.agent.stat.StatError;
import whatap.agent.stat.StatSql;
import whatap.agent.trace.ParsedSql;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.trace.sql.TraceSQL;
import whatap.lang.ref.BYTE;
import whatap.lang.step.DBCStep;
import whatap.lang.step.ResultSetStep;
import whatap.lang.step.SqlStepX;
import whatap.notice.WHATAP_ERROR;
import whatap.util.HashUtil;
import whatap.util.StringUtil;

public class TxSql {
    static int logcount;
    static long last_log;

    public static SqlStepX sql(TraceContext ctx, String dbhost, String sql, String param, int elapsed, Throwable thr) {
        int dbhash = 0;
        if (dbhost != null && dbhost.length() > 0) {
            int dbc_hash = HashUtil.hash(dbhost);
            DataTextAgent.dbc(dbc_hash, dbhost);
            dbhash = dbc_hash;
        }
        return TxSql.sql(ctx, dbhash, sql, param, elapsed, thr);
    }

    public static SqlStepX sql(TraceContext ctx, int dbc_hash, String sql, String param, int elapsed, Throwable thr) {
        SqlStepX step;
        block6: {
            step = new SqlStepX();
            try {
                ErrorArg arg;
                step.dbc = dbc_hash;
                ParsedSql psql = TraceSQL.escapeLiteral(sql);
                step.hash = psql.sqlHash;
                step.xtype = (byte)48;
                if (ConfTrace.trace_sql_param_enabled) {
                    BYTE crc = new BYTE();
                    step.p1 = TraceSQL.toParamBytes(psql.param, crc);
                    step.p2 = TraceSQL.toParamBytes(param, crc);
                    step.pcrc = crc.value;
                }
                step.start_time = ctx.getElapsedTime();
                step.elapsed = elapsed;
                if (thr != null) {
                    arg = new ErrorArg();
                    arg.exception = thr;
                    arg.message = thr.getMessage();
                    arg.setTraceCtx(ctx);
                    arg.appendSql(step.hash);
                    step.error = StatError.getInstance().addError(arg);
                    ctx.handleSqlErrorStack(thr);
                } else if (step.elapsed > ConfTrace.trace_error_sql_time_max) {
                    arg = new ErrorArg();
                    arg.exception = WHATAP_ERROR.slow_sql;
                    arg.message = WHATAP_ERROR.slow_sql.getMessage();
                    arg.setTraceCtx(ctx);
                    arg.appendSql(step.hash);
                    step.error = StatError.getInstance().addError(arg);
                }
                MeterSQL.getInstance().add(step.dbc, step.elapsed, step.error != 0L);
                StatSql.getInstance().addSqlTime(ctx.service_hash, ctx.txid, step.dbc, step.hash, step.elapsed, step.error != 0L);
                ++ctx.sql_count;
                ctx.sql_time += step.elapsed;
                ctx.profile.add(step);
            }
            catch (Throwable t) {
                if (logcount >= 5) break block6;
                ++logcount;
                Logger.println("Trace SQL", t);
            }
        }
        return step;
    }

    public static SqlStepX nosql(TraceContext ctx, String dbconn, String sql, String param, int elapsed, Throwable thr) {
        SqlStepX step;
        block6: {
            step = new SqlStepX();
            try {
                if (StringUtil.isEmpty(sql)) {
                    return step;
                }
                if (StringUtil.isNotEmpty(dbconn)) {
                    step.dbc = HashUtil.hash(dbconn);
                    DataTextAgent.dbc(step.dbc, dbconn);
                }
                step.hash = HashUtil.hash(sql);
                DataTextAgent.SQL.add(step.hash, sql);
                if (ConfTrace.trace_sql_param_enabled && StringUtil.isNotEmpty(param)) {
                    BYTE crc = new BYTE();
                    step.p2 = TraceSQL.toParamBytes(param, crc);
                    step.pcrc = crc.value;
                }
                step.start_time = ctx.getElapsedTime();
                step.elapsed = elapsed;
                if (thr != null) {
                    ErrorArg arg = new ErrorArg();
                    arg.exception = thr;
                    arg.message = thr.getMessage();
                    arg.setTraceCtx(ctx);
                    arg.appendSql(step.hash);
                    step.error = StatError.getInstance().addError(arg);
                    ctx.handleSqlErrorStack(thr);
                }
                ++ctx.sql_count;
                ctx.sql_time += step.elapsed;
                ctx.profile.add(step);
            }
            catch (Throwable t) {
                if (logcount >= 5) break block6;
                ++logcount;
                Logger.println("Trace NOSQL", t);
            }
        }
        return step;
    }

    public static void fetch(TraceContext ctx, int dbc, int sqlhash, int rs_count, int rs_time) {
        try {
            ResultSetStep p = new ResultSetStep();
            p.dbc = dbc;
            p.sqlhash = sqlhash;
            p.start_time = ctx.getElapsedTime();
            p.fetch = rs_count;
            p.elapsed = rs_time;
            ctx.profile.add(p);
            if (rs_count > ConfTrace.trace_error_jdbc_fetch_max) {
                ErrorArg arg = new ErrorArg();
                arg.exception = WHATAP_ERROR.too_many_records;
                arg.message = WHATAP_ERROR.too_many_records.getMessage();
                arg.setTraceCtx(ctx);
                arg.appendSql(sqlhash);
                StatError.getInstance().addError(arg);
            }
            ctx.rs_time += (long)rs_time;
            ctx.rs_count += rs_count;
            MeterSQL.getInstance().addFetch(p.dbc, p.fetch, p.elapsed);
            StatSql.getInstance().addFetch(ctx.service_hash, p.dbc, sqlhash, p.fetch, p.elapsed);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void dbc(String connUrl, int elapsed) {
        try {
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (ctx == null) {
                return;
            }
            DBCStep step = new DBCStep();
            int dbc_hash = HashUtil.hash(connUrl);
            DataTextAgent.dbc(dbc_hash, connUrl);
            step.hash = dbc_hash;
            step.start_time = ctx.getElapsedTime() - elapsed;
            step.elapsed = elapsed;
            ctx.profile.add(step);
        }
        catch (Throwable t) {
            Logger.println("Trace DB Connection", 10, "dbc open internal error ", t);
        }
    }

    static {
        last_log = System.currentTimeMillis();
    }
}

