/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.api.trace;

import whatap.agent.api.trace.TxMethodCtx;
import whatap.agent.api.trace.TxTrace;
import whatap.agent.conf.ConfTrace;
import whatap.agent.control.dyna.DynaBCIMethod;
import whatap.agent.data.DataTextAgent;
import whatap.agent.trace.AutoServiceStartAnalyzer;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.lang.step.MessageStep;
import whatap.lang.step.MethodStepX;
import whatap.util.HashUtil;
import whatap.util.ThreadUtil;

public class TxMethod {
    public static TxMethodCtx start(String name) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return null;
        }
        int hash = HashUtil.hash(name);
        DataTextAgent.METHOD.add(hash, name);
        MethodStepX step = new MethodStepX();
        step.start_time = ctx.getElapsedTime();
        step.hash = hash;
        ctx.profile.push(step);
        return new TxMethodCtx(ctx, step);
    }

    public static TxMethodCtx start(TraceContext ctx, int hash, String name) {
        if (ctx == null) {
            return null;
        }
        DataTextAgent.METHOD.add(hash, name);
        MethodStepX step = new MethodStepX();
        step.start_time = ctx.getElapsedTime();
        step.hash = hash;
        ctx.profile.push(step);
        return new TxMethodCtx(ctx, step);
    }

    public static TxMethodCtx start(int hash, String name) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            if (DynaBCIMethod.isAutoTxStart && (ctx = TxTrace.startTx(name)) != null) {
                if (DynaBCIMethod.isAutoTxBackstack) {
                    String stack = ThreadUtil.getStackTrace(Thread.currentThread().getStackTrace(), 2);
                    AutoServiceStartAnalyzer.put(name, stack);
                    MessageStep m = new MessageStep();
                    m.hash = HashUtil.hash("TRANSACTION BACKSTACK");
                    DataTextAgent.MESSAGE.add(m.hash, "TRANSACTION BACKSTACK");
                    m.desc = stack;
                    ctx.profile.add(m);
                }
                return new TxMethodCtx(ctx, null);
            }
            return null;
        }
        DataTextAgent.METHOD.add(hash, name);
        MethodStepX step = new MethodStepX();
        step.start_time = ctx.getElapsedTime();
        step.hash = hash;
        ctx.profile.push(step);
        return new TxMethodCtx(ctx, step);
    }

    public static void end(TxMethodCtx mctx, Throwable thr) {
        if (mctx != null) {
            if (mctx.step == null) {
                TxTrace.endTx(mctx.ctx, thr);
                return;
            }
            TraceContext ctx = mctx.ctx;
            MethodStepX step = mctx.step;
            ctx.handleMethodErrorStack(thr);
            step.elapsed = ctx.getElapsedTime() - step.start_time;
            ctx.profile.pop(step);
            ++ctx.method_count;
            ctx.method_time += step.elapsed;
        }
    }

    public static int addMethodName(String name) {
        int hash = HashUtil.hash(name);
        DataTextAgent.METHOD.add(hash, name);
        return hash;
    }

    public static int hash(String name) {
        return HashUtil.hash(name);
    }

    public static void reactor(String className, int hash, String name) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return;
        }
        ++ctx.method_count;
        if (ctx.reactor_exec_count >= ConfTrace.trace_reactor_count) {
            return;
        }
        ++ctx.reactor_exec_count;
        MethodStepX step = new MethodStepX();
        step.start_time = ctx.getElapsedTime();
        step.hash = hash;
        ctx.profile.add(step);
        DataTextAgent.METHOD.add(step.hash, name);
    }

    public static void method(int hash, String name, Throwable thr, int elapsed) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return;
        }
        if (thr != null) {
            ctx.handleMethodErrorStack(thr);
        }
        MethodStepX step = new MethodStepX();
        step.start_time = ctx.getElapsedTime();
        step.hash = hash;
        step.elapsed = elapsed;
        DataTextAgent.METHOD.add(step.hash, name);
        ctx.profile.add(step);
        ++ctx.method_count;
        ctx.method_time += step.elapsed;
    }

    public static void method(String name, Throwable thr, int elapsed) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return;
        }
        if (thr != null) {
            ctx.handleMethodErrorStack(thr);
        }
        MethodStepX step = new MethodStepX();
        step.start_time = ctx.getElapsedTime();
        step.hash = HashUtil.hash(name);
        step.elapsed = elapsed;
        DataTextAgent.METHOD.add(step.hash, name);
        ctx.profile.add(step);
        ++ctx.method_count;
        ctx.method_time += step.elapsed;
    }

    public static void method(TraceContext ctx, String name, Throwable thr, int elapsed) {
        if (ctx == null) {
            return;
        }
        if (thr != null) {
            ctx.handleMethodErrorStack(thr);
        }
        MethodStepX step = new MethodStepX();
        step.start_time = ctx.getElapsedTime();
        step.hash = HashUtil.hash(name);
        step.elapsed = elapsed;
        DataTextAgent.METHOD.add(step.hash, name);
        ctx.profile.add(step);
    }

    public static void method(TraceContext ctx, String name, int elapsed) {
        if (ctx == null) {
            return;
        }
        MethodStepX step = new MethodStepX();
        step.start_time = ctx.getElapsedTime();
        step.hash = HashUtil.hash(name);
        step.elapsed = elapsed;
        DataTextAgent.METHOD.add(step.hash, name);
        ctx.profile.add(step);
        ++ctx.method_count;
        ctx.method_time += step.elapsed;
    }

    public static void method(TraceContext ctx, int methodHash, String methodName, int elapsed) {
        if (ctx == null) {
            return;
        }
        MethodStepX step = new MethodStepX();
        step.start_time = ctx.getElapsedTime();
        step.hash = methodHash;
        step.elapsed = elapsed;
        DataTextAgent.METHOD.add(step.hash, methodName);
        ctx.profile.add(step);
        ++ctx.method_count;
        ctx.method_time += step.elapsed;
    }

    public static TxMethodCtx startComponent(int hash, String component) {
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return null;
        }
        DataTextAgent.METHOD.add(hash, component);
        MethodStepX step = new MethodStepX();
        step.start_time = ctx.getElapsedTime();
        step.hash = hash;
        step.component = component;
        ctx.profile.push(step);
        return new TxMethodCtx(ctx, step);
    }

    public static void endComponent(TxMethodCtx mctx, Throwable thr) {
        if (mctx != null) {
            TraceContext ctx = mctx.ctx;
            MethodStepX step = mctx.step;
            if (thr != null) {
                step.exception = thr.toString();
                ctx.handleMethodErrorStack(thr);
            }
            step.elapsed = ctx.getElapsedTime() - step.start_time;
            ctx.profile.pop(step);
            ++ctx.method_count;
            ctx.method_time += step.elapsed;
        }
    }
}

