/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.api.trace;

import whatap.agent.Configure;
import whatap.agent.Logger;
import whatap.agent.api.trace.HttpCallSpec;
import whatap.agent.conf.ConfTrace;
import whatap.agent.counter.meter.MeterHTTPC;
import whatap.agent.data.DataTextAgent;
import whatap.agent.stat.StatHttpc;
import whatap.agent.trace.BuildPos;
import whatap.agent.trace.HttpcContext;
import whatap.agent.trace.LogSinkRemoteAccessStatus;
import whatap.agent.trace.TraceContext;
import whatap.agent.trace.TraceContextManager;
import whatap.agent.trace.TraceHttpc;
import whatap.lang.step.HttpcStepX;
import whatap.util.HashUtil;
import whatap.util.SysJMX;

public class TxHttpC {
    static Configure conf = Configure.getInstance();

    @Deprecated
    public static Object startHttpc(String host, int port, String url) {
        return TxHttpC.startHttpCall(host, port, url);
    }

    public static HttpcContext startHttpCall(String host, int port, String url) {
        try {
            if (!TxHttpC.conf.httpc_enabled) {
                return null;
            }
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (ctx == null) {
                return null;
            }
            return TxHttpC.startRealHttpCall(new HttpCallSpec(host, port, url), ctx);
        }
        catch (Throwable t) {
            Logger.println("A126", 10, t);
            return null;
        }
    }

    public static HttpcContext startHttpCall(HttpCallSpec spec) {
        try {
            if (!TxHttpC.conf.httpc_enabled) {
                return null;
            }
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (TraceContext.isNullOrClosed(ctx) || spec == null) {
                return null;
            }
            return TxHttpC.startRealHttpCall(spec, ctx);
        }
        catch (Throwable t) {
            Logger.println("HttpC101", 10, t);
            return null;
        }
    }

    public static HttpcContext startHttpCall(HttpCallSpec spec, boolean ignoreIfNested) {
        try {
            if (!TxHttpC.conf.httpc_enabled) {
                return null;
            }
            TraceContext ctx = TraceContextManager.getLocalContext();
            if (TraceContext.isNullOrClosed(ctx) || spec == null) {
                return null;
            }
            if (ignoreIfNested && ctx.active_httpc_hash != 0) {
                return null;
            }
            return TxHttpC.startRealHttpCall(spec, ctx);
        }
        catch (Throwable t) {
            Logger.println("HttpC101", 10, t);
            return null;
        }
    }

    public static HttpcContext startHttpCall(HttpCallSpec spec, TraceContext ctx) {
        try {
            if (!TxHttpC.conf.httpc_enabled) {
                return null;
            }
            if (TraceContext.isNullOrClosed(ctx) || spec == null) {
                return null;
            }
            return TxHttpC.startRealHttpCall(spec, ctx);
        }
        catch (Throwable t) {
            Logger.println("HttpC101", 10, t);
            return null;
        }
    }

    protected static HttpcContext startRealHttpCall(HttpCallSpec call, TraceContext ctx) {
        String host;
        ctx.httpc_url = call.url;
        ctx.httpc_host = call.host;
        ctx.httpc_port = call.port;
        HttpcStepX step = new HttpcStepX();
        step.start_time = ctx.getElapsedTime();
        step.driver = call.driver;
        step.stepId = call.stepId;
        step.param = call.parameter;
        if (call.url != null) {
            step.url = HashUtil.hash(call.url);
            DataTextAgent.HTTPC_URL.add(step.url, call.url);
        }
        if (TxHttpC.conf.httpc_hostport_enabled && ctx.httpc_port > 0) {
            ctx.httpc_host = host = call.host + ":" + ctx.httpc_port;
            ctx.httpc_port = 0;
        } else {
            host = call.host;
            step.port = ctx.httpc_port;
        }
        if (host != null) {
            step.host = ctx.httpc_host_hash = HashUtil.hash(host);
            DataTextAgent.HTTPC_HOST.add(step.host, host);
        }
        if (ConfTrace.trace_httpc_resource_enabled) {
            if (TxHttpC.conf.trace_cpu_step_enabled) {
                step.start_cpu = (int)(SysJMX.getCurrentThreadCPU() - ctx.start_cpu);
            }
            if (TxHttpC.conf.trace_malloc_step_enabled) {
                step.start_mem = (int)(SysJMX.getCurrentThreadAllocBytes() - ctx.start_malloc);
            }
        }
        if (ConfTrace._trace_position_httpc_hash != 0) {
            BuildPos.profileHttpcPos(step, ctx.httpc_url);
        }
        ctx.profile.push(step);
        ctx.active_httpc_hash = step.url;
        ctx.httpc_stime = step.start_time;
        return new HttpcContext(ctx, step, null, null);
    }

    public static void endHttpc(Object stat, int status, String status_reason, Throwable thr) {
        try {
            TxHttpC.endHttpCall((HttpcContext)stat, status, status_reason, thr);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void endHttpCall(Object stat, int status, String status_reason, Throwable thr) {
        try {
            TxHttpC.endHttpCall((HttpcContext)stat, status, status_reason, thr);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void endHttpCall(HttpcContext httpcContext, int status, String status_reason, Throwable thr) {
        try {
            if (httpcContext == null) {
                return;
            }
            TraceContext ctx = httpcContext.context;
            HttpcStepX step = (HttpcStepX)httpcContext.step;
            step.status = status;
            if (TxHttpC.conf.httpc_status_error_enable) {
                TraceHttpc.checkStatusAndError(ctx, step, status_reason, thr);
            }
            if (step.status == 0 && thr != null) {
                TraceHttpc.handleHttpcExceptionError(ctx, step, thr);
            }
            step.elapsed = ctx.getElapsedTime() - step.start_time;
            if (step.elapsed < 0) {
                step.elapsed = 0;
            }
            if (step.error == 0L && step.elapsed > ConfTrace.trace_error_httpc_time_max) {
                TraceHttpc.handleHttpcSlowError(ctx, step);
            }
            if (step.error == 0L) {
                LogSinkRemoteAccessStatus.httpOk(ctx.httpc_host, step);
            }
            MeterHTTPC.getInstance().add(step.host, step.elapsed, step.error != 0L);
            StatHttpc.getInstance().addHttpcTime(ctx.service_hash, step.url, step.host, step.port, step.elapsed, step.error != 0L);
            ctx.active_httpc_hash = 0;
            ctx.httpc_url = null;
            ctx.httpc_host = null;
            ctx.httpc_host_hash = 0;
            ctx.httpc_stime = 0;
            ++ctx.httpc_count;
            ctx.httpc_time += step.elapsed;
            ctx.profile.pop(step);
        }
        catch (Throwable t) {
            Logger.println("A127", 10, t);
        }
    }

    public static void trace(String host, int port, String url, int elapsed, int status, String status_reason, Throwable thr) {
        if (!TxHttpC.conf.httpc_enabled) {
            return;
        }
        TraceContext ctx = TraceContextManager.getLocalContext();
        if (ctx == null) {
            return;
        }
        TxHttpC.doTrace(ctx, host, port, url, elapsed, status, status_reason, thr);
    }

    public static void trace(TraceContext ctx, String host, int port, String url, int elapsed, int status, String status_reason, Throwable thr) {
        if (!TxHttpC.conf.httpc_enabled) {
            return;
        }
        if (ctx != null) {
            TxHttpC.doTrace(ctx, host, port, url, elapsed, status, status_reason, thr);
        }
    }

    protected static void doTrace(TraceContext ctx, String host, int port, String url, int elapsed, int status, String status_reason, Throwable thr) {
        try {
            if (url == null) {
                url = "/";
            }
            if (host == null) {
                host = "";
            }
            HttpcStepX step = new HttpcStepX();
            step.start_time = ctx.getElapsedTime();
            step.url = HashUtil.hash(url);
            DataTextAgent.HTTPC_URL.add(step.url, url);
            if (TxHttpC.conf.httpc_hostport_enabled && port > 0) {
                host = host + ":" + port;
            } else {
                step.port = port;
            }
            step.host = HashUtil.hash(host);
            DataTextAgent.HTTPC_HOST.add(step.host, host);
            step.status = status;
            step.elapsed = elapsed;
            if (TxHttpC.conf.httpc_status_error_enable) {
                TraceHttpc.checkStatusAndError(ctx, step, status_reason, thr);
            }
            if (step.error == 0L && step.elapsed > ConfTrace.trace_error_httpc_time_max) {
                TraceHttpc.handleHttpcSlowError(ctx, step);
            }
            MeterHTTPC.getInstance().add(step.host, step.elapsed, step.error != 0L);
            StatHttpc.getInstance().addHttpcTime(ctx.service_hash, step.url, step.host, step.port, step.elapsed, step.error != 0L);
            ++ctx.httpc_count;
            ctx.httpc_time += step.elapsed;
            ctx.profile.add(step);
        }
        catch (Throwable t) {
            Logger.println("A127", 10, t);
        }
    }
}

