/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent.api.stat;

import java.util.Enumeration;
import whatap.lang.value.MapValue;
import whatap.lang.value.Value;
import whatap.util.StringFloatLinkedMap;
import whatap.util.StringKeyLinkedMap;
import whatap.util.StringLongLinkedMap;

public class Record {
    public StringLongLinkedMap longFields = new StringLongLinkedMap().setMax(128);
    public StringFloatLinkedMap floatFields = new StringFloatLinkedMap().setMax(128);
    public StringKeyLinkedMap<Value> otherFields = new StringKeyLinkedMap().setMax(128);
    public long lastUpdate;

    public boolean isEmpty() {
        return this.longFields.size() + this.floatFields.size() + this.otherFields.size() == 0;
    }

    public void setTo(MapValue m) {
        this.setLong(m);
        this.setFloat(m);
        this.setOther(m);
    }

    private void setLong(MapValue m) {
        if (this.longFields.size() == 0) {
            return;
        }
        Enumeration<StringLongLinkedMap.StringLongLinkedEntry> en = this.longFields.entries();
        while (en.hasMoreElements()) {
            StringLongLinkedMap.StringLongLinkedEntry ent = en.nextElement();
            m.put(ent.getKey(), ent.getValue());
        }
    }

    private void setFloat(MapValue m) {
        if (this.floatFields.size() == 0) {
            return;
        }
        Enumeration<StringFloatLinkedMap.StringFloatLinkedEntry> en = this.floatFields.entries();
        while (en.hasMoreElements()) {
            StringFloatLinkedMap.StringFloatLinkedEntry ent = en.nextElement();
            m.put(ent.getKey(), ent.getValue());
        }
    }

    private void setOther(MapValue m) {
        if (this.otherFields.size() == 0) {
            return;
        }
        Enumeration<StringKeyLinkedMap.StringKeyLinkedEntry<Value>> en = this.otherFields.entries();
        while (en.hasMoreElements()) {
            StringKeyLinkedMap.StringKeyLinkedEntry<Value> ent = en.nextElement();
            m.put(ent.getKey(), ent.getValue());
        }
    }
}

