/*
 * Decompiled with CFR 0.152.
 */
package whatap.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import whatap.agent.Logger;
import whatap.agent.tools.KubeUtil;
import whatap.util.FileUtil;
import whatap.util.HashUtil;

public class ContainerConf {
    private static long lasttime = -1L;
    private static final String WHATAP_HOME = "whatap.home";
    private static final String FILE_CONF_CONTAINER = "container.conf";
    private static int count = 11;
    private static URL url;
    private static String jarFilePath;

    public static void main(String[] args) {
        Logger.println("kube-exec-containerId", "run with args=" + args);
        if (args == null) {
            Logger.println("kube-exec-containerId", "args is null");
            return;
        }
        ContainerConf.initializeCount();
        int length = args.length;
        if (length == 2) {
            String path = args[1];
            int i = path.lastIndexOf("/");
            if (i > 0) {
                jarFilePath = path.substring(0, i);
                Logger.println("kube-exec-containerId", "args jar dir=" + jarFilePath);
            }
            ContainerConf.save(jarFilePath, args[0]);
            return;
        }
        if (length == 1) {
            ContainerConf.getJarFilePath();
            ContainerConf.save(jarFilePath, args[0]);
            return;
        }
    }

    private static void initializeCount() {
        count = 11;
    }

    private static void getJarFilePath() {
        URL url = ContainerConf.getURL(ContainerConf.class.getName(), "whatap/agent/ContainerConf.class");
        String filePath = ContainerConf.getFilePathFromURL(url);
        jarFilePath = ContainerConf.getJarFilePath(filePath);
    }

    private static String getJarFilePath(String fullJarFilePath) {
        char[] textChar = fullJarFilePath.toCharArray();
        int len = textChar.length;
        int rem = 0;
        boolean flag = false;
        for (int i = len - 1; i > 1; --i) {
            if (textChar[i] == '!') {
                flag = true;
            }
            if (textChar[i] != '/' || !flag) continue;
            rem = i;
            break;
        }
        String jarFilePath = fullJarFilePath.substring(0, rem);
        Logger.println("kube-exec-containerId", "current jar dir=" + jarFilePath);
        return jarFilePath;
    }

    private static String getFilePathFromURL(URL url) {
        String uriStr = null;
        try {
            uriStr = url.toURI().toString();
        }
        catch (URISyntaxException use) {
            use.printStackTrace();
        }
        assert (uriStr != null);
        String result = uriStr.startsWith("jar:") ? uriStr.substring("jar:file:".length()) : (uriStr.startsWith("file:") ? uriStr.substring("file:".length()) : uriStr);
        Logger.println("kube-exec-containerId", "uri=" + result);
        return result;
    }

    private static URL getURL(String className, String fileName) {
        try {
            Class<?> clazz = Class.forName(className);
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            if (classLoader == null) {
                Logger.println("kube-exec-containerId", "classLoader=" + classLoader);
                return null;
            }
            url = classLoader.getResource(fileName);
        }
        catch (ClassNotFoundException cnfe) {
            Logger.println("kube-exec-containerId", cnfe);
        }
        Logger.println("kube-exec-containerId", "url=" + url);
        assert (url != null);
        return url;
    }

    public static boolean containerConfExist() {
        String home = System.getProperty(WHATAP_HOME, ".");
        File containerConf = new File(home, FILE_CONF_CONTAINER);
        return containerConf.exists();
    }

    public static void load() {
        String home = System.getProperty(WHATAP_HOME, ".");
        File containerConf = new File(home, FILE_CONF_CONTAINER);
        if (ContainerConf.containerConfExist() && count-- > 0) {
            ContainerConf.load(containerConf);
        }
    }

    public static void save(String path, String containerId) {
        File containerConf = new File(path, FILE_CONF_CONTAINER);
        ContainerConf.save(containerConf, containerId);
        if (containerConf.lastModified() == lasttime) {
            return;
        }
        lasttime = containerConf.lastModified();
    }

    private static void save(File containerConf, String containerId) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(containerConf);
            Properties prop = new Properties();
            prop.put("containerId", containerId);
            prop.store(out, "created from kube exec");
        }
        catch (Exception e) {
            Logger.println("kube-exec-containerId", e);
            FileUtil.close(out);
        }
    }

    private static void load(File file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            Properties prop = new Properties();
            try {
                prop.load(in);
            }
            catch (Exception exception) {
                // empty catch block
            }
            String containerId = prop.getProperty("containerId");
            if (containerId != null && containerId.length() > 5) {
                KubeUtil.container_id = containerId;
                KubeUtil.container_key = HashUtil.hash(KubeUtil.container_id);
                String propertyContainerId = System.getProperty("whatap.container");
                if (propertyContainerId == null) {
                    System.setProperty("whatap.container", KubeUtil.container_id);
                } else if (!propertyContainerId.equals(KubeUtil.container_id)) {
                    System.setProperty("whatap.container", KubeUtil.container_id);
                }
                Logger.println("kube-exec-containerId", "containerId=" + containerId + "  KubeUtil.container_id=" + KubeUtil.container_id);
            }
        }
        catch (Exception e) {
            FileUtil.close(in);
        }
    }
}

